/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaNavigator;
import io.intino.konos.alexandria.activity.displays.AlexandriaTemporalCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaTimeRangeNavigator;
import io.intino.konos.alexandria.activity.displays.builders.CatalogBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaTemporalRangeCatalogNotifier;
import io.intino.konos.alexandria.activity.helpers.TimeScaleHandler;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.ItemList;
import io.intino.konos.alexandria.activity.model.TemporalCatalog;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.model.catalog.TemporalFilter;
import io.intino.konos.alexandria.activity.schemas.CreatePanelParameters;
import io.intino.konos.alexandria.activity.schemas.GroupingSelection;
import java.time.Instant;
import java.util.List;

public class AlexandriaTemporalRangeCatalog<DN extends AlexandriaTemporalRangeCatalogNotifier>
extends AlexandriaTemporalCatalog<DN, AlexandriaTimeRangeNavigator> {
    public AlexandriaTemporalRangeCatalog(Box box) {
        super(box, new AlexandriaTimeRangeNavigator(box));
    }

    @Override
    protected void sendCatalog() {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).refreshCatalog(CatalogBuilder.build((Catalog)this.element(), this.groupingManager, this.label(), this.embedded()));
    }

    @Override
    protected int maxZoom() {
        return ((TemporalCatalog)this.element()).maxZoom();
    }

    @Override
    protected void refreshBreadcrumbs(String breadcrumbs) {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).refreshBreadcrumbs(breadcrumbs);
    }

    @Override
    protected void createPanel(CreatePanelParameters params) {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).createPanel(params);
    }

    @Override
    protected void showPanel() {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).showPanel();
    }

    @Override
    protected void hidePanel() {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).hidePanel();
    }

    @Override
    protected void showDialog() {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).showDialog();
    }

    @Override
    protected void notifyFiltered(boolean value) {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).refreshFiltered(value);
    }

    @Override
    protected void configureTimeScaleHandler(TimeScaleHandler timeScaleHandler, TimeRange range, List<TimeScale> scales) {
        timeScaleHandler.updateScale(scales.get(0));
        timeScaleHandler.onScaleChange(this::refresh);
    }

    @Override
    protected void configureNavigatorDisplay(AlexandriaTimeRangeNavigator navigatorDisplay, TimeScaleHandler timeScaleHandler) {
        navigatorDisplay.onMove(this::refresh);
        navigatorDisplay.onFromChange(this::refresh);
        navigatorDisplay.onToChange(this::refresh);
        navigatorDisplay.onMoveNext(this::refresh);
        navigatorDisplay.onMovePrevious(this::refresh);
    }

    @Override
    protected void showNavigator() {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).showTimeRangeNavigator();
    }

    @Override
    protected void hideNavigator() {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).hideTimeRangeNavigator();
    }

    @Override
    protected void loadTimezoneOffset() {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).loadTimezoneOffset();
    }

    @Override
    protected void refreshNavigatorLayout(TemporalFilter.Layout layout) {
        ((AlexandriaTemporalRangeCatalogNotifier)this.notifier).refreshNavigatorLayout(layout.toString());
    }

    @Override
    protected TimeRange queryRange() {
        int offset = this.timezoneOffset();
        TimeRange range = this.timeScaleHandler().range();
        Instant newFrom = range.scale().normalise(range.from().plusSeconds(offset * 3600));
        Instant newTo = range.scale().nextTime(newFrom);
        while (!newTo.isAfter(range.to())) {
            newTo = range.scale().nextTime(newTo);
        }
        newTo = newTo.plusSeconds(offset * 3600).minusMillis(1L);
        return new TimeRange(newFrom, newTo, range.scale());
    }

    @Override
    protected void filterTimezone(ItemList itemList, TimeRange range) {
        if (this.showAll()) {
            return;
        }
        Instant from = range.from().plusSeconds(this.timezoneOffset() * 3600);
        Instant to = range.to().plusSeconds(this.timezoneOffset() * 3600);
        itemList.filter(item -> {
            Instant created = ((TemporalCatalog)this.element()).created((Item)item);
            return created.isAfter(from) && created.isBefore(to);
        });
    }

    @Override
    protected TimeScaleHandler timeScaleHandler() {
        return this.child(AlexandriaTimeRangeNavigator.class).timeScaleHandler();
    }

    @Override
    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    @Override
    public void clearFilter() {
        super.clearFilter();
    }

    public void timezoneOffset(Integer value) {
        super.timezoneOffset(value);
    }

    @Override
    public void navigate(String value) {
        super.navigate(value);
    }

    @Override
    public void navigateMain() {
        super.navigateMain();
    }

    @Override
    public <N extends AlexandriaNavigator> void configureTemporalNavigator(N navigator) {
        TimeScaleHandler timeScaleHandler = this.timeScaleHandler();
        navigator.timeScaleHandler(timeScaleHandler);
        this.configureNavigatorDisplay((AlexandriaTimeRangeNavigator)navigator, timeScaleHandler);
    }
}

