/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaAbstractCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogView;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogViewList;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaNavigator;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import io.intino.konos.alexandria.activity.displays.AlexandriaTemporalStamp;
import io.intino.konos.alexandria.activity.displays.providers.TemporalCatalogViewDisplayProvider;
import io.intino.konos.alexandria.activity.helpers.Bounds;
import io.intino.konos.alexandria.activity.helpers.TimeScaleHandler;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.ItemList;
import io.intino.konos.alexandria.activity.model.TemporalCatalog;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.model.catalog.Scope;
import io.intino.konos.alexandria.activity.model.catalog.TemporalFilter;
import io.intino.konos.alexandria.activity.model.catalog.views.DisplayView;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDialog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDisplay;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;

public abstract class AlexandriaTemporalCatalog<DN extends AlexandriaDisplayNotifier, N extends AlexandriaNavigator>
extends AlexandriaAbstractCatalog<TemporalCatalog, DN>
implements TemporalCatalogViewDisplayProvider {
    private N navigatorDisplay = null;

    public AlexandriaTemporalCatalog(Box box, N navigatorDisplay) {
        super(box);
        this.navigatorDisplay = navigatorDisplay;
    }

    public void selectRange(TimeRange range) {
        this.dirty(true);
        TimeScale scale = range.scale();
        TimeScale referenceScale = scale.ordinal() > TimeScale.Day.ordinal() ? scale : TimeScale.Day;
        Instant from = range.from();
        Instant to = referenceScale.addTo(range.to(), 1L);
        TimeRange bounds = ((TemporalCatalog)this.element()).range(this.session());
        if (from.isBefore(bounds.from())) {
            from = bounds.to();
        }
        if (to.isAfter(bounds.to())) {
            to = bounds.to();
        }
        this.timeScaleHandler().updateRange(from, to, false);
    }

    @Override
    public void forceRefresh() {
        this.reset();
    }

    @Override
    public void reset() {
        this.dirty(true);
        this.resetViews();
        this.refresh();
        this.reloadGroupings();
    }

    private void resetViews() {
        this.child(AlexandriaCatalogViewList.class).viewList().forEach(AlexandriaCatalogView::reset);
    }

    @Override
    public AlexandriaStamp display(String stampName) {
        EmbeddedDisplay stamp = (EmbeddedDisplay)this.stamp(stampName);
        AlexandriaTemporalStamp display = (AlexandriaTemporalStamp)stamp.createDisplay(this.session());
        display.range(this.timeScaleHandler().range());
        return display;
    }

    @Override
    public AlexandriaDialog dialog(String stampName) {
        EmbeddedDialog stamp = (EmbeddedDialog)this.stamp(stampName);
        return stamp.createDialog(this.session());
    }

    @Override
    public void refreshView() {
        super.refreshView();
        this.currentView().ifPresent(catalogView -> {
            AbstractView view = this.views().stream().filter(v -> v.name().equals(catalogView.view().name())).findFirst().orElse(null);
            if (view != null && view instanceof DisplayView && ((DisplayView)view).hideNavigator()) {
                this.hideNavigator();
            } else if (this.isNavigatorVisible()) {
                this.showNavigator();
            }
        });
    }

    @Override
    public TimeScale scale() {
        return this.timeScaleHandler().range().scale();
    }

    @Override
    public void refresh() {
        if (this.dirty()) {
            this.groupingManager.items(this.filteredItemList(this.defaultScope(), null).items());
            this.refreshGroupingsSelection();
            this.filterGroupingManager();
        }
        if (!this.isNavigatorVisible()) {
            this.hideNavigator();
        }
        this.refreshView();
    }

    @Override
    public Item rootItem(List<Item> itemList) {
        return ((TemporalCatalog)this.element()).rootItem(itemList, this.queryRange(), this.session());
    }

    @Override
    public Item defaultItem(String id) {
        return ((TemporalCatalog)this.element()).defaultItem(id, this.queryRange(), this.session());
    }

    @Override
    protected void loadItemList(String condition) {
        if (!this.dirty() && this.itemList != null) {
            return;
        }
        this.itemList = this.filteredItemList(this.scopeWithAttachedGrouping(), condition);
        this.range(this.timeScaleHandler().range());
        this.dirty(false);
    }

    @Override
    protected ItemList filteredItemList(Scope scope, String condition) {
        TimeRange range = this.showAll() ? this.timeScaleHandler().boundsRange() : this.queryRange();
        ItemList itemList = ((TemporalCatalog)this.element()).items(scope, condition, range, this.session());
        this.applyFilter(itemList);
        this.filterTimezone(itemList, range);
        return itemList;
    }

    @Override
    protected boolean canCreateClusters() {
        return false;
    }

    @Override
    protected void init() {
        TimeScaleHandler timeScaleHandler = this.buildTimeScaleHandler();
        this.buildNavigatorDisplay(timeScaleHandler);
        super.init();
        if (((TemporalCatalog)this.element()).temporalFilterLayout() != TemporalFilter.Layout.Horizontal) {
            this.refreshNavigatorLayout(((TemporalCatalog)this.element()).temporalFilterLayout());
        }
        ((AlexandriaDisplay)this.navigatorDisplay).personifyOnce(this.id());
        if (this.isNavigatorVisible()) {
            this.showNavigator();
        } else {
            this.hideNavigator();
        }
        this.loadTimezoneOffset();
    }

    protected void refresh(Instant instant) {
        this.refresh();
    }

    protected void refresh(TimeRange range) {
        this.refresh();
    }

    private void buildNavigatorDisplay(TimeScaleHandler timeScaleHandler) {
        ((AlexandriaNavigator)this.navigatorDisplay).timeScaleHandler(timeScaleHandler);
        this.configureNavigatorDisplay(this.navigatorDisplay, timeScaleHandler);
        this.add((AlexandriaDisplay)this.navigatorDisplay);
    }

    private TimeScaleHandler buildTimeScaleHandler() {
        TimeScaleHandler.Bounds bounds = new TimeScaleHandler.Bounds();
        List<TimeScale> scales = ((TemporalCatalog)this.element()).scales();
        HashMap<TimeScale, Bounds.Zoom> zoomMap = new HashMap<TimeScale, Bounds.Zoom>();
        bounds.rangeLoader(() -> {
            TimeRange range = ((TemporalCatalog)this.element()).range(this.session());
            return new TimeRange(range.from(), range.to(), TimeScale.Second);
        });
        bounds.mode(Bounds.Mode.ToTheLast);
        scales.forEach(scale -> zoomMap.put((TimeScale)((Object)scale), new Bounds.Zoom().min(1).max(this.maxZoom())));
        bounds.zooms(zoomMap);
        TimeScaleHandler timeScaleHandler = new TimeScaleHandler(bounds, scales, scales.get(0));
        timeScaleHandler.availableScales(scales);
        this.configureTimeScaleHandler(timeScaleHandler, ((TemporalCatalog)this.element()).range(this.session()), scales);
        return timeScaleHandler;
    }

    @Override
    public boolean dirty() {
        return super.dirty() || !this.equalsRange();
    }

    protected boolean equalsRange() {
        TimeRange range = this.timeScaleHandler().range();
        return this.range() != null && this.range().from() == range.from() && this.range().scale() == range.scale();
    }

    protected abstract int maxZoom();

    protected abstract void configureTimeScaleHandler(TimeScaleHandler var1, TimeRange var2, List<TimeScale> var3);

    protected abstract void configureNavigatorDisplay(N var1, TimeScaleHandler var2);

    protected abstract void filterTimezone(ItemList var1, TimeRange var2);

    protected abstract TimeRange queryRange();

    protected abstract TimeScaleHandler timeScaleHandler();

    protected abstract void showNavigator();

    protected abstract void hideNavigator();

    protected abstract void loadTimezoneOffset();

    protected abstract void refreshNavigatorLayout(TemporalFilter.Layout var1);

    private boolean isNavigatorVisible() {
        return ((TemporalCatalog)this.element()).temporalFilterVisible(this.defaultScope(), this.session());
    }

    protected boolean showAll() {
        return !((TemporalCatalog)this.element()).temporalFilterEnabled(this.defaultScope(), this.session());
    }
}

