/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.providers.ElementViewDisplayProvider;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.Panel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class AlexandriaPanelView<DN extends AlexandriaDisplayNotifier>
extends ActivityDisplay<DN, Box>
implements AlexandriaElementView<ElementViewDisplayProvider> {
    private Panel context;
    private Item target;
    private ElementView<Panel> view;
    private ElementViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<AlexandriaElementView.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemDialogEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemCatalogEvent>> openItemCatalogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemCatalogEvent>>();
    private List<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>>();

    public AlexandriaPanelView(Box box) {
        super(box);
    }

    public Panel context() {
        return this.context;
    }

    public void context(Panel context) {
        this.context = context;
    }

    public Item target() {
        return this.target;
    }

    public void target(Item target) {
        this.target = target;
    }

    @Override
    public ElementView<Panel> view() {
        return this.view;
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void refresh(io.intino.konos.alexandria.activity.schemas.Item ... items) {
        this.refresh();
    }

    public ElementViewDisplayProvider provider() {
        return this.provider;
    }

    @Override
    public void provider(ElementViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    @Override
    public void onOpenItemDialog(Consumer<AlexandriaElementView.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    @Override
    public void onOpenItemCatalog(Consumer<AlexandriaElementView.OpenItemCatalogEvent> listener) {
        this.openItemCatalogListeners.add(listener);
    }

    @Override
    public void onExecuteItemTask(Consumer<AlexandriaElementView.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    protected void notifyLoading(Boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    protected void notifyOpenItem(AlexandriaElementView.OpenItemEvent params) {
        this.openItemListeners.forEach(l -> l.accept(params));
    }

    protected void notifyOpenItemDialog(AlexandriaElementView.OpenItemDialogEvent params) {
        this.openItemDialogListeners.forEach(l -> l.accept(params));
    }

    protected void notifyOpenItemCatalog(AlexandriaElementView.OpenItemCatalogEvent params) {
        this.openItemCatalogListeners.forEach(l -> l.accept(params));
    }

    protected void notifyExecuteItemTaskOperation(AlexandriaElementView.ExecuteItemTaskEvent params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(params));
    }
}

