/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanelView;
import io.intino.konos.alexandria.activity.displays.CatalogInstantBlock;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaPanelDisplayViewNotifier;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.panel.View;
import io.intino.konos.alexandria.activity.model.renders.RenderDisplay;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class AlexandriaPanelDisplayView
extends AlexandriaPanelView<AlexandriaPanelDisplayViewNotifier> {
    public AlexandriaPanelDisplayView(Box box) {
        super(box);
    }

    @Override
    protected void init() {
        super.init();
        View rawView = (View)this.view().raw();
        RenderDisplay render = (RenderDisplay)rawView.render();
        AlexandriaDisplay display = render.display(this.target(), this.loadingListener(), this.instantListener());
        if (display == null) {
            return;
        }
        this.sendDisplayType(display);
        this.add(display);
        display.personifyOnce(this.id());
    }

    @Override
    public void refresh() {
        super.refresh();
        Optional.ofNullable(this.child(AlexandriaDisplay.class)).ifPresent(AlexandriaDisplay::refresh);
    }

    private void sendDisplayType(AlexandriaDisplay display) {
        ((AlexandriaPanelDisplayViewNotifier)this.notifier).displayType(display.name());
    }

    private Consumer<Boolean> loadingListener() {
        return value -> this.notifyLoading((Boolean)value);
    }

    private Consumer<CatalogInstantBlock> instantListener() {
        return block -> this.selectInstant((CatalogInstantBlock)block);
    }

    private void selectInstant(CatalogInstantBlock block) {
        AlexandriaCatalog display = (AlexandriaCatalog)this.provider().openElement(block.catalog());
        List<String> items = block.items();
        display.filterAndNotify(item -> items.contains(((Item)item).id()));
        display.refreshView();
    }
}

