/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaAbstractCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanelView;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaPanelCatalogViewNotifier;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.panel.View;
import io.intino.konos.alexandria.activity.model.renders.RenderCatalogs;

public class AlexandriaPanelCatalogView
extends AlexandriaPanelView<AlexandriaPanelCatalogViewNotifier> {
    private AlexandriaAbstractCatalog catalogDisplay = null;

    public AlexandriaPanelCatalogView(Box box) {
        super(box);
    }

    @Override
    protected void init() {
        super.init();
        this.createCatalogDisplay();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.catalogDisplay != null) {
            this.catalogDisplay.refresh();
        }
    }

    public <E extends AlexandriaElementDisplay> E catalogDisplay() {
        return (E)this.catalogDisplay;
    }

    private void createCatalogDisplay() {
        View rawView = (View)this.view().raw();
        RenderCatalogs render = (RenderCatalogs)rawView.render();
        Catalog catalog = render.catalogs().get(0);
        this.catalogDisplay = render.display(catalog, this.session());
        if (this.catalogDisplay == null) {
            return;
        }
        this.sendDisplayType(this.catalogDisplay);
        this.catalogDisplay.staticFilter(item -> render.filter(catalog, this.context(), this.target(), (Item)item, this.session()));
        this.catalogDisplay.target(this.target());
        this.catalogDisplay.elementDisplayManager(this.provider().elementDisplayManager());
        this.catalogDisplay.catalog(catalog);
        this.catalogDisplay.onLoading(value -> this.notifyLoading((Boolean)value));
        this.catalogDisplay.onOpenItem(params -> this.notifyOpenItem((AlexandriaElementView.OpenItemEvent)params));
        this.catalogDisplay.onOpenElement(params -> this.notifyOpenItem((AlexandriaElementView.OpenItemEvent)params));
        this.add(this.catalogDisplay);
        this.catalogDisplay.personifyOnce(this.id());
    }

    private void sendDisplayType(AlexandriaDisplay display) {
        ((AlexandriaPanelCatalogViewNotifier)this.notifier).displayType(display.name());
    }
}

