/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanelCatalogView;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanelCustomView;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanelDisplayView;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanelView;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.builders.ReferenceBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaPanelNotifier;
import io.intino.konos.alexandria.activity.displays.providers.ElementViewDisplayProvider;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.ElementRender;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.events.OnClickRecord;
import io.intino.konos.alexandria.activity.model.panel.View;
import io.intino.konos.alexandria.activity.model.renders.RenderCatalogs;
import io.intino.konos.alexandria.activity.model.renders.RenderDisplay;
import io.intino.konos.alexandria.activity.model.renders.RenderMold;
import io.intino.konos.alexandria.activity.schemas.CreatePanelParameters;
import io.intino.konos.alexandria.activity.schemas.Reference;
import io.intino.konos.alexandria.activity.schemas.ReferenceProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AlexandriaPanel<DN extends AlexandriaPanelNotifier>
extends AlexandriaElementDisplay<Panel, DN>
implements ElementViewDisplayProvider {
    protected Map<Class<? extends ElementRender>, Function<ElementRender, AlexandriaPanelView>> displayBuilders = new HashMap<Class<? extends ElementRender>, Function<ElementRender, AlexandriaPanelView>>();
    private Map<String, AlexandriaPanelView> viewDisplayMap = new HashMap<String, AlexandriaPanelView>();
    private static final String ViewId = "%s%s";

    public AlexandriaPanel(Box box) {
        super(box);
        this.registerBuilders();
    }

    @Override
    public void reset() {
    }

    @Override
    protected void refreshBreadcrumbs(String breadcrumbs) {
        ((AlexandriaPanelNotifier)this.notifier).refreshBreadcrumbs(breadcrumbs);
    }

    @Override
    protected void createPanel(CreatePanelParameters params) {
        ((AlexandriaPanelNotifier)this.notifier).createPanel(params);
    }

    @Override
    protected void showPanel() {
        ((AlexandriaPanelNotifier)this.notifier).showPanel();
    }

    @Override
    protected void hidePanel() {
        ((AlexandriaPanelNotifier)this.notifier).hidePanel();
    }

    @Override
    protected void showDialog() {
        ((AlexandriaPanelNotifier)this.notifier).showDialog();
    }

    @Override
    protected void currentItem(String id) {
    }

    @Override
    protected Item currentItem() {
        return this.target();
    }

    @Override
    protected void notifyFiltered(boolean value) {
    }

    @Override
    public <E extends AlexandriaElementDisplay> E openElement(String label) {
        View view = this.views().stream().filter(v -> {
            Object render = ((View)v).render();
            return render instanceof RenderCatalogs && this.renderContainsCatalogWithLabel((RenderCatalogs)render, label);
        }).map(v -> (View)v).findFirst().orElse(null);
        if (view != null) {
            AlexandriaPanelCatalogView viewDisplay = (AlexandriaPanelCatalogView)this.selectView(view.name());
            return viewDisplay.catalogDisplay();
        }
        return super.openElement(label);
    }

    private boolean renderContainsCatalogWithLabel(RenderCatalogs render, String label) {
        return render.catalogs().stream().anyMatch(c -> c.label() != null && c.label().equals(label));
    }

    @Override
    protected void init() {
        super.init();
        this.createDialogContainer();
        this.sendViewList();
        this.buildFixedViews();
        this.selectFirstTabView();
    }

    private void selectFirstTabView() {
        for (AbstractView view : this.views()) {
            if (((View)view).layout() != View.Layout.Tab) continue;
            this.selectView(view.name());
            break;
        }
    }

    private void sendViewList() {
        ((AlexandriaPanelNotifier)this.notifier).refreshViewList(this.views().stream().map(this::referenceOf).collect(Collectors.toList()));
    }

    private Reference referenceOf(AbstractView view) {
        Reference reference = ReferenceBuilder.build(view);
        reference.referencePropertyList().add(new ReferenceProperty().name("hidden").value(String.valueOf(view.hidden(this.target(), this.session()))));
        return reference;
    }

    private void registerBuilders() {
        this.displayBuilders.put(RenderMold.class, this::buildCustomViewDisplay);
        this.displayBuilders.put(RenderCatalogs.class, this::buildCatalogViewDisplay);
        this.displayBuilders.put(RenderDisplay.class, this::buildOlapViewDisplay);
    }

    private AlexandriaPanelCustomView buildCustomViewDisplay(ElementRender render) {
        return new AlexandriaPanelCustomView(this.box);
    }

    private AlexandriaPanelCatalogView buildCatalogViewDisplay(ElementRender render) {
        return new AlexandriaPanelCatalogView(this.box);
    }

    private AlexandriaPanelDisplayView buildOlapViewDisplay(ElementRender render) {
        return new AlexandriaPanelDisplayView(this.box);
    }

    public void buildFixedViews() {
        this.views().stream().filter(v -> {
            View view = (View)v;
            return view.layout() == View.Layout.LeftFixed || view.layout() == View.Layout.RightFixed;
        }).forEach(v -> this.buildView(v.name()).refresh());
    }

    public AlexandriaPanelView selectView(String key) {
        AbstractView view = this.viewOf(key);
        if (view == null) {
            return null;
        }
        AlexandriaPanelView viewDisplay = this.buildView(view.name());
        viewDisplay.refresh();
        this.updateCurrentView(viewDisplay);
        ((AlexandriaPanelNotifier)this.notifier).refreshSelectedView(view.name());
        return viewDisplay;
    }

    private AlexandriaPanelView buildView(String name) {
        if (this.viewDisplayMap.containsKey(name)) {
            return this.viewDisplayMap.get(name);
        }
        this.notifyLoading(true);
        AbstractView view = this.viewOf(name);
        AlexandriaPanelView display = this.buildView(view);
        this.viewDisplayMap.put(view.name(), display);
        this.notifyLoading(false);
        return display;
    }

    private AbstractView viewOf(String key) {
        return this.views().stream().filter(v -> v.label() != null && v.label().equals(key) || v.name().equals(key)).findFirst().orElse(null);
    }

    private AlexandriaPanelView buildView(AbstractView view) {
        View panelView = (View)view;
        Object render = panelView.render();
        AlexandriaPanelView display = this.displayBuilders.get(render.getClass()).apply((ElementRender)render);
        display.provider(this);
        display.view(this.panelViewOf(panelView));
        display.context((Panel)this.element());
        display.target(this.target());
        display.onLoading(v -> this.notifyLoading((Boolean)v));
        display.onOpenItem(params -> this.openItem((AlexandriaElementView.OpenItemEvent)params));
        display.onOpenItemDialog(params -> this.openItemDialog((AlexandriaElementView.OpenItemDialogEvent)params));
        display.onOpenItemCatalog(params -> this.openItemCatalog((AlexandriaElementView.OpenItemCatalogEvent)params));
        display.onExecuteItemTask(params -> this.executeItemTask((AlexandriaElementView.ExecuteItemTaskEvent)params));
        this.add(display);
        display.personifyOnce(this.viewId(view));
        return display;
    }

    private String viewId(AbstractView view) {
        return String.format(ViewId, this.id(), view.name());
    }

    @Override
    public void navigate(String key) {
        super.navigate(key);
    }

    protected ElementView<Panel> panelViewOf(final View view) {
        return new ElementView<Panel>(){

            @Override
            public String name() {
                return view.name();
            }

            @Override
            public String label() {
                return view.label();
            }

            @Override
            public String type() {
                return view.getClass().getSimpleName();
            }

            @Override
            public <V extends AbstractView> V raw() {
                return (V)view;
            }

            @Override
            public boolean embeddedElement() {
                return AlexandriaPanel.this.embedded();
            }

            @Override
            public Toolbar toolbar() {
                return this.element().toolbar();
            }

            @Override
            public int width() {
                return 100;
            }

            @Override
            public Mold mold() {
                Object render = view.render();
                if (render instanceof RenderMold) {
                    return ((RenderMold)render).mold();
                }
                return null;
            }

            @Override
            public OnClickRecord onClickRecordEvent() {
                return null;
            }

            @Override
            public boolean canCreateClusters() {
                return false;
            }

            @Override
            public boolean canSearch() {
                return false;
            }

            @Override
            public List<String> clusters() {
                return Collections.emptyList();
            }

            @Override
            public Item target() {
                return AlexandriaPanel.this.target();
            }

            @Override
            public Panel element() {
                return (Panel)AlexandriaPanel.this.element();
            }

            @Override
            public String emptyMessage() {
                return null;
            }
        };
    }
}

