/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementStore;
import io.intino.konos.alexandria.activity.displays.builders.PlatformInfoBuilder;
import io.intino.konos.alexandria.activity.displays.builders.ReferenceBuilder;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.ElementRender;
import io.intino.konos.alexandria.activity.model.ItemList;
import io.intino.konos.alexandria.activity.model.Layout;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.Settings;
import io.intino.konos.alexandria.activity.model.layout.ElementOption;
import io.intino.konos.alexandria.activity.model.layout.options.Group;
import io.intino.konos.alexandria.activity.model.layout.options.Option;
import io.intino.konos.alexandria.activity.model.layout.options.Options;
import io.intino.konos.alexandria.activity.model.panel.View;
import io.intino.konos.alexandria.activity.model.renders.RenderCatalogs;
import io.intino.konos.alexandria.activity.model.renders.RenderDisplay;
import io.intino.konos.alexandria.activity.model.renders.RenderMold;
import io.intino.konos.alexandria.activity.model.renders.RenderObjects;
import io.intino.konos.alexandria.activity.model.renders.RenderPanels;
import io.intino.konos.alexandria.activity.schemas.PlatformInfo;
import io.intino.konos.alexandria.activity.schemas.Reference;
import io.intino.konos.alexandria.activity.schemas.ReferenceProperty;
import io.intino.konos.alexandria.activity.schemas.UserInfo;
import io.intino.konos.alexandria.activity.services.push.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AlexandriaLayout<DN extends AlexandriaDisplayNotifier>
extends AlexandriaElementStore<DN> {
    private List<Item> items = new ArrayList<Item>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<Boolean>> loadedListeners = new ArrayList<Consumer<Boolean>>();
    protected Map<Class<? extends ElementRender>, Function<ElementRender, List<Item>>> itemsProviders = new HashMap<Class<? extends ElementRender>, Function<ElementRender, List<Item>>>();
    private Settings settings;

    public AlexandriaLayout(Box box) {
        super(box);
        this.buildElementProviders();
    }

    public AlexandriaLayout settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void onLoaded(Consumer<Boolean> listener) {
        this.loadedListeners.add(listener);
    }

    public void showHome() {
        if (this.items.size() <= 1) {
            return;
        }
        this.openElement(this.items.get(0).label());
    }

    @Override
    protected void refreshLoading(boolean withMessage) {
        this.sendLoading();
        this.loadingListeners.forEach(l -> l.accept(withMessage));
    }

    @Override
    protected void refreshLoaded() {
        this.sendLoaded();
        this.loadedListeners.forEach(l -> l.accept(true));
    }

    public void logout() {
        this.session().logout();
        this.notifyLoggedOut();
    }

    @Override
    protected void init() {
        super.init();
        this.sendInfo(this.info());
        User user = this.user();
        if (user != null) {
            this.sendUser(this.userOf(user));
        }
        this.sendItems();
        this.notifyLoaded();
    }

    @Override
    protected Element elementWithLabel(String label) {
        Item item = this.itemWithLabel(label);
        return item != null ? item.element() : null;
    }

    @Override
    protected io.intino.konos.alexandria.activity.model.Item targetWithLabel(String label) {
        Item item = this.itemWithLabel(label);
        return item != null ? item.target() : null;
    }

    @Override
    protected AlexandriaElementDisplay newDisplay(Element element, io.intino.konos.alexandria.activity.model.Item item) {
        return ((Layout)this.element()).displayFor(element, item);
    }

    protected Item itemWithLabel(String label) {
        return this.items.stream().filter(i -> i.label().equals(label)).findFirst().orElse(null);
    }

    public void selectItem(String label) {
        this.openElement(label);
    }

    protected Reference schemaItemOf(Item item) {
        Reference result = ReferenceBuilder.build(item.name(), item.label());
        List<ReferenceProperty> referenceProperties = result.referencePropertyList();
        referenceProperties.add(new ReferenceProperty().name("type").value(item.type()));
        referenceProperties.add(new ReferenceProperty().name("group").value(item.group() != null ? item.group().label() : null));
        referenceProperties.add(new ReferenceProperty().name("group_opened").value(item.group() != null ? String.valueOf(item.group().mode() == Group.Mode.Expanded) : null));
        return result;
    }

    protected abstract void sendLoading();

    protected abstract void sendLoaded();

    @Override
    protected abstract void refreshSelected(String var1);

    protected abstract void sendInfo(PlatformInfo var1);

    protected abstract void sendItems(List<Item> var1);

    protected abstract void sendUser(UserInfo var1);

    protected abstract void notifyLoggedOut();

    private List<Item> itemOf(ElementOption option) {
        ElementRender render = this.renderOf(option);
        if (render == null) {
            return Collections.emptyList();
        }
        return this.itemsProviders.get(render.getClass()).apply(render);
    }

    private ElementRender renderOf(ElementOption option) {
        if (option instanceof Option) {
            return ((Option)option).render();
        }
        if (option instanceof Options) {
            return ((Options)option).render();
        }
        return null;
    }

    private String labelOf(ElementRender render, Element element, io.intino.konos.alexandria.activity.model.Item item) {
        ElementOption owner = render.option();
        if (owner instanceof Option) {
            return ((Option)owner).label();
        }
        if (owner instanceof Group) {
            return ((Group)owner).label();
        }
        if (owner instanceof Options) {
            return ((Options)owner).label(element, item != null ? item.object() : null);
        }
        return "no label";
    }

    private List<Item> items() {
        return this.optionList().map(this::itemOf).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Stream<ElementOption> optionList() {
        return ((Layout)this.element()).options().stream().map(v -> {
            if (v instanceof Group) {
                return ((Group)v).options();
            }
            return Collections.singletonList(v);
        }).flatMap(Collection::stream);
    }

    private void sendItems() {
        this.items = this.items();
        this.sendItems(this.items);
    }

    private List<Item> panelItems(ElementRender r) {
        List<Panel> panelList = ((RenderPanels)r).panels();
        return panelList.stream().map(c -> this.itemOf(r, (Element)c)).collect(Collectors.toList());
    }

    private List<Item> objectItems(ElementRender r) {
        RenderObjects render = (RenderObjects)r;
        ItemList itemList = render.source(this.session());
        return itemList.items().stream().map(record -> this.itemOf(r, render.panel(), (io.intino.konos.alexandria.activity.model.Item)record)).collect(Collectors.toList());
    }

    private List<Item> catalogItems(ElementRender r) {
        RenderCatalogs render = (RenderCatalogs)r;
        return render.catalogs().stream().map(c -> this.itemOf(r, (Element)c)).collect(Collectors.toList());
    }

    private List<Item> moldItems(ElementRender r) {
        RenderMold render = (RenderMold)r;
        return Collections.singletonList(this.itemOf(r, render.mold()));
    }

    private List<Item> displayItem(ElementRender r) {
        Panel panel = new Panel();
        panel.views().add(new View().render(r).name(UUID.randomUUID().toString()));
        return Collections.singletonList(this.itemOf(r, panel));
    }

    private PlatformInfo info() {
        return PlatformInfoBuilder.build(this.settings);
    }

    private UserInfo userOf(User user) {
        return new UserInfo().fullName(user.fullName()).photo(user.photo().toString());
    }

    private void notifyLoaded() {
        this.loadedListeners.forEach(l -> l.accept(true));
    }

    private void buildElementProviders() {
        this.itemsProviders.put(RenderPanels.class, this::panelItems);
        this.itemsProviders.put(RenderObjects.class, this::objectItems);
        this.itemsProviders.put(RenderCatalogs.class, this::catalogItems);
        this.itemsProviders.put(RenderMold.class, this::moldItems);
        this.itemsProviders.put(RenderDisplay.class, this::displayItem);
    }

    private Item itemOf(ElementRender render, Element element) {
        return this.itemOf(render, element, null);
    }

    private Item itemOf(final ElementRender render, final Element element, final io.intino.konos.alexandria.activity.model.Item target) {
        return new Item(){

            @Override
            public String name() {
                return target != null ? target.name() : element.name();
            }

            @Override
            public String label() {
                return AlexandriaLayout.this.labelOf(render, element, target);
            }

            @Override
            public String type() {
                return AlexandriaDisplay.nameOf(((Layout)AlexandriaLayout.this.element()).displayTypeFor(element, target));
            }

            @Override
            public Group group() {
                return render.option().owner();
            }

            @Override
            public Element element() {
                return element;
            }

            @Override
            public io.intino.konos.alexandria.activity.model.Item target() {
                return target;
            }
        };
    }

    protected static interface Item {
        public String name();

        public String label();

        public String type();

        public Group group();

        public Element element();

        public io.intino.konos.alexandria.activity.model.Item target();
    }
}

