/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.Resource;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaAbstractCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.AlexandriaNavigator;
import io.intino.konos.alexandria.activity.displays.AlexandriaPageContainer;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import io.intino.konos.alexandria.activity.displays.AlexandriaTemporalCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaTemporalStamp;
import io.intino.konos.alexandria.activity.displays.AlexandriaTimeNavigator;
import io.intino.konos.alexandria.activity.displays.AlexandriaTimeRangeNavigator;
import io.intino.konos.alexandria.activity.displays.builders.ItemBuilder;
import io.intino.konos.alexandria.activity.displays.builders.MoldBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaItemNotifier;
import io.intino.konos.alexandria.activity.displays.providers.AlexandriaStampProvider;
import io.intino.konos.alexandria.activity.displays.providers.ItemDisplayProvider;
import io.intino.konos.alexandria.activity.helpers.ElementHelper;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.model.mold.Block;
import io.intino.konos.alexandria.activity.model.mold.Stamp;
import io.intino.konos.alexandria.activity.model.mold.stamps.CatalogLink;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedCatalog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDialog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDisplay;
import io.intino.konos.alexandria.activity.model.mold.stamps.Page;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogRange;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogRangeNavigator;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogTime;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogTimeNavigator;
import io.intino.konos.alexandria.activity.model.mold.stamps.Tree;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.DownloadOperation;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.ExportOperation;
import io.intino.konos.alexandria.activity.model.mold.stamps.pages.ExternalPage;
import io.intino.konos.alexandria.activity.model.mold.stamps.pages.InternalPage;
import io.intino.konos.alexandria.activity.schemas.DownloadItemParameters;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.schemas.ExecuteItemTaskParameters;
import io.intino.konos.alexandria.activity.schemas.ExportItemParameters;
import io.intino.konos.alexandria.activity.schemas.Item;
import io.intino.konos.alexandria.activity.schemas.ItemRefreshInfo;
import io.intino.konos.alexandria.activity.schemas.OpenElementParameters;
import io.intino.konos.alexandria.activity.schemas.OpenItemDialogParameters;
import io.intino.konos.alexandria.activity.schemas.PageLocation;
import io.intino.konos.alexandria.activity.schemas.Reference;
import io.intino.konos.alexandria.activity.schemas.SaveItemParameters;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AlexandriaItem
extends ActivityDisplay<AlexandriaItemNotifier, Box>
implements AlexandriaStampProvider {
    private Mold mold;
    private Element context;
    private io.intino.konos.alexandria.activity.model.Item item;
    private String mode;
    private ItemDisplayProvider provider;
    private List<Consumer<AlexandriaElementView.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemDialogEvent>>();
    private List<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>>();
    private boolean initialized = false;
    private String emptyMessage = null;

    public AlexandriaItem(Box box) {
        super(box);
    }

    public void mold(Mold mold) {
        this.mold = mold;
    }

    public void context(Element context) {
        this.context = context;
    }

    public void item(io.intino.konos.alexandria.activity.model.Item item) {
        this.item = item;
    }

    public void mode(String mode) {
        this.mode = mode;
    }

    public void provider(ItemDisplayProvider provider) {
        this.provider = provider;
    }

    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    public void onOpenItemDialog(Consumer<AlexandriaElementView.OpenItemDialogEvent> parameters) {
        this.openItemDialogListeners.add(parameters);
    }

    public void onExecuteItemTask(Consumer<AlexandriaElementView.ExecuteItemTaskEvent> parameters) {
        this.executeItemTaskListeners.add(parameters);
    }

    @Override
    protected void init() {
        super.init();
        this.sendEmptyMessage();
        this.sendMode();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.children(AlexandriaStamp.class).forEach(display -> {
            display.item(this.item);
            display.provider(this);
            this.updateRange((AlexandriaStamp)display);
            display.refresh();
        });
        this.remove(AlexandriaPageContainer.class);
        this.sendInfo();
    }

    public void refresh(Item item) {
        this.sendInfo(item);
    }

    public void itemStampsReady(String id) {
        if (!this.initialized) {
            this.createEmbeddedDisplays(id);
            this.initialized = true;
        }
        this.createPages(id);
    }

    public void notifyOpenItem(AlexandriaElementView.OpenItemEvent params) {
        this.openItemListeners.forEach(l -> l.accept(params));
    }

    public void openElement(OpenElementParameters params) {
        Stamp stamp = this.provider.stamp(this.mold, params.stamp().name());
        if (!(stamp instanceof CatalogLink)) {
            return;
        }
        CatalogLink catalogLinkStamp = (CatalogLink)stamp;
        AlexandriaAbstractCatalog display = (AlexandriaAbstractCatalog)this.provider.openElement(catalogLinkStamp.catalog().label());
        display.target(this.item);
        if (display instanceof AlexandriaTemporalCatalog && this.provider.range() != null) {
            ((AlexandriaTemporalCatalog)display).selectRange(this.provider.range());
        }
        if (catalogLinkStamp.openItemOnLoad()) {
            display.openItem(catalogLinkStamp.item(this.item, this.session()));
        } else {
            if (catalogLinkStamp.filtered()) {
                display.filterAndNotify(item -> catalogLinkStamp.filter(this.item, (io.intino.konos.alexandria.activity.model.Item)item, this.session()));
            }
            display.refresh();
        }
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openItemDialogListeners.forEach(l -> l.accept(ElementHelper.openItemDialogEvent(this.itemOf(params.item()), this.provider.stamp(this.mold, params.stamp()), this.session())));
    }

    public void executeItemTaskOperation(ExecuteItemTaskParameters params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(ElementHelper.executeItemTaskEvent(this.itemOf(params.item()), this.provider.stamp(this.mold, params.stamp()))));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters parameters) {
        Stamp stamp = this.provider.stamps(this.mold).stream().filter(s -> s.name().equals(parameters.stamp())).findFirst().orElse(null);
        if (stamp == null) {
            return null;
        }
        final Resource resource = ((DownloadOperation)stamp).execute(this.item, parameters.option(), this.session());
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.label();
            }

            @Override
            public InputStream content() {
                return resource.content();
            }
        };
    }

    public ActivityFile exportItemOperation(ExportItemParameters parameters) {
        Stamp stamp = this.provider.stamps(this.mold).stream().filter(s -> s.name().equals(parameters.stamp())).findFirst().orElse(null);
        if (stamp == null) {
            return null;
        }
        final Resource resource = ((ExportOperation)stamp).execute(this.item, parameters.from(), parameters.to(), parameters.option(), this.session());
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.label();
            }

            @Override
            public InputStream content() {
                return resource.content();
            }
        };
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, Collections.singletonList(this.item));
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, Collections.singletonList(this.item));
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.label();
            }

            @Override
            public InputStream content() {
                return resource.content();
            }
        };
    }

    @Override
    public AlexandriaStamp embeddedDisplay(String name) {
        Stamp stamp = this.provider.stamp(this.mold, name);
        if (stamp == null || !(stamp instanceof EmbeddedDisplay)) {
            return null;
        }
        return ((EmbeddedDisplay)stamp).createDisplay(this.session());
    }

    @Override
    public AlexandriaDialog embeddedDialog(String name) {
        Stamp stamp = this.provider.stamp(this.mold, name);
        if (stamp == null || !(stamp instanceof EmbeddedDialog)) {
            return null;
        }
        return ((EmbeddedDialog)stamp).createDialog(this.session());
    }

    @Override
    public AlexandriaAbstractCatalog embeddedCatalog(String name) {
        Stamp stamp = this.provider.stamp(this.mold, name);
        if (stamp == null || !(stamp instanceof EmbeddedCatalog)) {
            return null;
        }
        return ((EmbeddedCatalog)stamp).createCatalog(this.session());
    }

    public void saveItem(SaveItemParameters value) {
        this.provider.saveItem(value, this.item);
    }

    public void emptyMessage(String message) {
        this.emptyMessage = message;
    }

    public void openItem(final Reference reference) {
        this.openItemListeners.forEach(l -> l.accept(new AlexandriaElementView.OpenItemEvent(){

            @Override
            public String itemId() {
                return new String(Base64.getDecoder().decode(reference.name()));
            }

            @Override
            public String label() {
                return reference.label();
            }

            @Override
            public io.intino.konos.alexandria.activity.model.Item item() {
                return null;
            }

            @Override
            public Panel panel() {
                return (Panel)AlexandriaItem.this.context;
            }

            @Override
            public TimeRange range() {
                return AlexandriaItem.this.provider.range();
            }

            @Override
            public Tree breadcrumbs() {
                return null;
            }
        }));
    }

    private void sendInfo(Item item) {
        ((AlexandriaItemNotifier)this.notifier).refresh(new ItemRefreshInfo().mold(MoldBuilder.build(this.mold)).item(item));
    }

    private void sendInfo() {
        this.sendInfo(ItemBuilder.build(this.item, new ItemBuilder.ItemBuilderProvider(){

            @Override
            public List<Block> blocks() {
                return AlexandriaItem.this.provider.blocks(AlexandriaItem.this.mold);
            }

            @Override
            public List<Stamp> stamps() {
                return AlexandriaItem.this.provider.stamps(AlexandriaItem.this.mold);
            }

            @Override
            public ActivitySession session() {
                return AlexandriaItem.this.session();
            }

            @Override
            public TimeScale scale() {
                return AlexandriaItem.this.provider.range() != null ? AlexandriaItem.this.provider.range().scale() : null;
            }
        }, this.baseAssetUrl()));
    }

    private void sendEmptyMessage() {
        if (this.emptyMessage == null) {
            return;
        }
        ((AlexandriaItemNotifier)this.notifier).refreshEmptyMessage(this.emptyMessage);
    }

    private void sendMode() {
        ((AlexandriaItemNotifier)this.notifier).refreshMode(this.mode);
    }

    private PageLocation location(Stamp stamp, io.intino.konos.alexandria.activity.model.Item item) {
        PageLocation location = new PageLocation();
        if (stamp instanceof ExternalPage) {
            return location.value(((ExternalPage)stamp).url(item).toString()).internal(false);
        }
        return location.value(((InternalPage)stamp).path(item)).internal(true);
    }

    private AlexandriaAbstractCatalog displayFor(EmbeddedCatalog stamp) {
        AlexandriaAbstractCatalog result = stamp.createCatalog(this.session());
        if (result == null) {
            return null;
        }
        result.target(this.item);
        return result;
    }

    private void updateRange(AlexandriaStamp display) {
        if (!(display instanceof AlexandriaTemporalStamp)) {
            return;
        }
        AlexandriaTemporalStamp temporalDisplay = (AlexandriaTemporalStamp)display;
        temporalDisplay.range(this.provider.range());
    }

    private io.intino.konos.alexandria.activity.model.Item itemOf(String item) {
        return this.provider.item(new String(Base64.getDecoder().decode(item)));
    }

    private void createEmbeddedDisplays(String id) {
        this.createEmbeddedCustomDisplays(id);
        this.createEmbeddedDialogs(id);
        this.createEmbeddedCatalogs(id);
        this.createTemporalCatalogNavigators(id);
    }

    private void createEmbeddedCustomDisplays(String id) {
        this.embeddedCustomDisplays().forEach((key, display) -> {
            display.item(this.item);
            display.provider(this);
            this.add((AlexandriaDisplay)display);
            display.personifyOnce(id + key.displayType());
            this.updateRange((AlexandriaStamp)display);
            display.refresh();
        });
    }

    private Map<EmbeddedDisplay, AlexandriaStamp> embeddedCustomDisplays() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s instanceof EmbeddedDisplay).collect(Collectors.toList());
        Map mapWithNulls = stamps.stream().collect(HashMap::new, (map, stamp) -> map.put((EmbeddedDisplay)stamp, ((EmbeddedDisplay)stamp).createDisplay(this.session())), HashMap::putAll);
        return mapWithNulls.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void createEmbeddedDialogs(String id) {
        this.embeddedDialogs().forEach((key, dialog) -> {
            dialog.target(this.item);
            this.add((AlexandriaDisplay)dialog);
            dialog.personifyOnce(id + key.dialogType());
            dialog.refresh();
        });
    }

    private Map<EmbeddedDialog, AlexandriaDialog> embeddedDialogs() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s instanceof EmbeddedDialog).collect(Collectors.toList());
        Map mapWithNulls = stamps.stream().collect(HashMap::new, (map, stamp) -> map.put((EmbeddedDialog)stamp, ((EmbeddedDialog)stamp).createDialog(this.session())), HashMap::putAll);
        return mapWithNulls.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void createEmbeddedCatalogs(String id) {
        this.embeddedCatalogs().forEach((key, display) -> {
            display.staticFilter(item -> key.filter(this.context, this.item, (io.intino.konos.alexandria.activity.model.Item)item, this.session()));
            display.label(key.label());
            display.range(this.provider.range());
            display.onOpenItem(params -> this.notifyOpenItem((AlexandriaElementView.OpenItemEvent)params));
            display.embedded(true);
            this.add((AlexandriaDisplay)display);
            display.personifyOnce(id + key.name());
        });
    }

    private Map<EmbeddedCatalog, AlexandriaAbstractCatalog> embeddedCatalogs() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s instanceof EmbeddedCatalog).collect(Collectors.toList());
        return stamps.stream().collect(Collectors.toMap(s -> (EmbeddedCatalog)s, s -> this.displayFor((EmbeddedCatalog)s)));
    }

    private void createPages(String id) {
        this.pages(this.item).forEach(display -> {
            this.add((AlexandriaDisplay)display);
            display.personifyOnce(id);
            display.refresh();
        });
    }

    private List<AlexandriaDisplay> pages(io.intino.konos.alexandria.activity.model.Item item) {
        return this.provider.stamps(this.mold).stream().filter(s -> s instanceof Page).map(stamp -> new AlexandriaPageContainer(this.box).pageLocation(this.location((Stamp)stamp, item))).collect(Collectors.toList());
    }

    private void createTemporalCatalogNavigators(String id) {
        this.catalogTimeRanges().forEach((key, display) -> this.createTemporalCatalogNavigator(id, key.name(), (AlexandriaNavigator)display));
        this.catalogTimeRangeNavigators().forEach((key, display) -> this.createTemporalCatalogNavigator(id, key.name(), (AlexandriaNavigator)display));
        this.catalogTimes().forEach((key, display) -> this.createTemporalCatalogNavigator(id, key.name(), (AlexandriaNavigator)display));
        this.catalogTimeNavigators().forEach((key, display) -> this.createTemporalCatalogNavigator(id, key.name(), (AlexandriaNavigator)display));
    }

    private void createTemporalCatalogNavigator(String id, String name, AlexandriaNavigator navigator) {
        this.add(navigator);
        this.provider.configureTemporalNavigator(navigator);
        navigator.personifyOnce(id + name);
        navigator.refresh();
    }

    private Map<TemporalCatalogRange, AlexandriaTimeRangeNavigator> catalogTimeRanges() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s instanceof TemporalCatalogRange).collect(Collectors.toList());
        return stamps.stream().collect(Collectors.toMap(s -> (TemporalCatalogRange)s, s -> new AlexandriaTimeRangeNavigator(this.box)));
    }

    private Map<TemporalCatalogRangeNavigator, AlexandriaTimeRangeNavigator> catalogTimeRangeNavigators() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s instanceof TemporalCatalogRangeNavigator).collect(Collectors.toList());
        return stamps.stream().collect(Collectors.toMap(s -> (TemporalCatalogRangeNavigator)s, s -> new AlexandriaTimeRangeNavigator(this.box)));
    }

    private Map<TemporalCatalogTimeNavigator, AlexandriaTimeNavigator> catalogTimeNavigators() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s instanceof TemporalCatalogTimeNavigator).collect(Collectors.toList());
        return stamps.stream().collect(Collectors.toMap(s -> (TemporalCatalogTimeNavigator)s, s -> new AlexandriaTimeNavigator(this.box)));
    }

    private Map<TemporalCatalogTime, AlexandriaTimeNavigator> catalogTimes() {
        List stamps = this.provider.stamps(this.mold).stream().filter(s -> s instanceof TemporalCatalogTime).collect(Collectors.toList());
        return stamps.stream().collect(Collectors.toMap(s -> (TemporalCatalogTime)s, s -> new AlexandriaTimeNavigator(this.box)));
    }
}

