/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.displays.ElementDisplayManager;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.Layout;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AlexandriaElementStore<DN extends AlexandriaDisplayNotifier>
extends AlexandriaElementDisplay<Layout, DN>
implements ElementDisplayManager {
    private Map<String, AlexandriaElementDisplay> displayMap = new HashMap<String, AlexandriaElementDisplay>();
    private String selected = null;

    public AlexandriaElementStore(Box box) {
        super(box);
    }

    @Override
    public <E extends AlexandriaElementDisplay> E openElement(String label) {
        Element element = this.elementWithLabel(label);
        Item target = this.targetWithLabel(label);
        E display = this.displayWithLabel(label);
        if (label.equals(this.selected)) {
            return display;
        }
        this.selected = label;
        if (display != null) {
            ((AlexandriaElementDisplay)display).clearFilter();
            this.refreshSelected(label);
            return display;
        }
        this.refreshLoading(true);
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        display = this.addAndBuildDisplay(element, target, label);
        this.refreshLoaded();
        this.refreshSelected(label);
        return display;
    }

    @Override
    public <E extends AlexandriaElementDisplay> E createElement(Element element, Item target) {
        E display = this.displayWithLabel(target.name());
        if (display != null) {
            return display;
        }
        return this.buildDisplay(element, target, target.name());
    }

    @Override
    public void removeElement(Item item) {
        if (!this.displayMap.containsKey(item.name())) {
            return;
        }
        this.displayMap.remove(item.name());
    }

    @Override
    public <E extends AlexandriaElementDisplay> E displayWithLabel(String label) {
        return (E)((AlexandriaElementDisplay)this.displayMap.getOrDefault(label, null));
    }

    protected abstract void refreshSelected(String var1);

    protected abstract void refreshLoading(boolean var1);

    protected abstract void refreshLoaded();

    protected abstract Element elementWithLabel(String var1);

    protected abstract Item targetWithLabel(String var1);

    protected abstract AlexandriaElementDisplay newDisplay(Element var1, Item var2);

    protected Class classFor(Element element) {
        return element.getClass();
    }

    private <E extends AlexandriaElementDisplay> E addAndBuildDisplay(Element element, Item target, String label) {
        E display = this.buildDisplay(element, target, label);
        ((AlexandriaDisplay)display).personifyOnce(this.id() + label);
        return display;
    }

    private <E extends AlexandriaElementDisplay> E buildDisplay(Element element, Item target, String label) {
        E display = this.buildDisplayFor(element, target, label);
        ((AlexandriaElementDisplay)display).elementDisplayManager(this);
        this.add((AlexandriaDisplay)display);
        ((AlexandriaElementDisplay)display).onLoading(value -> {
            if (((Boolean)value).booleanValue()) {
                this.refreshLoading(false);
            } else {
                this.refreshLoaded();
            }
        });
        return display;
    }

    private <E extends AlexandriaElementDisplay> E buildDisplayFor(Element element, Item target, String label) {
        Class clazz = this.classFor(element);
        AlexandriaElementDisplay display = this.newDisplay(element, target);
        display.label(label);
        display.element(element);
        display.target(target);
        this.displayMap.put(label, display);
        return (E)display;
    }
}

