/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import com.google.gson.Gson;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.Resource;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaAbstractCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialogContainer;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.AlexandriaPanel;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import io.intino.konos.alexandria.activity.displays.CatalogInstantBlock;
import io.intino.konos.alexandria.activity.displays.ElementDisplayManager;
import io.intino.konos.alexandria.activity.displays.builders.ItemBuilder;
import io.intino.konos.alexandria.activity.helpers.ElementHelper;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.ItemList;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.Events;
import io.intino.konos.alexandria.activity.model.catalog.View;
import io.intino.konos.alexandria.activity.model.catalog.events.OnClickRecord;
import io.intino.konos.alexandria.activity.model.catalog.views.DisplayView;
import io.intino.konos.alexandria.activity.model.catalog.views.MoldView;
import io.intino.konos.alexandria.activity.model.mold.Block;
import io.intino.konos.alexandria.activity.model.mold.Stamp;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDialog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDisplay;
import io.intino.konos.alexandria.activity.model.mold.stamps.Title;
import io.intino.konos.alexandria.activity.model.mold.stamps.Tree;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.TaskOperation;
import io.intino.konos.alexandria.activity.model.toolbar.Download;
import io.intino.konos.alexandria.activity.model.toolbar.DownloadSelection;
import io.intino.konos.alexandria.activity.model.toolbar.Export;
import io.intino.konos.alexandria.activity.model.toolbar.ExportSelection;
import io.intino.konos.alexandria.activity.model.toolbar.OpenDialog;
import io.intino.konos.alexandria.activity.model.toolbar.Operation;
import io.intino.konos.alexandria.activity.model.toolbar.Task;
import io.intino.konos.alexandria.activity.model.toolbar.TaskSelection;
import io.intino.konos.alexandria.activity.schemas.CreatePanelParameters;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.schemas.Item;
import io.intino.konos.alexandria.activity.schemas.SaveItemParameters;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AlexandriaElementDisplay<E extends Element, DN extends AlexandriaDisplayNotifier>
extends ActivityDisplay<DN, Box>
implements ItemBuilder.ItemBuilderProvider {
    private String label;
    private E element;
    private io.intino.konos.alexandria.activity.model.Item target;
    private ElementDisplayManager elementDisplayManager = null;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private AlexandriaElementView currentView = null;
    private Function<io.intino.konos.alexandria.activity.model.Item, Boolean> staticFilter = null;
    private Function<io.intino.konos.alexandria.activity.model.Item, Boolean> dynamicFilter = null;
    private Boolean dirty = null;
    private boolean embedded = false;
    private AlexandriaElementView.OpenItemEvent openedItem = null;
    private TimeRange range;
    private List<String> enabledViews = null;
    private AlexandriaPanel openedItemDisplay = null;
    private AlexandriaDialogContainer dialogContainer = null;

    public AlexandriaElementDisplay(Box box) {
        super(box);
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public E element() {
        return this.element;
    }

    public void element(E element) {
        this.element = element;
    }

    public io.intino.konos.alexandria.activity.model.Item target() {
        return this.target;
    }

    public void target(io.intino.konos.alexandria.activity.model.Item target) {
        this.target = target;
    }

    public ElementDisplayManager elementDisplayManager() {
        return this.elementDisplayManager;
    }

    public void elementDisplayManager(ElementDisplayManager manager) {
        this.elementDisplayManager = manager;
    }

    public TimeRange range() {
        return this.range;
    }

    public void range(TimeRange range) {
        this.range = range;
    }

    public boolean embedded() {
        return this.embedded;
    }

    public void embedded(boolean value) {
        this.embedded = value;
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void staticFilter(Function<io.intino.konos.alexandria.activity.model.Item, Boolean> filter) {
        this.staticFilter = filter;
        this.dirty(true);
    }

    public void dynamicFilter(Function<io.intino.konos.alexandria.activity.model.Item, Boolean> filter) {
        this.dynamicFilter = filter;
        this.dirty(true);
    }

    public void filterAndNotify(Function<io.intino.konos.alexandria.activity.model.Item, Boolean> filter) {
        this.dynamicFilter(filter);
        this.notifyFiltered(filter != null);
    }

    public void clearFilter() {
        boolean hasDynamicFilters = this.dynamicFilter != null;
        this.filterAndNotify(null);
        if (!hasDynamicFilters) {
            return;
        }
        this.target(null);
        this.refresh();
    }

    @Override
    public List<Block> blocks() {
        return this.molds().stream().map(this::blocks).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Block> blocks(Mold mold) {
        return mold.blocks().stream().map(this::blocks).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Block> blocks(Block block) {
        ArrayList<Block> result = new ArrayList<Block>();
        result.add(block);
        block.blockList().forEach(child -> result.addAll(this.blocks((Block)child)));
        return result;
    }

    @Override
    public List<Stamp> stamps() {
        return this.molds().stream().map(Mold::blocks).flatMap(Collection::stream).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Stamp> stamps(Mold mold) {
        return mold.blocks().stream().map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Stamp> stamps(Block block) {
        ArrayList<Stamp> stamps = new ArrayList<Stamp>();
        stamps.addAll(block.stampList());
        block.blockList().forEach(child -> stamps.addAll(this.stamps((Block)child)));
        return stamps;
    }

    public List<Stamp> expandedStamps() {
        return this.molds().stream().map(Mold::blocks).flatMap(Collection::stream).filter(Block::expanded).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Stamp> expandedStamps(Mold mold) {
        return mold.blocks().stream().filter(Block::expanded).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Stamp stamp(Mold mold, String name) {
        return this.stamps(mold).stream().filter(s -> s.name().equals(name)).findFirst().orElse(null);
    }

    public Stamp stamp(String name) {
        return this.stamps().stream().filter(s -> s.name().equals(name)).findFirst().orElse(null);
    }

    public AlexandriaStamp display(String stampKey) {
        return ((EmbeddedDisplay)this.stamp(stampKey)).createDisplay(this.session());
    }

    public AlexandriaDialog dialog(String stampKey) {
        return ((EmbeddedDialog)this.stamp(stampKey)).createDialog(this.session());
    }

    public void executeOperation(ElementOperationParameters params, List<io.intino.konos.alexandria.activity.model.Item> selection) {
        Operation operation = this.operationOf(params);
        this.executeOperation(operation, params.option(), selection);
    }

    public Resource downloadOperation(ElementOperationParameters params, List<io.intino.konos.alexandria.activity.model.Item> selection) {
        Operation operation = this.operationOf(params);
        return this.downloadOperation(operation, params, selection);
    }

    public void saveItem(SaveItemParameters params, io.intino.konos.alexandria.activity.model.Item item) {
        Stamp stamp = this.stamp(params.stamp());
        if (!stamp.editable()) {
            return;
        }
        this.currentItem(new String(Base64.getDecoder().decode(params.item())));
        Stamp.Editable.Refresh refresh = stamp.save(item, params.value(), this.session());
        this.currentView().ifPresent(view -> {
            this.dirty(true);
            if (refresh == Stamp.Editable.Refresh.Object) {
                view.refresh(this.currentItem_());
            } else if (refresh == Stamp.Editable.Refresh.Catalog) {
                view.refresh();
            }
        });
    }

    public Optional<AlexandriaElementView> currentView() {
        return Optional.ofNullable(this.currentView);
    }

    @Override
    public TimeScale scale() {
        return null;
    }

    public abstract void reset();

    public void forceRefresh() {
        this.dirty(true);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshView();
    }

    public void refreshView() {
        this.currentView().ifPresent(AlexandriaElementView::refresh);
    }

    public void refresh(io.intino.konos.alexandria.activity.model.Item ... objects) {
        this.currentView().ifPresent(v -> v.refresh(ElementHelper.items(objects, this, this.baseAssetUrl())));
    }

    public boolean dirty() {
        return this.dirty == null || this.dirty != false;
    }

    public void dirty(boolean value) {
        this.dirty = value;
    }

    public void navigate(String key) {
        String name = new String(Base64.getDecoder().decode(key.getBytes()));
        if (!name.equals("main")) {
            return;
        }
        this.navigateMain();
    }

    public void navigateMain() {
        this.hidePanel();
        this.refreshBreadcrumbs("");
        this.refresh();
        this.removePanelDisplay();
    }

    public void selectInstant(CatalogInstantBlock block) {
        AlexandriaAbstractCatalog display = this.catalogDisplayOf(block);
        List<String> items = block.items();
        display.filterAndNotify(item -> items.contains(((io.intino.konos.alexandria.activity.model.Item)item).id()));
        display.refreshViews();
    }

    public void enabledViews(List<String> views) {
        this.enabledViews = views;
    }

    public <E extends AlexandriaElementDisplay> E openElement(String label) {
        return this.elementDisplayManager.openElement(label);
    }

    public void openItem(final String item) {
        this.openItem(new AlexandriaElementView.OpenItemEvent(){

            @Override
            public String label() {
                if (AlexandriaElementDisplay.this.molds().size() <= 0) {
                    return item;
                }
                Optional<Stamp> titleStamp = AlexandriaElementDisplay.this.stamps(AlexandriaElementDisplay.this.molds().get(0)).stream().filter(s -> s instanceof Title).findAny();
                return titleStamp.isPresent() ? (String)((Title)titleStamp.get()).value(this.item(), AlexandriaElementDisplay.this.session()) : this.item().name();
            }

            @Override
            public String itemId() {
                return item;
            }

            @Override
            public io.intino.konos.alexandria.activity.model.Item item() {
                return AlexandriaElementDisplay.this.item(item);
            }

            @Override
            public Panel panel() {
                Object element = AlexandriaElementDisplay.this.element();
                if (!(element instanceof Catalog)) {
                    return null;
                }
                Events events = ((Catalog)element).events();
                if (events == null) {
                    return null;
                }
                OnClickRecord onClickRecord = events.onClickRecord();
                return onClickRecord != null && onClickRecord.openPanel() != null ? onClickRecord.openPanel().panel() : null;
            }

            @Override
            public TimeRange range() {
                return AlexandriaElementDisplay.this.range();
            }

            @Override
            public Tree breadcrumbs() {
                Object element = AlexandriaElementDisplay.this.element();
                if (!(element instanceof Catalog)) {
                    return null;
                }
                Events events = ((Catalog)element).events();
                if (events == null) {
                    return null;
                }
                OnClickRecord onClickRecord = events.onClickRecord();
                return onClickRecord != null && onClickRecord.openPanel() != null ? onClickRecord.openPanel().breadcrumbs(this.item(), AlexandriaElementDisplay.this.session()) : null;
            }
        });
    }

    private AlexandriaAbstractCatalog catalogDisplayOf(CatalogInstantBlock block) {
        if (!((Element)this.element).name().equals(block.catalog()) && !((Element)this.element).label().equals(block.catalog())) {
            return (AlexandriaAbstractCatalog)this.openElement(block.catalog());
        }
        AlexandriaAbstractCatalog display = (AlexandriaAbstractCatalog)this;
        List<AbstractView> views = display.views();
        View view = views.stream().map(v -> (View)v).filter(v -> !(v instanceof DisplayView)).findFirst().orElse(null);
        if (view != null) {
            display.selectView(view.name());
        }
        return display;
    }

    protected void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    protected List<? extends AbstractView> views() {
        List<AbstractView> elementViews = ((Element)this.element()).views();
        if (this.enabledViews == null) {
            return elementViews;
        }
        return elementViews.stream().filter(v -> this.enabledViews.contains(v.name())).collect(Collectors.toList());
    }

    protected List<Mold> molds() {
        return this.views().stream().filter(v -> v instanceof MoldView).map(v -> ((MoldView)v).mold()).collect(Collectors.toList());
    }

    protected void updateCurrentView(AlexandriaElementView display) {
        this.currentView = display;
        this.refreshView();
    }

    protected void createDialogContainer() {
        this.dialogContainer = new AlexandriaDialogContainer(this.box);
        this.dialogContainer.onDialogAssertion(modification -> this.currentView().ifPresent(view -> {
            this.dirty(true);
            if (modification.toLowerCase().equals("itemmodified")) {
                view.refresh(this.currentItem_());
            } else if (modification.toLowerCase().equals("catalogmodified")) {
                view.refresh();
            }
        }));
        this.add(this.dialogContainer);
        this.dialogContainer.personifyOnce();
    }

    protected void openItem(AlexandriaElementView.OpenItemEvent event) {
        this.removePanelDisplay();
        this.openedItem = event;
        AlexandriaPanel display = this.createPanelDisplay(event);
        this.createPanel(new CreatePanelParameters().displayType(display.getClass().getSimpleName()).item(event.itemId()));
        this.add(display);
        display.personifyOnce(event.itemId());
        this.showPanel();
        this.refreshBreadcrumbs(this.breadcrumbs(event));
    }

    protected void closeCurrentItem() {
        this.openedItem = null;
        this.navigateMain();
    }

    protected void removePanelDisplay() {
        if (this.openedItem == null) {
            return;
        }
        this.elementDisplayManager.removeElement(this.openedItem.item());
        this.remove(AlexandriaPanel.class);
    }

    protected void openItemDialog(AlexandriaElementView.OpenItemDialogEvent event) {
        this.currentItem(event.item().id());
        this.dialogContainer.dialog(event.dialog());
        this.dialogContainer.refresh();
        this.showDialog();
    }

    protected void openItemCatalog(AlexandriaElementView.OpenItemCatalogEvent event) {
        E display = this.openElement(event.catalog().label());
        String itemToShow = event.itemToShow();
        if (itemToShow != null) {
            ((AlexandriaElementDisplay)display).openItem(itemToShow);
        } else {
            ((AlexandriaElementDisplay)display).closeCurrentItem();
            if (event.filtered()) {
                ((AlexandriaElementDisplay)display).filterAndNotify(i -> event.filter((io.intino.konos.alexandria.activity.model.Item)i));
            }
            ((AlexandriaElementDisplay)display).refresh();
        }
    }

    protected void executeItemTask(AlexandriaElementView.ExecuteItemTaskEvent event) {
        this.currentItem(event.item().id());
        io.intino.konos.alexandria.activity.model.Item item = this.currentItem();
        ((TaskOperation)event.stamp()).execute(item, this.session());
        this.dirty(true);
        this.refresh(this.currentItem());
    }

    public AlexandriaPanel createPanelDisplay(AlexandriaElementView.OpenItemEvent event) {
        AlexandriaPanel display = (AlexandriaPanel)this.elementDisplayManager.createElement(event.panel(), event.item());
        display.range(event.range());
        return display;
    }

    public io.intino.konos.alexandria.activity.model.Item item(String key) {
        return this.target;
    }

    protected abstract void showDialog();

    protected abstract void currentItem(String var1);

    protected abstract io.intino.konos.alexandria.activity.model.Item currentItem();

    protected abstract void notifyFiltered(boolean var1);

    protected abstract void refreshBreadcrumbs(String var1);

    protected abstract void createPanel(CreatePanelParameters var1);

    protected abstract void showPanel();

    protected abstract void hidePanel();

    protected void applyFilter(ItemList itemList) {
        if (this.staticFilter != null) {
            itemList.filter(this.staticFilter);
        }
        if (this.dynamicFilter != null) {
            itemList.filter(this.dynamicFilter);
        }
    }

    private Item currentItem_() {
        return ElementHelper.item(this.currentItem(), this, this.baseAssetUrl());
    }

    private Operation operationOf(ElementOperationParameters params) {
        Optional<Toolbar> toolbar = this.toolbar();
        if (!toolbar.isPresent()) {
            return null;
        }
        return toolbar.get().operations().stream().filter(op -> op.name().equals(params.operation())).findFirst().orElse(null);
    }

    private Optional<Toolbar> toolbar() {
        return Optional.ofNullable(((Element)this.element()).toolbar());
    }

    private void executeOperation(Operation operation, String option, List<io.intino.konos.alexandria.activity.model.Item> selection) {
        if (operation instanceof OpenDialog) {
            OpenDialog openDialog = (OpenDialog)operation;
            this.dialogContainer.dialog(openDialog.createDialog(this.session()));
            this.dialogContainer.refresh();
            this.showDialog();
        }
        if (operation instanceof Task) {
            Task taskOperation = (Task)operation;
            Task.Refresh refresh = taskOperation.execute((Element)this.element(), option, this.session());
            if (refresh == Task.Refresh.Catalog) {
                this.refresh();
            }
            return;
        }
        if (operation instanceof TaskSelection) {
            TaskSelection taskSelectionOperation = (TaskSelection)operation;
            TaskSelection.Refresh refresh = taskSelectionOperation.execute((Element)this.element(), option, selection, this.session());
            if (refresh == TaskSelection.Refresh.Catalog) {
                this.refresh();
            } else if (refresh == TaskSelection.Refresh.Selection) {
                this.refresh(selection.toArray(new io.intino.konos.alexandria.activity.model.Item[selection.size()]));
            }
        }
    }

    private Resource downloadOperation(Operation operation, ElementOperationParameters params, List<io.intino.konos.alexandria.activity.model.Item> selection) {
        E element = this.element();
        ActivitySession session = this.session();
        if (operation instanceof Export) {
            return ((Export)operation).execute((Element)element, params.from(), params.to(), session);
        }
        if (operation instanceof ExportSelection) {
            return ((ExportSelection)operation).execute((Element)element, params.from(), params.to(), selection, session);
        }
        if (operation instanceof Download) {
            return ((Download)operation).execute((Element)element, params.option(), session);
        }
        if (operation instanceof DownloadSelection) {
            return ((DownloadSelection)operation).execute((Element)element, params.option(), selection, session);
        }
        return null;
    }

    private String breadcrumbs(AlexandriaElementView.OpenItemEvent event) {
        Tree tree = event.breadcrumbs();
        if (tree == null) {
            tree = new Tree();
            Tree.TreeItem main = new Tree.TreeItem().name("main").label(this.label());
            if (this.openedItem != null) {
                main.add(new Tree.TreeItem().name(this.openedItem.item().name()).label(this.openedItem.label()));
            }
            tree.add(main);
        }
        return new Gson().toJson((Object)tree);
    }
}

