/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.MessageCarrier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AlexandriaDisplayNotifier {
    AlexandriaDisplay display;
    MessageCarrier carrier;

    public AlexandriaDisplayNotifier(AlexandriaDisplay display, MessageCarrier carrier) {
        this.display = display;
        this.carrier = carrier;
    }

    public void personify(String id, String name) {
        this.put("personify", this.initializationParameters(id, name));
    }

    public void personify(String id, String name, String object) {
        this.put("personify", this.initializationParameters(id, name, object));
    }

    public void personifyOnce(String id, String name) {
        this.put("personifyOnce", this.initializationParameters(id, name));
    }

    public void personifyOnce(String id, String name, String object) {
        this.put("personifyOnce", this.initializationParameters(id, name, object));
    }

    public void die(String id) {
        this.put("die", Collections.singletonMap("id", id));
    }

    protected void put(String message) {
        this.put(message, this.addIdAndNameTo(new HashMap<String, Object>()));
    }

    protected void put(String message, Map<String, Object> parameters) {
        this.carrier.notifyClient(message, this.addIdAndNameTo(parameters));
    }

    protected void put(String message, Object parameter) {
        this.carrier.notifyClient(message, this.addIdAndNameTo(Collections.singletonMap(message, parameter)));
    }

    protected void put(String message, String parameter, Object value) {
        this.carrier.notifyClient(message, this.addIdAndNameTo(Collections.singletonMap(parameter, value)));
    }

    protected void putToDisplay(String message, Map<String, Object> parameters) {
        this.carrier.notifyClient(message, this.addIdAndNameTo(parameters));
    }

    protected void putToDisplay(String message) {
        this.putToDisplay(message, this.addIdAndNameTo(new HashMap<String, Object>()));
    }

    protected void putToDisplay(String message, Object parameter) {
        this.carrier.notifyClient(message, this.addIdAndNameTo(Collections.singletonMap(message, parameter)));
    }

    protected void putToDisplay(String message, String parameter, Object value) {
        this.carrier.notifyClient(message, this.addIdAndNameTo(Collections.singletonMap(parameter, value)));
    }

    protected void putToAll(String message) {
        this.putToAll(message, this.addIdAndNameTo(new HashMap<String, Object>()));
    }

    protected void putToAll(String message, Map<String, Object> parameters) {
        this.carrier.notifyAll(message, this.addIdAndNameTo(parameters));
    }

    protected void putToAll(String message, Object parameter) {
        this.carrier.notifyAll(message, this.addIdAndNameTo(Collections.singletonMap(message, parameter)));
    }

    protected void putToAll(String message, String parameter, Object value) {
        this.carrier.notifyAll(message, this.addIdAndNameTo(Collections.singletonMap(parameter, value)));
    }

    private Map<String, Object> addIdAndNameTo(Map<String, Object> parameters) {
        HashMap<String, Object> parametersWithId = new HashMap<String, Object>(parameters);
        parametersWithId.put("id", this.display.id());
        parametersWithId.put("name", this.display.name());
        return parametersWithId;
    }

    private Map<String, Object> initializationParameters(String id, String name) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", id);
        parameters.put("display", name);
        return parameters;
    }

    private Map<String, Object> initializationParameters(String id, String name, String object) {
        Map<String, Object> parameters = this.initializationParameters(id, name);
        parameters.put("object", object);
        return parameters;
    }
}

