/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.activity.Asset;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.DisplayRepository;
import io.intino.konos.alexandria.activity.displays.International;
import io.intino.konos.alexandria.activity.displays.Soul;
import io.intino.konos.alexandria.activity.displays.SoulProvider;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class AlexandriaDisplay<N extends AlexandriaDisplayNotifier> {
    private final String id;
    private final List<AlexandriaDisplay> children = new ArrayList<AlexandriaDisplay>();
    protected DisplayRepository repository;
    protected N notifier;
    private SoulProvider soulProvider;
    private ActivitySession session;

    public AlexandriaDisplay() {
        this.id = UUID.randomUUID().toString();
    }

    public void inject(ActivitySession session) {
        this.session = session;
    }

    public void inject(N notifier) {
        this.notifier = notifier;
    }

    public void inject(DisplayRepository repository) {
        this.repository = repository;
    }

    public void inject(SoulProvider soulProvider) {
        this.soulProvider = soulProvider;
    }

    public final void personify() {
        ((AlexandriaDisplayNotifier)this.notifier).personify(this.id, this.name());
        this.init();
    }

    public final void personify(String object) {
        ((AlexandriaDisplayNotifier)this.notifier).personify(this.id, this.name(), object);
        this.init();
    }

    public final void personifyOnce() {
        ((AlexandriaDisplayNotifier)this.notifier).personifyOnce(this.id, this.name());
        this.init();
    }

    public final void personifyOnce(String object) {
        ((AlexandriaDisplayNotifier)this.notifier).personifyOnce(this.id, this.name(), object);
        this.init();
    }

    public void setLanguage(String language) {
        this.propagateLanguageChanged(language);
    }

    public ActivitySession session() {
        return this.session;
    }

    protected void init() {
    }

    protected <S extends Soul> S soul() {
        return (S)this.soulProvider.soul();
    }

    protected String assetUrl(URL asset) {
        return Asset.toResource(((Soul)this.soul()).baseAssetUrl(), asset).toUrl().toString();
    }

    protected String assetUrl(URL asset, String label) {
        return Asset.toResource(((Soul)this.soul()).baseAssetUrl(), asset).setLabel(label).toUrl().toString();
    }

    private void propagateLanguageChanged(String language) {
        if (this instanceof International) {
            ((International)((Object)this)).onChangeLanguage(language);
        }
        this.children.stream().forEach(c -> c.propagateLanguageChanged(language));
    }

    public void refresh() {
    }

    public String id() {
        return this.id;
    }

    public void die() {
        ((AlexandriaDisplayNotifier)this.notifier).die(this.id);
    }

    public <T extends AlexandriaDisplay> List<T> children(Class<T> clazz) {
        return this.children.stream().filter(child -> clazz.isAssignableFrom(child.getClass())).map(clazz::cast).collect(Collectors.toList());
    }

    public <T extends AlexandriaDisplay> T child(Class<T> clazz) {
        return (T)((AlexandriaDisplay)this.children(clazz).stream().findFirst().map(clazz::cast).orElse(null));
    }

    public void add(AlexandriaDisplay child) {
        this.repository.register(child);
        this.children.add(child);
    }

    public void addAndPersonify(AlexandriaDisplay child) {
        this.add(child);
        child.personify();
    }

    public void remove(Class<? extends AlexandriaDisplay> clazz) {
        List<? extends AlexandriaDisplay> childrenToRemove = this.children(clazz);
        childrenToRemove.forEach(this::removeChild);
    }

    private void removeChild(AlexandriaDisplay display) {
        display.die();
        this.children.remove(display);
        this.repository.remove(display.id);
    }

    public String name() {
        return AlexandriaDisplay.nameOf(this.getClass());
    }

    public static String nameOf(Class<? extends AlexandriaDisplay> clazz) {
        String name = clazz.getSimpleName();
        int index = name.lastIndexOf("Display");
        return index != -1 ? name.substring(0, index) : name;
    }
}

