/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialog;
import io.intino.konos.alexandria.activity.displays.DialogExecution;
import io.intino.konos.alexandria.activity.displays.builders.DialogReferenceBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaDialogContainerNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class AlexandriaDialogContainer
extends ActivityDisplay<AlexandriaDialogContainerNotifier, Box> {
    private AlexandriaDialog dialog;
    private Class<? extends AlexandriaDialog> dialogType;
    private List<Consumer<String>> assertionListeners = new ArrayList<Consumer<String>>();

    public AlexandriaDialogContainer(Box box) {
        super(box);
    }

    public void dialog(AlexandriaDialog dialog) {
        this.dialog = dialog;
        this.dialogType = dialog.getClass();
    }

    public void onDialogAssertion(Consumer<String> listener) {
        this.assertionListeners.add(listener);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.dialogType != null) {
            this.remove(this.dialogType);
        }
        if (this.dialog == null) {
            return;
        }
        this.dialog.onDone(this::dialogAssertionMade);
        this.sendInfo();
        this.add(this.dialog);
        this.dialog.personifyOnce(this.id());
    }

    private void sendInfo() {
        ((AlexandriaDialogContainerNotifier)this.notifier).refreshDialog(DialogReferenceBuilder.build(this.dialogType.getSimpleName(), this.dialog.width(), this.dialog.height()));
    }

    public void dialogAssertionMade(String modification) {
        this.assertionListeners.forEach(l -> l.accept(modification));
    }

    private void dialogAssertionMade(DialogExecution.Modification modification) {
        ((AlexandriaDialogContainerNotifier)this.notifier).closeDialog();
        this.dialogAssertionMade(modification.toString());
    }
}

