/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialogNotifier;
import io.intino.konos.alexandria.activity.displays.DialogExecution;
import io.intino.konos.alexandria.activity.displays.DialogValidator;
import io.intino.konos.alexandria.activity.displays.builders.DialogBuilder;
import io.intino.konos.alexandria.activity.displays.builders.ValidationBuilder;
import io.intino.konos.alexandria.activity.model.Dialog;
import io.intino.konos.alexandria.activity.schemas.DialogInput;
import io.intino.konos.alexandria.activity.schemas.DialogInputResource;
import io.intino.konos.alexandria.activity.schemas.Resource;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public abstract class AlexandriaDialog
extends ActivityDisplay<AlexandriaDialogNotifier, Box> {
    private int width;
    private int height;
    private Map<Class<? extends Dialog.Tab.Input>, Function<FormInput, DialogValidator.Result>> validators = new HashMap<Class<? extends Dialog.Tab.Input>, Function<FormInput, DialogValidator.Result>>();
    private Dialog dialog;
    private List<Consumer<DialogExecution.Modification>> doneListeners = new ArrayList<Consumer<DialogExecution.Modification>>();

    public AlexandriaDialog(Box box, Dialog dialog) {
        super(box);
        this.dialog(dialog);
        this.validators.put(Dialog.Tab.Text.class, this::validateText);
        this.validators.put(Dialog.Tab.Section.class, this::validateSection);
        this.validators.put(Dialog.Tab.Memo.class, this::validateMemo);
        this.validators.put(Dialog.Tab.Password.class, this::validatePassword);
        this.validators.put(Dialog.Tab.RadioBox.class, this::validateOptionBox);
        this.validators.put(Dialog.Tab.CheckBox.class, this::validateOptionBox);
        this.validators.put(Dialog.Tab.ComboBox.class, this::validateOptionBox);
        this.validators.put(Dialog.Tab.File.class, this::validateResource);
        this.validators.put(Dialog.Tab.Picture.class, this::validateResource);
        this.validators.put(Dialog.Tab.Date.class, this::validateDate);
        this.validators.put(Dialog.Tab.DateTime.class, this::validateDateTime);
    }

    public <B extends Box> B box() {
        return (B)this.box;
    }

    public int width() {
        return this.width;
    }

    public AlexandriaDialog width(int width) {
        this.width = width;
        return this;
    }

    public int height() {
        return this.height;
    }

    public AlexandriaDialog height(int height) {
        this.height = height;
        return this;
    }

    public Dialog dialog() {
        return this.dialog;
    }

    public void dialog(Dialog dialog) {
        this.dialog = dialog;
        this.fillDefaultValues();
    }

    public void onDone(Consumer<DialogExecution.Modification> listener) {
        this.doneListeners.add(listener);
    }

    @Override
    public void init() {
        this.prepare();
        ((AlexandriaDialogNotifier)this.notifier).render(DialogBuilder.build(this.dialog));
    }

    public void saveValue(DialogInput dialogInput) {
        this.dialog.register(dialogInput.path(), dialogInput.value());
        this.refresh((Dialog.Tab.Input)this.dialog.input(dialogInput.path()), dialogInput.path());
    }

    public void addValue(String path) {
    }

    public void removeValue(String path) {
        this.dialog.unRegister(path);
        this.refresh((Dialog.Tab.Input)this.dialog.input(path), path);
    }

    private void refresh(final Dialog.Tab.Input input, final String path) {
        DialogValidator.Result result = this.validate(new FormInput(){

            @Override
            public Dialog.Tab.Input input() {
                return input;
            }

            @Override
            public String path() {
                return path;
            }
        });
        if (result == null) {
            return;
        }
        ((AlexandriaDialogNotifier)this.notifier).refresh(ValidationBuilder.build(input.name(), result));
    }

    public void uploadResource(DialogInputResource dialogInput) {
        this.dialog.register(dialogInput.path(), dialogInput.file());
        this.refresh((Dialog.Tab.Input)this.dialog.input(dialogInput.path()), dialogInput.path());
    }

    public ActivityFile downloadResource(String path) {
        final Resource resource = ((Dialog.Tab.Input)this.dialog.input(path)).value().asResource();
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.name();
            }

            @Override
            public InputStream content() {
                String value = resource.value();
                return new ByteArrayInputStream(value == null || value.isEmpty() ? new byte[]{} : Base64.decodeBase64((String)value.split(",")[1].replace(" ", "+")));
            }
        };
    }

    public void execute(String name) {
        Dialog.Toolbar.Operation operation = this.dialog.operation(name);
        DialogExecution.Modification modification = operation.execute(this.session());
        DialogExecution.Modification result = modification != null ? modification : DialogExecution.Modification.None;
        ((AlexandriaDialogNotifier)this.notifier).done(result.toString());
        this.doneListeners.forEach(l -> l.accept(result));
    }

    public abstract void prepare();

    private DialogValidator.Result validate(FormInput formInput) {
        DialogValidator.Result result = formInput.input().validate();
        if (result != null) {
            return result;
        }
        return this.validators.get(formInput.input().getClass()).apply(formInput);
    }

    private DialogValidator.Result validateText(FormInput formInput) {
        List<String> values = formInput.input().values().asString();
        Dialog.Tab.Text text = (Dialog.Tab.Text)formInput.input();
        DialogValidator.Result result = text.validateEmail(values);
        if (result != null) {
            return result;
        }
        result = text.validateAllowedValues(values);
        if (result != null) {
            return result;
        }
        return text.validateLength(values);
    }

    private DialogValidator.Result validateSection(FormInput formInput) {
        return null;
    }

    private DialogValidator.Result validateMemo(FormInput formInput) {
        return null;
    }

    private DialogValidator.Result validatePassword(FormInput formInput) {
        List<String> values = formInput.input().values().asString();
        Dialog.Tab.Password password = (Dialog.Tab.Password)formInput.input();
        return password.validateLength(values);
    }

    private DialogValidator.Result validateOptionBox(FormInput formInput) {
        return null;
    }

    private DialogValidator.Result validateResource(FormInput formInput) {
        List<Resource> resourceValues;
        Map<String, byte[]> valuesMap;
        Dialog.Tab.Resource resource = (Dialog.Tab.Resource)formInput.input();
        DialogValidator.Result result = resource.validateMaxSize(valuesMap = (resourceValues = formInput.input().values().asResource()).stream().collect(Collectors.toMap(Resource::name, o -> Base64.decodeBase64((String)o.value()))));
        if (result != null) {
            return result;
        }
        return resource.validateExtension(new ArrayList<Object>(valuesMap.keySet()));
    }

    private DialogValidator.Result validateDate(FormInput formInput) {
        return null;
    }

    private DialogValidator.Result validateDateTime(FormInput formInput) {
        return null;
    }

    private void fillDefaultValues() {
        this.inputs(this.dialog).stream().filter(input -> input.defaultValue() != null && input.defaultValue() instanceof String && !((String)input.defaultValue()).isEmpty()).forEach(input -> this.dialog.register(input.name(), Collections.singletonList(input.defaultValue())));
    }

    private List<Dialog.Tab.Input> inputs(Dialog dialog) {
        return dialog.tabList().stream().map(Dialog.Tab::inputList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public <T> T target() {
        return this.dialog().target();
    }

    public void target(Object target) {
        this.dialog().target(target);
    }

    static interface FormInput {
        public Dialog.Tab.Input input();

        public String path();
    }
}

