/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogDisplayView;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogListView;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogMagazineView;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogMapView;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogView;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.builders.ReferenceBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaCatalogViewListNotifier;
import io.intino.konos.alexandria.activity.displays.providers.CatalogViewDisplayProvider;
import io.intino.konos.alexandria.activity.model.catalog.views.DisplayView;
import io.intino.konos.alexandria.activity.model.catalog.views.GridView;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import io.intino.konos.alexandria.activity.model.catalog.views.MagazineView;
import io.intino.konos.alexandria.activity.model.catalog.views.MapView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class AlexandriaCatalogViewList
extends ActivityDisplay<AlexandriaCatalogViewListNotifier, Box> {
    private List<Consumer<AlexandriaCatalogView>> selectListeners = new ArrayList<Consumer<AlexandriaCatalogView>>();
    private Map<String, Function<ElementView, ? extends AlexandriaDisplay>> builders = new HashMap<String, Function<ElementView, ? extends AlexandriaDisplay>>();
    private List<ElementView> viewList;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<AlexandriaElementView.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemDialogEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemCatalogEvent>> openItemCatalogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemCatalogEvent>>();
    private List<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>>();
    private Map<String, AlexandriaCatalogView> viewDisplayMap = new HashMap<String, AlexandriaCatalogView>();
    private static final String ViewId = "%s%s";

    public AlexandriaCatalogViewList(Box box) {
        super(box);
        this.registerBuilders();
    }

    public void itemProvider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    public void viewList(List<ElementView> viewList) {
        this.viewList = viewList;
    }

    public void onSelectView(Consumer<AlexandriaCatalogView> listener) {
        this.selectListeners.add(listener);
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    public void onOpenItemDialog(Consumer<AlexandriaElementView.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    public void onOpenItemCatalog(Consumer<AlexandriaElementView.OpenItemCatalogEvent> listener) {
        this.openItemCatalogListeners.add(listener);
    }

    public void onExecuteItemTask(Consumer<AlexandriaElementView.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    public List<AlexandriaCatalogView> viewList() {
        return new ArrayList<AlexandriaCatalogView>(this.viewDisplayMap.values());
    }

    private void registerBuilders() {
        this.builders.put(MagazineView.class.getSimpleName(), this::buildMagazineViewDisplay);
        this.builders.put(ListView.class.getSimpleName(), this::buildListViewDisplay);
        this.builders.put(GridView.class.getSimpleName(), this::buildListViewDisplay);
        this.builders.put(MapView.class.getSimpleName(), this::buildMapViewDisplay);
        this.builders.put(DisplayView.class.getSimpleName(), this::buildDisplayViewDisplay);
    }

    public void selectView(String name) {
        AlexandriaCatalogView display = this.display(name);
        ((AlexandriaCatalogViewListNotifier)this.notifier).refreshSelectedView(name);
        this.selectListeners.forEach(l -> l.accept(display));
    }

    @Override
    public void refresh() {
        this.viewDisplayMap.values().forEach(AlexandriaElementView::refresh);
    }

    @Override
    protected void init() {
        super.init();
        this.sendViewList();
        if (this.viewList.size() > 0) {
            this.selectView(this.viewList.get(0).name());
        }
    }

    private AlexandriaCatalogView display(String name) {
        if (!this.viewDisplayMap.containsKey(name)) {
            this.buildViewDisplay(name);
        }
        return this.viewDisplayMap.get(name);
    }

    private void buildViewDisplay(String name) {
        ElementView view = this.viewList.stream().filter(v -> v.name().equals(name)).findFirst().orElse(null);
        this.builders.get(view.type()).apply(view);
    }

    private void sendViewList() {
        ((AlexandriaCatalogViewListNotifier)this.notifier).refreshViewList(ReferenceBuilder.buildCatalogViewList(this.viewList));
    }

    private AlexandriaCatalogMagazineView buildMagazineViewDisplay(ElementView view) {
        AlexandriaCatalogMagazineView display = new AlexandriaCatalogMagazineView(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private AlexandriaCatalogListView buildListViewDisplay(ElementView view) {
        AlexandriaCatalogListView display = new AlexandriaCatalogListView(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private AlexandriaCatalogMapView buildMapViewDisplay(ElementView view) {
        AlexandriaCatalogMapView display = new AlexandriaCatalogMapView(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private AlexandriaCatalogDisplayView buildDisplayViewDisplay(ElementView view) {
        AlexandriaCatalogDisplayView display = new AlexandriaCatalogDisplayView(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private void registerViewDisplay(AlexandriaCatalogView display, ElementView view) {
        display.provider(this.provider);
        display.onOpenItem(this::openItem);
        display.onOpenItemDialog(this::openItemDialog);
        display.onOpenItemCatalog(this::openItemCatalog);
        display.onExecuteItemTask(this::executeTask);
        display.view(view);
        display.onLoading(this::notifyLoading);
        this.viewDisplayMap.put(view.name(), display);
    }

    private void openItem(AlexandriaElementView.OpenItemEvent parameters) {
        this.openItemListeners.forEach(l -> l.accept(parameters));
    }

    private void openItemDialog(AlexandriaElementView.OpenItemDialogEvent event) {
        this.openItemDialogListeners.forEach(l -> l.accept(event));
    }

    private void openItemCatalog(AlexandriaElementView.OpenItemCatalogEvent event) {
        this.openItemCatalogListeners.forEach(l -> l.accept(event));
    }

    private void executeTask(AlexandriaElementView.ExecuteItemTaskEvent event) {
        this.executeItemTaskListeners.forEach(l -> l.accept(event));
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    private String idOf(ElementView view) {
        return String.format(ViewId, this.id(), view.name());
    }
}

