/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.Resource;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogView;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.PageDisplay;
import io.intino.konos.alexandria.activity.displays.builders.ElementViewBuilder;
import io.intino.konos.alexandria.activity.displays.builders.ItemBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaCatalogMapViewNotifier;
import io.intino.konos.alexandria.activity.displays.providers.CatalogViewDisplayProvider;
import io.intino.konos.alexandria.activity.helpers.ElementHelper;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.catalog.events.OpenPanel;
import io.intino.konos.alexandria.activity.model.mold.Stamp;
import io.intino.konos.alexandria.activity.model.mold.stamps.Title;
import io.intino.konos.alexandria.activity.model.mold.stamps.Tree;
import io.intino.konos.alexandria.activity.schemas.Bounds;
import io.intino.konos.alexandria.activity.schemas.DownloadItemParameters;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.schemas.ExecuteItemTaskParameters;
import io.intino.konos.alexandria.activity.schemas.OpenElementParameters;
import io.intino.konos.alexandria.activity.schemas.OpenItemDialogParameters;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class AlexandriaCatalogMapView
extends PageDisplay<AlexandriaCatalogMapViewNotifier>
implements AlexandriaCatalogView {
    private ElementView view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<AlexandriaElementView.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemDialogEvent>>();
    private List<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();

    public AlexandriaCatalogMapView(Box box) {
        super(box);
        this.pageSize(100000);
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<AlexandriaElementView.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    @Override
    public void onOpenItemCatalog(Consumer<AlexandriaElementView.OpenItemCatalogEvent> listener) {
    }

    @Override
    public void onExecuteItemTask(Consumer<AlexandriaElementView.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    @Override
    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    @Override
    public void reset() {
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    @Override
    public int countItems() {
        return this.provider.countItems(null);
    }

    public void page(Integer value) {
        super.page(value);
    }

    public void location(Bounds value) {
    }

    @Override
    protected void init() {
        super.init();
        this.sendView();
    }

    @Override
    public void refresh() {
        this.notifyLoading(true);
        super.refresh();
        this.notifyLoading(false);
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openItemDialogListeners.forEach(l -> l.accept(ElementHelper.openItemDialogEvent(this.itemOf(params.item()), this.provider.stamp(this.view.mold(), params.stamp()), this.session())));
    }

    public void executeItemTaskOperation(ExecuteItemTaskParameters params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(ElementHelper.executeItemTaskEvent(this.itemOf(params.item()), this.provider.stamp(this.view.mold(), params.stamp()))));
    }

    @Override
    public void refresh(io.intino.konos.alexandria.activity.schemas.Item ... items) {
        Stream.of(items).forEach(item -> ((AlexandriaCatalogMapViewNotifier)this.notifier).refreshItem((io.intino.konos.alexandria.activity.schemas.Item)item));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters value) {
        return null;
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, Collections.emptyList());
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, Collections.emptyList());
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.label();
            }

            @Override
            public InputStream content() {
                return resource.content();
            }
        };
    }

    public void openElement(OpenElementParameters params) {
    }

    @Override
    protected void sendItems(int start, int limit) {
        ((AlexandriaCatalogMapViewNotifier)this.notifier).refresh(ItemBuilder.buildListOnlyLocation(this.provider.items(start, limit, null), ElementHelper.itemBuilderProvider(this.provider, this.view), this.provider.baseAssetUrl()));
    }

    @Override
    protected void sendClear() {
        ((AlexandriaCatalogMapViewNotifier)this.notifier).clear();
    }

    @Override
    protected void sendPageSize(int pageSize) {
        ((AlexandriaCatalogMapViewNotifier)this.notifier).refreshPageSize(pageSize);
    }

    @Override
    protected void sendCount(int count) {
        ((AlexandriaCatalogMapViewNotifier)this.notifier).refreshCount(count);
    }

    private void sendView() {
        ((AlexandriaCatalogMapViewNotifier)this.notifier).refreshView(ElementViewBuilder.build(this.view));
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public void loadItem(String id) {
        String decodedId = new String(Base64.getDecoder().decode(id));
        io.intino.konos.alexandria.activity.schemas.Item item = ItemBuilder.build(this.provider.item(decodedId), ElementHelper.itemBuilderProvider(this.provider, this.view), this.provider.baseAssetUrl());
        ((AlexandriaCatalogMapViewNotifier)this.notifier).refreshItem(item);
    }

    public void openItem(String value) {
        this.notifyOpenItem(value);
    }

    private void notifyOpenItem(final String item) {
        this.openItemListeners.forEach(l -> l.accept(new AlexandriaElementView.OpenItemEvent(){

            @Override
            public String itemId() {
                return new String(Base64.getDecoder().decode(item));
            }

            @Override
            public String label() {
                Optional<Stamp> titleStamp = AlexandriaCatalogMapView.this.provider.stamps(AlexandriaCatalogMapView.this.view.mold()).stream().filter(s -> s instanceof Title).findAny();
                return titleStamp.isPresent() ? (String)((Title)titleStamp.get()).value(this.item(), AlexandriaCatalogMapView.this.session()) : this.item().name();
            }

            @Override
            public Item item() {
                return AlexandriaCatalogMapView.this.provider.item(this.itemId());
            }

            @Override
            public Panel panel() {
                return AlexandriaCatalogMapView.this.view.onClickRecordEvent().openPanel().panel();
            }

            @Override
            public TimeRange range() {
                return AlexandriaCatalogMapView.this.provider.range();
            }

            @Override
            public Tree breadcrumbs() {
                OpenPanel openPanel = AlexandriaCatalogMapView.this.view.onClickRecordEvent().openPanel();
                return openPanel != null ? openPanel.breadcrumbs(this.item(), AlexandriaCatalogMapView.this.session()) : null;
            }
        }));
    }

    private Item itemOf(String item) {
        return this.provider.item(item);
    }
}

