/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.Resource;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogView;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.AlexandriaItem;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaCatalogMagazineViewNotifier;
import io.intino.konos.alexandria.activity.displays.providers.CatalogViewDisplayProvider;
import io.intino.konos.alexandria.activity.helpers.ElementHelper;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class AlexandriaCatalogMagazineView
extends ActivityDisplay<AlexandriaCatalogMagazineViewNotifier, Box>
implements AlexandriaCatalogView {
    private ElementView view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<AlexandriaElementView.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemDialogEvent>>();
    private List<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>>();
    private Item item = null;
    private String condition = null;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private String currentItem = null;

    public AlexandriaCatalogMagazineView(Box box) {
        super(box);
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<AlexandriaElementView.OpenItemDialogEvent> parameters) {
        this.openItemDialogListeners.add(parameters);
    }

    @Override
    public void onOpenItemCatalog(Consumer<AlexandriaElementView.OpenItemCatalogEvent> listener) {
    }

    @Override
    public void onExecuteItemTask(Consumer<AlexandriaElementView.ExecuteItemTaskEvent> parameters) {
        this.executeItemTaskListeners.add(parameters);
    }

    @Override
    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
    }

    @Override
    public void reset() {
        this.currentItem = null;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    @Override
    public void refresh(io.intino.konos.alexandria.activity.schemas.Item ... items) {
        if (items.length <= 0) {
            return;
        }
        this.child(AlexandriaItem.class).refresh(items[0]);
    }

    @Override
    protected void init() {
        super.init();
        this.createRecordDisplay();
    }

    private void createRecordDisplay() {
        AlexandriaItem display = new AlexandriaItem(this.box);
        display.emptyMessage(this.view.emptyMessage());
        display.mold(this.view.mold());
        display.context(this.provider.element());
        display.item(null);
        display.mode("magazine");
        display.provider(ElementHelper.itemDisplayProvider(this.provider, this.view));
        display.onOpenItem(this::selectRecord);
        display.onOpenItemDialog(this::openItemDialogOperation);
        display.onExecuteItemTask(this::executeItemTaskOperation);
        this.add(display);
        display.personifyOnce();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.notifyLoading(true);
        this.loadRecord();
        if (this.item == null) {
            return;
        }
        AlexandriaItem itemDisplay = this.child(AlexandriaItem.class);
        itemDisplay.item(this.item);
        itemDisplay.refresh();
        this.notifyLoading(false);
    }

    public void filter(String value) {
        this.condition = value;
        this.loadRecord();
        this.refresh();
    }

    public void selectRecord(AlexandriaElementView.OpenItemEvent params) {
        this.currentItem = params.itemId();
        this.refresh();
    }

    private void loadRecord() {
        int count = this.provider.countItems(this.condition);
        List<Item> items = this.provider.items(0, count, this.condition);
        this.item = this.currentItem != null ? this.provider.item(this.nameOf(this.currentItem)) : this.provider.rootItem(items);
        this.currentItem = this.item != null ? this.item.id() : this.currentItem;
        this.item = this.item != null ? this.item : this.provider.defaultItem(this.nameOf(this.currentItem));
    }

    private String nameOf(String currentRecord) {
        if (currentRecord == null) {
            return null;
        }
        String shortName = currentRecord.contains(".") ? currentRecord.substring(currentRecord.lastIndexOf(".") + 1) : currentRecord;
        shortName = shortName.contains("#") ? shortName.substring(shortName.lastIndexOf("#") + 1) : shortName;
        shortName = shortName.contains("$") ? shortName.substring(shortName.lastIndexOf("$") + 1) : shortName;
        return shortName;
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public void openItemDialogOperation(AlexandriaElementView.OpenItemDialogEvent event) {
        this.openItemDialogListeners.forEach(l -> l.accept(event));
    }

    public void executeItemTaskOperation(AlexandriaElementView.ExecuteItemTaskEvent event) {
        this.executeItemTaskListeners.forEach(l -> l.accept(event));
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, Collections.singletonList(this.item));
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, Collections.singletonList(this.item));
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.label();
            }

            @Override
            public InputStream content() {
                return resource.content();
            }
        };
    }
}

