/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.Resource;
import io.intino.konos.alexandria.activity.displays.AlexandriaAbstractCatalog;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogView;
import io.intino.konos.alexandria.activity.displays.AlexandriaDialog;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.AlexandriaStamp;
import io.intino.konos.alexandria.activity.displays.AlexandriaTemporalCatalog;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.PageDisplay;
import io.intino.konos.alexandria.activity.displays.builders.CatalogSortingBuilder;
import io.intino.konos.alexandria.activity.displays.builders.ElementViewBuilder;
import io.intino.konos.alexandria.activity.displays.builders.ItemBuilder;
import io.intino.konos.alexandria.activity.displays.builders.PictureDataBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaCatalogListViewNotifier;
import io.intino.konos.alexandria.activity.displays.providers.AlexandriaStampProvider;
import io.intino.konos.alexandria.activity.displays.providers.CatalogViewDisplayProvider;
import io.intino.konos.alexandria.activity.displays.providers.ElementViewDisplayProvider;
import io.intino.konos.alexandria.activity.helpers.ElementHelper;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Panel;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.catalog.events.OpenPanel;
import io.intino.konos.alexandria.activity.model.mold.Stamp;
import io.intino.konos.alexandria.activity.model.mold.stamps.CatalogLink;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedCatalog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDialog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDisplay;
import io.intino.konos.alexandria.activity.model.mold.stamps.Picture;
import io.intino.konos.alexandria.activity.model.mold.stamps.Title;
import io.intino.konos.alexandria.activity.model.mold.stamps.Tree;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.DownloadOperation;
import io.intino.konos.alexandria.activity.schemas.ClusterGroup;
import io.intino.konos.alexandria.activity.schemas.DownloadItemParameters;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.schemas.ExecuteItemTaskParameters;
import io.intino.konos.alexandria.activity.schemas.Item;
import io.intino.konos.alexandria.activity.schemas.OpenElementParameters;
import io.intino.konos.alexandria.activity.schemas.OpenItemDialogParameters;
import io.intino.konos.alexandria.activity.schemas.SaveItemParameters;
import io.intino.konos.alexandria.activity.schemas.Sorting;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import io.intino.konos.alexandria.activity.utils.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spark.utils.IOUtils;

public class AlexandriaCatalogListView
extends PageDisplay<AlexandriaCatalogListViewNotifier>
implements AlexandriaCatalogView,
AlexandriaStampProvider {
    private ElementViewDisplayProvider.Sorting sorting;
    private ElementView<Catalog> view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<AlexandriaElementView.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemDialogEvent>>();
    private List<Consumer<AlexandriaElementView.OpenItemCatalogEvent>> openItemCatalogListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemCatalogEvent>>();
    private List<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<AlexandriaElementView.ExecuteItemTaskEvent>>();
    private String condition = null;
    private Map<String, List<AlexandriaStamp>> recordDisplaysMap = new HashMap<String, List<AlexandriaStamp>>();
    private Map<String, List<AlexandriaDialog>> recordDialogsMap = new HashMap<String, List<AlexandriaDialog>>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<String> lastSelection = new ArrayList<String>();

    public AlexandriaCatalogListView(Box box) {
        super(box);
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    public void selectSorting(Sorting sorting) {
        this.sorting = this.sortingOf(sorting);
        this.sendSelectedSorting();
        this.sendClear();
        this.page(0);
    }

    @Override
    public int countItems() {
        return this.provider.countItems(this.condition);
    }

    public void page(Integer value) {
        super.page(value);
    }

    @Override
    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    @Override
    public void onOpenItemDialog(Consumer<AlexandriaElementView.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    @Override
    public void onOpenItemCatalog(Consumer<AlexandriaElementView.OpenItemCatalogEvent> listener) {
        this.openItemCatalogListeners.add(listener);
    }

    @Override
    public void onExecuteItemTask(Consumer<AlexandriaElementView.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    @Override
    public void reset() {
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    public void filter(String value) {
        this.condition = value;
        this.refresh();
    }

    @Override
    public void refresh(Item ... items) {
        Stream.of(items).forEach(this::refresh);
    }

    public void selectItems(String[] records) {
        ArrayList<String> newRecords = new ArrayList<String>(Arrays.asList(records));
        newRecords.removeAll(this.lastSelection);
        newRecords.forEach(record -> {
            if (!this.recordDisplaysMap.containsKey(record)) {
                this.renderDisplays((String)record);
            }
            if (!this.recordDialogsMap.containsKey(record)) {
                this.renderDialogs((String)record);
            }
            this.renderExpandedPictures((String)record);
        });
        this.lastSelection = new ArrayList<String>(Arrays.asList(records));
    }

    public void openItem(String value) {
        if (this.view.onClickRecordEvent() == null) {
            if (this.provider.expandedStamps(this.view.mold()).size() > 0) {
                ((AlexandriaCatalogListViewNotifier)this.notifier).refreshSelection(this.lastSelection.contains(value) ? Collections.emptyList() : Collections.singletonList(value));
            }
            return;
        }
        if (this.view.onClickRecordEvent().openPanel() != null) {
            this.notifyOpenItem(value);
        } else if (this.view.onClickRecordEvent().openCatalog() != null) {
            this.notifyOpenCatalog(this.itemOf(value));
        } else if (this.view.onClickRecordEvent().openDialog() != null) {
            this.notifyOpenDialog(this.itemOf(value));
        }
    }

    public void openElement(OpenElementParameters params) {
        Stamp stamp = this.provider.stamp(this.view.mold(), params.stamp().name());
        if (!(stamp instanceof CatalogLink)) {
            return;
        }
        CatalogLink catalogLinkStamp = (CatalogLink)stamp;
        AlexandriaAbstractCatalog display = (AlexandriaAbstractCatalog)this.provider.openElement(catalogLinkStamp.catalog().label());
        io.intino.konos.alexandria.activity.model.Item source = this.itemOf(params.item());
        if (display instanceof AlexandriaTemporalCatalog && this.provider.range() != null) {
            ((AlexandriaTemporalCatalog)display).selectRange(this.provider.range());
        }
        if (catalogLinkStamp.openItemOnLoad()) {
            display.openItem(catalogLinkStamp.item(source, this.session()));
        } else {
            if (catalogLinkStamp.filtered()) {
                display.filterAndNotify(item -> catalogLinkStamp.filter(source, (io.intino.konos.alexandria.activity.model.Item)item, this.session()));
            }
            display.refresh();
        }
    }

    private void notifyOpenItem(String item) {
        this.openItemListeners.forEach(l -> l.accept(this.openItemEventOf(item)));
    }

    private AlexandriaElementView.OpenItemEvent openItemEventOf(final String item) {
        return new AlexandriaElementView.OpenItemEvent(){

            @Override
            public String itemId() {
                return new String(Base64.getDecoder().decode(item));
            }

            @Override
            public String label() {
                Optional<Stamp> titleStamp = AlexandriaCatalogListView.this.provider.stamps(AlexandriaCatalogListView.this.view.mold()).stream().filter(s -> s instanceof Title).findAny();
                return titleStamp.isPresent() ? (String)((Title)titleStamp.get()).value(this.item(), AlexandriaCatalogListView.this.session()) : this.item().name();
            }

            @Override
            public io.intino.konos.alexandria.activity.model.Item item() {
                return AlexandriaCatalogListView.this.provider.item(this.itemId());
            }

            @Override
            public Panel panel() {
                return AlexandriaCatalogListView.this.view.onClickRecordEvent().openPanel().panel();
            }

            @Override
            public TimeRange range() {
                return AlexandriaCatalogListView.this.provider.range();
            }

            @Override
            public Tree breadcrumbs() {
                OpenPanel openPanel = AlexandriaCatalogListView.this.view.onClickRecordEvent().openPanel();
                return openPanel != null ? openPanel.breadcrumbs(this.item(), AlexandriaCatalogListView.this.session()) : null;
            }
        };
    }

    private void notifyOpenCatalog(final io.intino.konos.alexandria.activity.model.Item item) {
        this.openItemCatalogListeners.forEach(l -> l.accept(new AlexandriaElementView.OpenItemCatalogEvent(){

            @Override
            public io.intino.konos.alexandria.activity.model.Item sender() {
                return item;
            }

            @Override
            public Catalog catalog() {
                return AlexandriaCatalogListView.this.view.onClickRecordEvent().openCatalog().catalog();
            }

            @Override
            public boolean filtered() {
                return AlexandriaCatalogListView.this.view.onClickRecordEvent().openCatalog().filtered();
            }

            @Override
            public boolean filter(io.intino.konos.alexandria.activity.model.Item target) {
                return AlexandriaCatalogListView.this.view.onClickRecordEvent().openCatalog().filter(item, target, AlexandriaCatalogListView.this.session());
            }

            @Override
            public String itemToShow() {
                return AlexandriaCatalogListView.this.view.onClickRecordEvent().openCatalog().item(item, AlexandriaCatalogListView.this.session());
            }
        }));
    }

    private void notifyOpenDialog(final io.intino.konos.alexandria.activity.model.Item item) {
        this.openItemDialogListeners.forEach(l -> l.accept(new AlexandriaElementView.OpenItemDialogEvent(){

            @Override
            public io.intino.konos.alexandria.activity.model.Item item() {
                return item;
            }

            @Override
            public AlexandriaDialog dialog() {
                return AlexandriaCatalogListView.this.view.onClickRecordEvent().openDialog().createDialog(item, AlexandriaCatalogListView.this.session());
            }
        }));
    }

    public void renderExpandedPictures() {
        this.lastSelection.forEach(this::renderExpandedPictures);
    }

    private void renderDisplays(String item) {
        Map<EmbeddedDisplay, AlexandriaStamp> displays = this.displays();
        io.intino.konos.alexandria.activity.model.Item itemObject = this.provider.item(item);
        displays.forEach((stamp, display) -> {
            display.item(itemObject);
            display.provider(this);
            this.add((AlexandriaDisplay)display);
            display.personify(item + stamp.displayType());
            display.refresh();
        });
        this.recordDisplaysMap.put(item, new ArrayList<AlexandriaStamp>(displays.values()));
    }

    private void renderDialogs(String item) {
        Map<EmbeddedDialog, AlexandriaDialog> dialogs = this.dialogs();
        io.intino.konos.alexandria.activity.model.Item itemObject = this.itemOf(item);
        dialogs.forEach((stamp, dialog) -> {
            dialog.target(itemObject);
            this.add((AlexandriaDisplay)dialog);
            dialog.personify(item + stamp.dialogType());
            dialog.refresh();
        });
        this.recordDialogsMap.put(item, new ArrayList<AlexandriaDialog>(dialogs.values()));
    }

    private void renderExpandedPictures(String item) {
        this.refreshPictures(item, this.expandedPictures(item));
    }

    private void refreshPictures(String item) {
        this.refreshPictures(item, this.allPictures(item));
    }

    private void refreshPictures(String itemId, List<Picture> pictures) {
        io.intino.konos.alexandria.activity.model.Item item = this.itemOf(itemId);
        pictures.forEach(stamp -> {
            InputStream stream = null;
            try {
                String name = stamp.name();
                Object data = stamp.value(item, this.session());
                if (!(data instanceof List) || ((List)data).size() != 1) {
                    return;
                }
                List values = (List)data;
                stream = ((URL)values.get(0)).openStream();
                byte[] pictureBytes = IOUtils.toByteArray((InputStream)stream);
                byte[] picture = Base64.getEncoder().encode(pictureBytes);
                ((AlexandriaCatalogListViewNotifier)this.notifier).refreshPicture(PictureDataBuilder.build(item, name, "data:image/png;base64," + new String(picture)));
                StreamUtil.close(stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                StreamUtil.close(stream);
            }
        });
    }

    public void createClusterGroup(ClusterGroup value) {
        this.provider.createClusterGroup(value);
    }

    @Override
    protected void sendItems(int start, int limit) {
        ((AlexandriaCatalogListViewNotifier)this.notifier).refresh(ItemBuilder.buildList(this.provider.items(start, limit, this.condition, this.sorting), ElementHelper.itemBuilderProvider(this.provider, this.view), this.baseAssetUrl()));
    }

    @Override
    protected void sendClear() {
        ((AlexandriaCatalogListViewNotifier)this.notifier).clear();
    }

    @Override
    protected void sendPageSize(int pageSize) {
        ((AlexandriaCatalogListViewNotifier)this.notifier).refreshPageSize(pageSize);
    }

    @Override
    protected void sendCount(int count) {
        ((AlexandriaCatalogListViewNotifier)this.notifier).refreshCount(count);
    }

    @Override
    protected void init() {
        super.init();
        List<io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting> sortings = this.provider.sortings();
        this.sorting = sortings.size() > 0 ? this.sortingOf(sortings.get(0)) : null;
        this.sendView();
        this.sendSortingList(sortings);
        this.sendSelectedSorting();
    }

    @Override
    public void refresh() {
        this.notifyLoading(true);
        super.refresh();
        this.notifyLoading(false);
    }

    @Override
    public AlexandriaStamp embeddedDisplay(String name) {
        Stamp stamp = this.provider.stamp(this.view.mold(), name);
        if (stamp == null || !(stamp instanceof EmbeddedDisplay)) {
            return null;
        }
        return ((EmbeddedDisplay)stamp).createDisplay(this.session());
    }

    @Override
    public AlexandriaDialog embeddedDialog(String name) {
        Stamp stamp = this.provider.stamp(this.view.mold(), name);
        if (stamp == null || !(stamp instanceof EmbeddedDialog)) {
            return null;
        }
        return ((EmbeddedDialog)stamp).createDialog(this.session());
    }

    @Override
    public AlexandriaAbstractCatalog embeddedCatalog(String name) {
        Stamp stamp = this.provider.stamp(this.view.mold(), name);
        if (stamp == null || !(stamp instanceof EmbeddedCatalog)) {
            return null;
        }
        return ((EmbeddedCatalog)stamp).createCatalog(this.session());
    }

    private void sendView() {
        ((AlexandriaCatalogListViewNotifier)this.notifier).refreshView(ElementViewBuilder.build(this.view));
    }

    private void sendSortingList(List<io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting> sortings) {
        ((AlexandriaCatalogListViewNotifier)this.notifier).refreshSortingList(CatalogSortingBuilder.buildList(sortings.stream().filter(io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting::visible).collect(Collectors.toList())));
    }

    private void sendSelectedSorting() {
        if (this.sorting == null) {
            return;
        }
        ((AlexandriaCatalogListViewNotifier)this.notifier).refreshSelectedSorting(CatalogSortingBuilder.build(this.sorting));
    }

    private Map<EmbeddedDisplay, AlexandriaStamp> displays() {
        List stamps = this.provider.stamps(this.view.mold()).stream().filter((? super T s) -> s instanceof EmbeddedDisplay).collect(Collectors.toList());
        Map<EmbeddedDisplay, AlexandriaStamp> nullableMap = stamps.stream().collect(Collectors.toMap(s -> (EmbeddedDisplay)s, s -> ((EmbeddedDisplay)s).createDisplay(this.session())));
        return nullableMap.entrySet().stream().filter((? super T e) -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<EmbeddedDialog, AlexandriaDialog> dialogs() {
        List stamps = this.provider.stamps(this.view.mold()).stream().filter((? super T s) -> s instanceof EmbeddedDialog).collect(Collectors.toList());
        Map<EmbeddedDialog, AlexandriaDialog> nullableMap = stamps.stream().collect(Collectors.toMap(s -> (EmbeddedDialog)s, s -> ((EmbeddedDialog)s).createDialog(this.session())));
        return nullableMap.entrySet().stream().filter((? super T e) -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<Picture> expandedPictures(String record) {
        return this.provider.expandedStamps(this.view.mold()).stream().filter((? super T s) -> s instanceof Picture).map(s -> (Picture)s).collect(Collectors.toList());
    }

    private List<Picture> allPictures(String record) {
        return this.provider.stamps(this.view.mold()).stream().filter((? super T s) -> s instanceof Picture).map(s -> (Picture)s).collect(Collectors.toList());
    }

    private ElementViewDisplayProvider.Sorting sortingOf(Sorting sorting) {
        return this.sortingOf(sorting.name(), sorting.mode());
    }

    private ElementViewDisplayProvider.Sorting sortingOf(io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting sorting) {
        return this.sortingOf(sorting.name(), "Ascendant");
    }

    private ElementViewDisplayProvider.Sorting sortingOf(final String name, final String mode) {
        return new ElementViewDisplayProvider.Sorting(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public ElementViewDisplayProvider.Sorting.Mode mode() {
                return ElementViewDisplayProvider.Sorting.Mode.valueOf(mode);
            }

            @Override
            public int comparator(io.intino.konos.alexandria.activity.model.Item item1, io.intino.konos.alexandria.activity.model.Item item2) {
                return AlexandriaCatalogListView.this.provider.sorting(name).compare(item1, item2);
            }
        };
    }

    private void refresh(Item item) {
        ((AlexandriaCatalogListViewNotifier)this.notifier).refreshItem(item);
        if (this.recordDisplaysMap.containsKey(item.name())) {
            this.recordDisplaysMap.get(item.name()).forEach(AlexandriaDisplay::refresh);
        }
        if (this.recordDialogsMap.containsKey(item.name())) {
            this.recordDialogsMap.get(item.name()).forEach(AlexandriaDisplay::refresh);
        }
    }

    public void itemRefreshed(String record) {
        this.refreshPictures(record);
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openItemDialogListeners.forEach(l -> l.accept(ElementHelper.openItemDialogEvent(this.itemOf(params.item()), this.provider.stamp(this.view.mold(), params.stamp()), this.session())));
    }

    public void executeItemTaskOperation(ExecuteItemTaskParameters params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(ElementHelper.executeItemTaskEvent(this.itemOf(params.item()), this.provider.stamp(this.view.mold(), params.stamp()))));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters params) {
        Stamp stamp = this.provider.stamps(this.view.mold()).stream().filter((? super T s) -> s.name().equals(params.stamp())).findFirst().orElse(null);
        if (stamp == null) {
            return null;
        }
        final Resource resource = ((DownloadOperation)stamp).execute(this.itemOf(params.item()), params.option(), this.session());
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.label();
            }

            @Override
            public InputStream content() {
                return resource.content();
            }
        };
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, this.selectedItems());
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, this.selectedItems());
        return new ActivityFile(){

            @Override
            public String label() {
                return resource.label();
            }

            @Override
            public InputStream content() {
                return resource.content();
            }
        };
    }

    private List<io.intino.konos.alexandria.activity.model.Item> selectedItems() {
        return this.lastSelection.stream().map(this::itemOf).collect(Collectors.toList());
    }

    public void saveItem(SaveItemParameters value) {
        if (this.selectedItems().size() != 1) {
            return;
        }
        this.provider.saveItem(value, this.selectedItems().get(0));
    }

    private io.intino.konos.alexandria.activity.model.Item itemOf(String id) {
        return this.provider.item(new String(Base64.getDecoder().decode(id)));
    }
}

