/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogView;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.CatalogInstantBlock;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaCatalogDisplayViewNotifier;
import io.intino.konos.alexandria.activity.displays.providers.CatalogViewDisplayProvider;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.catalog.Scope;
import io.intino.konos.alexandria.activity.model.catalog.views.DisplayView;
import io.intino.konos.alexandria.activity.schemas.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class AlexandriaCatalogDisplayView
extends ActivityDisplay<AlexandriaCatalogDisplayViewNotifier, Box>
implements AlexandriaCatalogView {
    private ElementView<Catalog> view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private AlexandriaDisplay display;

    public AlexandriaCatalogDisplayView(Box box) {
        super(box);
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<AlexandriaElementView.OpenItemDialogEvent> location) {
    }

    @Override
    public void onOpenItemCatalog(Consumer<AlexandriaElementView.OpenItemCatalogEvent> listener) {
    }

    @Override
    public void onExecuteItemTask(Consumer<AlexandriaElementView.ExecuteItemTaskEvent> params) {
    }

    @Override
    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
    }

    @Override
    public void reset() {
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.display.refresh();
    }

    @Override
    public void refresh(Item ... items) {
    }

    public void refresh(Scope scope) {
        DisplayView displayView = (DisplayView)this.view.raw();
        displayView.update(this.display, scope);
    }

    @Override
    protected void init() {
        super.init();
        this.display = ((DisplayView)this.view().raw()).display(this.provider.element(), this.loadingListener(), this.instantListener(), this.session());
        this.sendDisplayType(this.display);
        this.add(this.display);
        this.display.personifyOnce();
    }

    private void sendDisplayType(AlexandriaDisplay display) {
        ((AlexandriaCatalogDisplayViewNotifier)this.notifier).displayType(display.name());
    }

    private Consumer<Boolean> loadingListener() {
        return value -> this.notifyLoading((Boolean)value);
    }

    private Consumer<CatalogInstantBlock> instantListener() {
        return block -> this.selectInstant((CatalogInstantBlock)block);
    }

    private void selectInstant(CatalogInstantBlock block) {
        this.provider.selectInstant(block);
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }
}

