/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogDisplayView;
import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogViewList;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaElementView;
import io.intino.konos.alexandria.activity.displays.AlexandriaItem;
import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.providers.CatalogViewDisplayProvider;
import io.intino.konos.alexandria.activity.displays.providers.ElementViewDisplayProvider;
import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.ItemList;
import io.intino.konos.alexandria.activity.model.Mold;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.model.catalog.Events;
import io.intino.konos.alexandria.activity.model.catalog.Scope;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Group;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.GroupMap;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.GroupingManager;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting;
import io.intino.konos.alexandria.activity.model.catalog.events.OnClickRecord;
import io.intino.konos.alexandria.activity.model.catalog.views.GridView;
import io.intino.konos.alexandria.activity.model.catalog.views.ListView;
import io.intino.konos.alexandria.activity.model.catalog.views.MagazineView;
import io.intino.konos.alexandria.activity.model.catalog.views.MoldView;
import io.intino.konos.alexandria.activity.schemas.ClusterGroup;
import io.intino.konos.alexandria.activity.schemas.GroupingGroup;
import io.intino.konos.alexandria.activity.schemas.GroupingSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class AlexandriaAbstractCatalog<E extends Catalog, DN extends AlexandriaDisplayNotifier>
extends AlexandriaElementDisplay<E, DN>
implements CatalogViewDisplayProvider {
    private List<Consumer<AlexandriaElementView.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<AlexandriaElementView.OpenItemEvent>>();
    private List<Consumer<AlexandriaElementView.OpenElementEvent>> openElementListeners = new ArrayList<Consumer<AlexandriaElementView.OpenElementEvent>>();
    private String condition = null;
    private String currentItem = null;
    protected Map<String, GroupingSelection> groupingSelectionMap = new HashMap<String, GroupingSelection>();
    protected ItemList itemList = null;
    protected GroupingManager groupingManager;
    private String attachedGrouping = null;
    private int maxItems = -1;

    public AlexandriaAbstractCatalog(Box box) {
        super(box);
    }

    @Override
    public void reset() {
    }

    public boolean isFor(E catalog) {
        return ((Catalog)this.element()).name().equals(((Element)catalog).name());
    }

    public void catalog(E catalog) {
        this.element(catalog);
    }

    public void selectView(String name) {
        this.child(AlexandriaCatalogViewList.class).selectView(name);
    }

    public void selectGrouping(GroupingSelection selection) {
        Grouping abstractGrouping = this.groupingOf(selection.name());
        if (selection.groups().size() <= 0 || abstractGrouping.histogram() == Grouping.Histogram.Absolute && selection.groups().size() <= 0) {
            this.groupingSelectionMap.remove(selection.name());
            this.refreshGroupingsSelection();
        } else {
            this.groupingSelectionMap.put(selection.name(), selection);
        }
        this.dirty(true);
        this.filterGroupingManager();
        this.attachGrouping(selection.name());
    }

    public void attachGrouping(String grouping) {
        this.attachedGrouping = grouping;
        this.refreshGrouping();
    }

    public void detachGrouping(String grouping) {
        this.attachedGrouping = grouping;
        this.refreshGrouping();
    }

    public void deleteGroupingGroup(GroupingGroup groupingGroup) {
        Grouping grouping = this.groupingOf(groupingGroup.grouping());
        if (grouping == null || !grouping.cluster()) {
            return;
        }
        Group group = grouping.remove(groupingGroup.name());
        if (group == null) {
            return;
        }
        this.sendCatalog();
        if (this.groupingSelectionMap.containsKey(groupingGroup.grouping())) {
            GroupingSelection groupingSelection = this.groupingSelectionMap.get(groupingGroup.grouping());
            groupingSelection.groups().remove(group.label());
            this.selectGrouping(groupingSelection);
        }
    }

    public void refresh(Grouping grouping) {
        this.sendCatalog();
        this.currentView().ifPresent(AlexandriaElementView::refresh);
    }

    public void refreshViews() {
        this.child(AlexandriaCatalogViewList.class).refresh();
    }

    @Override
    public int countItems(String condition) {
        this.updateCondition(condition);
        this.loadItemList(condition);
        return this.itemList.count();
    }

    @Override
    public List<Item> items(int start, int limit, String condition) {
        return this.items(start, limit, condition, null);
    }

    @Override
    public List<Item> items(int start, int limit, String condition, ElementViewDisplayProvider.Sorting sorting) {
        this.updateCondition(condition);
        this.loadItemList(condition);
        return this.itemList.items(start, limit, sorting);
    }

    @Override
    public Item rootItem(List<Item> itemList) {
        return ((Catalog)this.element()).rootItem(itemList, this.session());
    }

    @Override
    public Item defaultItem(String name) {
        return ((Catalog)this.element()).defaultItem(name, this.session());
    }

    @Override
    protected Item currentItem() {
        return this.item(this.currentItem);
    }

    @Override
    protected void currentItem(String id) {
        this.currentItem = id;
    }

    @Override
    public Item item(String key) {
        Item item = null;
        if (!this.dirty() && this.itemList != null) {
            item = this.itemList.items().stream().filter(i -> i.id().equals(key) || i.name().equals(key)).findFirst().orElse(null);
        }
        return item != null ? item : ((Catalog)this.element()).item(key, this.session());
    }

    @Override
    public List<Sorting> sortings() {
        return ((Catalog)this.element()).sortings();
    }

    @Override
    public Sorting sorting(String key) {
        return ((Catalog)this.element()).sortings().stream().filter(s -> s.name().equals(key) || s.label().equals(key)).findFirst().orElse(null);
    }

    public void onOpenItem(Consumer<AlexandriaElementView.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    public void onOpenElement(Consumer<AlexandriaElementView.OpenElementEvent> listener) {
        this.openElementListeners.add(listener);
    }

    protected void refreshGrouping() {
        this.refreshView();
        this.refreshScope();
        this.sendCatalog();
    }

    protected void refreshScope() {
        this.currentView().ifPresent(v -> {
            if (v instanceof AlexandriaCatalogDisplayView) {
                ((AlexandriaCatalogDisplayView)v).refresh(this.scopeWithAttachedGrouping());
            }
        });
    }

    @Override
    protected void init() {
        super.init();
        this.createDialogContainer();
        this.createGroupingManager();
        this.buildViewList();
        this.sendCatalog();
        this.createItemDisplay();
    }

    protected void createGroupingManager() {
        this.groupingManager = new GroupingManager(this.filteredItemList(this.defaultScope(), null).items(), this.groupings(), ((Catalog)this.element()).arrangementFilterer(this.session()));
    }

    protected ElementView<Catalog> catalogViewOf(final AbstractView view) {
        return new ElementView<Catalog>(){

            @Override
            public String name() {
                return view.name();
            }

            @Override
            public String label() {
                return view.label();
            }

            @Override
            public String type() {
                return view.getClass().getSimpleName();
            }

            @Override
            public <V extends AbstractView> V raw() {
                return (V)view;
            }

            @Override
            public boolean embeddedElement() {
                return AlexandriaAbstractCatalog.this.embedded();
            }

            @Override
            public Toolbar toolbar() {
                return this.element().toolbar();
            }

            @Override
            public int width() {
                if (view instanceof MagazineView) {
                    return ((MagazineView)view).width();
                }
                if (view instanceof ListView) {
                    return ((ListView)view).width();
                }
                if (view instanceof GridView) {
                    return ((GridView)view).width();
                }
                return 100;
            }

            @Override
            public Mold mold() {
                if (view instanceof MoldView) {
                    return ((MoldView)view).mold();
                }
                return null;
            }

            @Override
            public OnClickRecord onClickRecordEvent() {
                Events events = ((Catalog)AlexandriaAbstractCatalog.this.element()).events();
                return events != null ? events.onClickRecord() : null;
            }

            @Override
            public boolean canCreateClusters() {
                return AlexandriaAbstractCatalog.this.canCreateClusters();
            }

            @Override
            public boolean canSearch() {
                return AlexandriaAbstractCatalog.this.canSearch();
            }

            @Override
            public List<String> clusters() {
                return this.element().groupings().stream().filter(Grouping::cluster).map(Arrangement::label).collect(Collectors.toList());
            }

            @Override
            public Item target() {
                return AlexandriaAbstractCatalog.this.target();
            }

            @Override
            public Catalog element() {
                return (Catalog)AlexandriaAbstractCatalog.this.element();
            }

            @Override
            public String emptyMessage() {
                if (view instanceof MagazineView) {
                    return ((MagazineView)view).noRecordMessage();
                }
                if (view instanceof ListView) {
                    return ((ListView)view).noRecordsMessage();
                }
                if (view instanceof GridView) {
                    return ((GridView)view).noRecordsMessage();
                }
                return null;
            }
        };
    }

    protected abstract void sendCatalog();

    protected abstract ItemList filteredItemList(Scope var1, String var2);

    protected boolean canCreateClusters() {
        return ((Catalog)this.element()).groupings().size() > 0;
    }

    protected boolean isGrouping(Map.Entry<String, GroupingSelection> entry) {
        return !this.groupingOf(entry.getKey()).cluster();
    }

    protected boolean isCluster(Map.Entry<String, GroupingSelection> entry) {
        return this.groupingOf(entry.getKey()).cluster();
    }

    private List<ElementView> viewList() {
        return this.views().stream().map(this::catalogViewOf).collect(Collectors.toList());
    }

    private boolean canSearch() {
        Toolbar toolbar = ((Catalog)this.element()).toolbar();
        return toolbar == null || toolbar.canSearch();
    }

    private void updateCondition(String condition) {
        if (this.condition == null && condition != null && !condition.isEmpty() || this.condition != null && !this.condition.equals(condition)) {
            this.dirty(true);
        }
        this.condition = condition;
    }

    protected void loadItemList(String condition) {
        if (!this.dirty() && this.itemList != null) {
            return;
        }
        this.itemList = this.filteredItemList(this.scopeWithAttachedGrouping(), condition);
        this.dirty(false);
    }

    protected void refreshGroupingsSelection() {
        this.groupingSelectionMap.forEach((key, value) -> {
            ArrayList<String> newGroups = new ArrayList<String>();
            GroupMap groupMap = this.groupingManager.groups(this.groupingOf((String)key));
            value.groups().forEach(groupLabel -> {
                String name = Group.name(groupLabel);
                if (groupMap.containsKey(name)) {
                    newGroups.add((String)groupLabel);
                }
            });
            value.groups(newGroups);
        });
        this.groupingSelectionMap = this.groupingSelectionMap.entrySet().stream().filter(e -> ((GroupingSelection)e.getValue()).groups().size() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected Scope defaultScope() {
        return new Scope().target(this.target());
    }

    protected Scope scopeWithAttachedGrouping() {
        return this.calculateScope(true);
    }

    private void buildViewList() {
        AlexandriaCatalogViewList display = new AlexandriaCatalogViewList(this.box);
        display.itemProvider(this);
        display.viewList(this.viewList());
        display.onSelectView(this::updateCurrentView);
        display.onOpenItem(this::openItem);
        display.onOpenItemDialog(this::openItemDialog);
        display.onOpenItemCatalog(this::openItemCatalog);
        display.onExecuteItemTask(this::executeItemTask);
        display.onLoading(this::notifyLoading);
        this.add(display);
        display.personifyOnce();
    }

    @Override
    protected void openItem(AlexandriaElementView.OpenItemEvent event) {
        if (event.panel() == null) {
            return;
        }
        if (this.openItemListeners.size() > 0) {
            this.openItemListeners.forEach(l -> l.accept(event));
            return;
        }
        super.openItem(event);
    }

    @Override
    public void createClusterGroup(ClusterGroup value) {
    }

    public void maxItems(int max) {
        ((Catalog)this.element()).mode(Catalog.Mode.Preview);
        this.maxItems = max;
    }

    private Scope calculateScope(boolean addAttachedGrouping) {
        Scope scope = this.defaultScope();
        if (this.groupingSelectionMap.size() <= 0) {
            return scope;
        }
        scope.groups(this.groupingSelectionMap.entrySet().stream().filter(this::isGrouping).filter(g -> this.attachedGroupingFilter((GroupingSelection)g.getValue(), addAttachedGrouping)).collect(Collectors.toMap(Map.Entry::getKey, e -> this.groups((GroupingSelection)e.getValue()))));
        return scope;
    }

    protected void filterGroupingManager() {
        this.groupingManager.clearFilter();
        this.groupingSelectionMap.values().stream().filter(g -> {
            Grouping grouping = this.groupingOf(g.name());
            return grouping != null && !grouping.cluster();
        }).forEach(selection -> {
            Grouping grouping = this.groupingOf((GroupingSelection)selection);
            if (grouping != null) {
                this.groupingManager.filter(grouping.name(), this.groupsNames(selection.groups()));
            }
        });
        this.sendCatalog();
    }

    @Override
    protected void applyFilter(ItemList itemList) {
        super.applyFilter(itemList);
        if (this.maxItems > 0) {
            itemList.filterCount(this.maxItems);
        }
    }

    private boolean attachedGroupingFilter(GroupingSelection groupingSelection, boolean addAttachedGrouping) {
        if (addAttachedGrouping) {
            return true;
        }
        return !groupingSelection.name().equals(this.attachedGrouping);
    }

    private List<String> groupsNames(List<String> labels) {
        return labels.stream().map(Group::name).collect(Collectors.toList());
    }

    private Grouping groupingOf(GroupingSelection selection) {
        Grouping grouping = this.groupingOf(selection.name());
        return grouping != null && !grouping.cluster() ? grouping : null;
    }

    private List<Group> groups(GroupingSelection selection) {
        GroupMap groupMap = this.groupingManager.groups(this.groupingOf(selection));
        return groupMap != null ? this.groupsNames(selection.groups()).stream().map(groupMap::get).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Grouping> groupings() {
        return ((Catalog)this.element()).groupings();
    }

    private Grouping groupingOf(String groupingName) {
        return ((Catalog)this.element()).groupings().stream().filter(g -> g.name().equals(groupingName)).findFirst().orElse(null);
    }

    private void createItemDisplay() {
        AlexandriaItem display = new AlexandriaItem(this.box);
        this.add(display);
        display.personifyOnce();
    }

    protected void reloadGroupings() {
        this.sendCatalog();
    }
}

