/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity;

import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.displays.MessageCarrier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class Activity {
    private static Map<Class<? extends AlexandriaDisplay>, Class<? extends AlexandriaDisplayNotifier>> notifiers = new HashMap<Class<? extends AlexandriaDisplay>, Class<? extends AlexandriaDisplayNotifier>>();

    protected static <DN extends AlexandriaDisplayNotifier> DisplayNotifierRegistration register(final Class<DN> notifierClass) {
        return new DisplayNotifierRegistration(){

            @Override
            public <D extends AlexandriaDisplay> void forDisplay(Class<D> displayClass) {
                notifiers.put(displayClass, notifierClass);
            }
        };
    }

    protected static AlexandriaDisplayNotifierProvider notifierProvider() {
        return (display, carrier) -> {
            try {
                return Activity.notifierFor(display).newInstance(display, carrier);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
                System.err.println(error.getMessage());
                return null;
            }
        };
    }

    private static Constructor<? extends AlexandriaDisplayNotifier> notifierFor(AlexandriaDisplay display) throws NoSuchMethodException {
        Class<? extends AlexandriaDisplayNotifier> clazz = notifiers.get(display.getClass());
        if (clazz == null) {
            clazz = notifiers.getOrDefault(Activity.displayByInheritance(display.getClass()), AlexandriaDisplayNotifier.class);
        }
        return clazz.getConstructor(AlexandriaDisplay.class, MessageCarrier.class);
    }

    private static Class<? extends AlexandriaDisplay> displayByInheritance(Class<? extends AlexandriaDisplay> clazz) {
        return notifiers.keySet().stream().filter(dc -> dc.isAssignableFrom(clazz)).findFirst().orElse(null);
    }

    protected static interface DisplayNotifierRegistration {
        public <D extends AlexandriaDisplay> void forDisplay(Class<D> var1);
    }
}

