/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.LogFormatter;
import io.intino.konos.alexandria.activity.ActivityAlexandriaSpark;
import io.intino.konos.alexandria.activity.ActivityBox;
import io.intino.konos.alexandria.activity.ActivityElementsActivity;
import io.intino.konos.alexandria.activity.AlexandriaActivityBox;
import io.intino.konos.alexandria.activity.AlexandriaActivityConfiguration;
import io.intino.konos.alexandria.activity.displays.Soul;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBox
extends ActivityBox {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    protected AlexandriaActivityConfiguration configuration;
    protected Map<String, Soul> activitySouls = new HashMap<String, Soul>();
    private List<ActivityBox.SoulsClosed> soulsClosedListeners = new ArrayList<ActivityBox.SoulsClosed>();

    public AbstractBox(String[] args) {
        this(new AlexandriaActivityConfiguration(args));
    }

    public AbstractBox(AlexandriaActivityConfiguration configuration) {
        this.configuration = configuration;
        if (this.configuration().activityElementsConfiguration != null) {
            ActivityAlexandriaSpark.setup(this.configuration().activityElementsConfiguration.port, this.configuration().activityElementsConfiguration.webDirectory, this.configuration().activityElementsConfiguration.authService);
        }
    }

    public AlexandriaActivityConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initActivities();
        this.initRESTServices();
        this.initJMXServices();
        this.initJMSServices();
        this.initDataLake();
        this.initTasks();
        this.initSlackBots();
        return this;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
        ActivityAlexandriaSpark.instance().stop();
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.activitySouls.get(clientId));
    }

    @Override
    public void registerSoul(String clientId, Soul soul) {
        this.activitySouls.put(clientId, soul);
    }

    @Override
    public void unRegisterSoul(String clientId) {
        this.activitySouls.remove(clientId);
        if (this.activitySouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(ActivityBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    private void initRESTServices() {
    }

    private void initJMSServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
    }

    private void initActivities() {
        if (this.configuration().activityElementsConfiguration == null) {
            return;
        }
        ActivityAlexandriaSpark sparkInstance = ActivityAlexandriaSpark.instance();
        ActivityElementsActivity.init(sparkInstance, (AlexandriaActivityBox)this);
        ActivityElementsActivity.initDisplays(sparkInstance);
        sparkInstance.start();
        logger.info("Activity ActivityElements: started!");
    }

    private void initDataLake() {
    }

    private void initTasks() {
    }

    private void initLogger() {
        java.util.logging.Logger logger = java.util.logging.Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new LogFormatter("log"));
        logger.addHandler(handler);
    }
}

