/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.KonosGraph;
import io.intino.konos.dsl.Service;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PageRenderer
extends ActionRenderer {
    private final CompilationContext compilationContext;
    private final Service.UI.Resource resource;
    private final Service.UI service;
    private final Target target;

    public PageRenderer(CompilationContext compilationContext, Service.UI.Resource resource, Target target) {
        super(compilationContext, PageRenderer.types((Service.UI)resource.core$().ownerAs(Service.UI.class)));
        this.compilationContext = compilationContext;
        this.resource = resource;
        this.service = (Service.UI)resource.core$().ownerAs(Service.UI.class);
        this.target = target;
    }

    @Override
    public void render() {
        this.writeWebPage(this.buildFrame());
        if (this.isMobile(this.service)) {
            this.writeMobilePage(this.buildFrame().add("mobile"));
        }
    }

    private FrameBuilder buildFrame() {
        FrameBuilder builder = new FrameBuilder().add("action").add("ui");
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        builder.add("name", (Object)this.resource.name$());
        if (this.resource.isPage()) {
            builder.add("templateName", (Object)this.resource.asPage().template().name$());
        }
        if (this.resource.isAssetPage()) {
            builder.add("asset");
        }
        builder.add("returnType", (Object)this.returnTypeFrame());
        builder.add("executeBody", (Object)this.executeBodyFrame());
        builder.add("uiService", (Object)uiService.name$());
        builder.add("package", (Object)this.packageName());
        builder.add("box", (Object)this.boxName());
        builder.add("importTemplates", (Object)this.packageName());
        builder.add("component", (Object)this.componentFrame());
        builder.add("parameter", (Object)this.parameters());
        builder.add("contextProperty", (Object)this.contextPropertyFrame());
        this.service.useList().forEach(use -> builder.add("usedUnit", (Object)this.usedUnitFrame((Service.UI.Use)((Object)use))));
        if (this.service.title() != null) {
            builder.add("title", (Object)this.titleFrame());
        }
        if (this.service.favicon() != null) {
            builder.add("favicon", (Object)this.service.favicon());
        }
        return builder;
    }

    private void writeWebPage(FrameBuilder builder) {
        this.compilationContext.classes().put(((Object)((Object)this.resource)).getClass().getSimpleName() + "#" + Commons.firstUpperCase(this.resource.core$().name()), "actions." + Commons.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)this.resource.name$())) + this.suffix(Target.Service));
        if (!this.alreadyRendered(this.src(this.target), this.resource.name$())) {
            Commons.writeFrame(this.destinationPackage(this.src(this.target)), this.resource.name$() + this.suffix(this.target), new ActionTemplate().render(builder.toFrame(), Formatters.all));
            if (this.target.equals((Object)Target.Service)) {
                this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(this.destinationPackage(this.src(this.target)), this.resource.name$() + this.suffix(this.target)).getAbsolutePath()));
            }
        }
        Commons.writeFrame(this.destinationPackage(this.gen(this.target)), "Abstract" + Commons.firstUpperCase(this.resource.name$()) + this.suffix(this.target), new ActionTemplate().render(builder.add("gen").toFrame(), Formatters.all));
        if (this.target.equals((Object)Target.Service)) {
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(this.destinationPackage(this.gen(this.target)), "Abstract" + Commons.firstUpperCase(this.resource.name$()) + this.suffix(this.target)).getAbsolutePath()));
        }
    }

    private void writeMobilePage(FrameBuilder builder) {
        Target target = Target.MobileShared;
        this.compilationContext.classes().put(((Object)((Object)this.resource)).getClass().getSimpleName() + "#" + Commons.firstUpperCase(this.resource.core$().name()), "actions." + Commons.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)this.resource.name$())) + this.suffix(Target.MobileShared));
        if (!this.alreadyRendered(this.src(Target.Service), this.resource.name$(), target)) {
            Commons.writeFrame(this.destinationPackage(this.src(Target.Service)), this.resource.name$() + this.suffix(target), new ActionTemplate().render(builder.toFrame(), Formatters.all));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(this.destinationPackage(this.src(Target.Service)), this.resource.name$() + this.suffix(target)).getAbsolutePath()));
        }
        Commons.writeFrame(this.destinationPackage(this.gen(Target.Service)), "Abstract" + Commons.firstUpperCase(this.resource.name$()) + this.suffix(target), new ActionTemplate().render(builder.add("gen").toFrame(), Formatters.all));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(this.destinationPackage(this.gen(Target.Service)), "Abstract" + Commons.firstUpperCase(this.resource.name$()) + this.suffix(target)).getAbsolutePath()));
    }

    private FrameBuilder executeBodyFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"executeBody"});
        this.service.useList().forEach(use -> result.add("usedUnit", (Object)this.usedUnitFrame((Service.UI.Use)((Object)use))));
        if (this.resource.isPage()) {
            result.add("templateName", (Object)this.resource.asPage().template().name$());
        }
        if (this.resource.isStaticPage()) {
            result.add("static");
            result.add("text", (Object)this.resource.asStaticPage().content());
        }
        if (this.resource.isAssetPage()) {
            result.add("asset");
        }
        return result;
    }

    private FrameBuilder returnTypeFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"returnType"});
        if (this.resource.isAssetPage()) {
            result.add("asset");
        }
        return result;
    }

    private FrameBuilder titleFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"title"});
        String title = this.service.title();
        if (title.startsWith("{") && title.endsWith("}")) {
            title = title.substring(1, title.length() - 1);
            result.add("configuration");
        }
        result.add("title", (Object)title);
        return result;
    }

    @Override
    protected ActionRenderer.ContextType contextType() {
        return ActionRenderer.ContextType.Server;
    }

    private Frame usedUnitFrame(Service.UI.Use use) {
        FrameBuilder result = new FrameBuilder(new String[]{"usedUnit"});
        result.add(this.isCustomParameter(use.url()) ? "custom" : "standard");
        result.add("name", (Object)use.name().toLowerCase());
        result.add("url", (Object)(this.isCustomParameter(use.url()) ? this.customParameterValue(use.url()) : use.url()));
        if (use.socketPath() != null) {
            result.add("socketPath", (Object)use.socketPath());
        }
        return result.toFrame();
    }

    private FrameBuilder componentFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"component"});
        if (this.resource.isPage()) {
            result.add("value", (Object)KonosGraph.templateFor(this.resource).name$());
        }
        if (this.resource.isStaticPage()) {
            result.add("static");
            result.add("text", (Object)this.resource.asStaticPage().content());
        }
        if (this.resource.isAssetPage()) {
            result.add("asset");
        }
        return result;
    }

    private FrameBuilder[] parameters() {
        List<String> parameters = Commons.extractUrlPathParameters(this.resource.path());
        parameters.addAll(this.resource.parameterList().stream().map(Layer::name$).toList());
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add("type", (Object)"String").add("name", parameter)).toArray(FrameBuilder[]::new);
    }

    @Override
    protected File destinationPackage(File destiny) {
        return new File(destiny, CodeGenerationHelper.format("%spages", Target.Service));
    }

    @Override
    protected String suffix(Target target) {
        return target == Target.MobileShared ? "MobilePage" : "Page";
    }

    private static String[] types(Service.UI service) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ui");
        return result.toArray(new String[0]);
    }
}

