/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.schema;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.schema.SchemaHelper;
import io.intino.konos.builder.codegeneration.schema.SchemaWriter;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.dsl.Data;
import io.intino.konos.dsl.Schema;
import io.intino.konos.dsl.Service;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SchemaRenderer
extends Renderer {
    private final Schema schema;
    private final String packageName;
    private final boolean serializationAnnotations;
    private final SchemaWriter writer;

    public SchemaRenderer(CompilationContext compilationContext, Schema schema, File destination, String packageName, boolean serializationAnnotations, SchemaWriter writer) {
        super(compilationContext);
        this.schema = schema;
        this.writer = writer;
        this.serializationAnnotations = serializationAnnotations;
        this.packageName = packageName != null ? packageName : compilationContext.packageName();
    }

    @Override
    public void render() {
        String rootPackage = this.packageName;
        String subPackage = SchemaHelper.subPackage(this.schema);
        String packageName = subPackage.isEmpty() ? rootPackage : rootPackage + "." + subPackage.replace(File.separator, ".");
        Frame frame = this.createSchemaFrame(this.schema, packageName);
        this.classes().put(Schema.class.getSimpleName() + "#" + this.schema.name$(), subPackage.replace(File.separator, ".") + "." + this.schema.name$());
        this.writer.write(this.schema, frame);
    }

    public Frame createSchemaFrame(Schema schema, String packageName) {
        return this.createSchemaFrame(schema, packageName, new HashSet<Schema>());
    }

    private Frame createSchemaFrame(Schema schema, String packageName, Set<Schema> processed) {
        Frame[] components;
        FrameBuilder builder = new FrameBuilder(new String[]{"schema"}).add("name", (Object)schema.name$()).add("package", (Object)packageName);
        if (schema.core$().owner().is(Schema.class)) {
            builder.add("inner", (Object)"static");
        }
        builder.add("attribute", (Object)this.collectAttributes(schema));
        if (schema.isExtensionOf()) {
            builder.add("parent", (Object)schema.asExtensionOf().parent().name$());
        }
        if ((components = this.components(schema, packageName, processed)).length > 0) {
            builder.add("schema", (Object)components);
        }
        return builder.toFrame();
    }

    private Frame[] components(Schema schema, String packageName, Set<Schema> processed) {
        return (Frame[])schema.schemaList().stream().filter(processed::add).map(s -> this.createSchemaFrame((Schema)((Object)s), packageName, processed)).toArray(Frame[]::new);
    }

    private FrameBuilder[] collectAttributes(Schema schema) {
        ArrayList attributes = new ArrayList();
        Collections.addAll(attributes, this.processAttributes(schema.attributeList()));
        Collections.addAll(attributes, this.processSchemasAsAttribute(schema.schemaList()));
        attributes.forEach(f -> f.add("element", (Object)schema.name$()));
        return attributes.toArray(new FrameBuilder[0]);
    }

    private FrameBuilder[] processAttributes(List<Schema.Attribute> attributes) {
        return (FrameBuilder[])attributes.stream().map(this::process).filter(Objects::nonNull).map(fb -> this.serializationAnnotations ? fb.add("annotated") : fb).toArray(FrameBuilder[]::new);
    }

    private FrameBuilder[] processSchemasAsAttribute(List<Schema> schemas) {
        return (FrameBuilder[])schemas.stream().map(s -> this.processSchema((Schema)((Object)s), s.name$(), s.multiple())).toArray(FrameBuilder[]::new);
    }

    private FrameBuilder process(Schema.Attribute attribute) {
        if (attribute.isReal()) {
            return this.process(attribute.asReal());
        }
        if (attribute.isInteger()) {
            return this.process(attribute.asInteger());
        }
        if (attribute.isBool()) {
            return this.process(attribute.asBool());
        }
        if (attribute.isText()) {
            return this.process(attribute.asText());
        }
        if (attribute.isDateTime()) {
            return this.process(attribute.asDateTime());
        }
        if (attribute.isDate()) {
            return this.process(attribute.asDate());
        }
        if (attribute.isFile()) {
            return this.process(attribute.asFile());
        }
        if (attribute.isLongInteger()) {
            return this.process(attribute.asLongInteger());
        }
        if (attribute.isWord()) {
            return this.process(attribute.asWord());
        }
        if (attribute.isMap()) {
            return this.process(attribute.asMap());
        }
        if (attribute.isObject()) {
            return this.processObjectAttribute(attribute.asObject().schema(), attribute.name$(), attribute.isList());
        }
        return null;
    }

    private FrameBuilder process(Data.Real attribute) {
        return new FrameBuilder(new String[]{"primitive", this.cardinality(attribute.asData()), "double"}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)(this.multiple(attribute.asData()) ? attribute.type() : "double")).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "real"}).add("value", (Object)attribute.type())).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Integer attribute) {
        return new FrameBuilder(new String[]{"primitive", this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)(this.multiple(attribute.asData()) ? attribute.type() : "int")).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "integer"}).add("value", (Object)attribute.type())).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.LongInteger attribute) {
        return new FrameBuilder(new String[]{"primitive", this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "longinteger"}).add("value", (Object)attribute.type())).add("defaultValue", (Object)(attribute.defaultValue() + "L"));
    }

    private FrameBuilder process(Data.File attribute) {
        return new FrameBuilder(new String[]{"primitive", this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "file"}).add("value", (Object)attribute.type())).add("lateInit", (Object)"");
    }

    private FrameBuilder process(Data.Bool attribute) {
        return new FrameBuilder(new String[]{"primitive", this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "boolean"}).add("value", (Object)attribute.type())).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Text attribute) {
        FrameBuilder builder = new FrameBuilder(new String[]{this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "text"}).add("value", (Object)attribute.type())).add("lateInit", (Object)"");
        if (attribute.defaultValue() != null) {
            builder.add("defaultValue", (Object)("\"" + attribute.defaultValue() + "\""));
        }
        return builder;
    }

    private FrameBuilder process(Data.DateTime attribute) {
        return new FrameBuilder(new String[]{"primitive", this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "datetime"}).add("value", (Object)attribute.type())).add("lateInit", (Object)"");
    }

    private FrameBuilder process(Data.Date attribute) {
        return new FrameBuilder(new String[]{"primitive", this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("type", (Object)attribute.type()).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "date"}).add(attribute.type()).add("value", (Object)attribute.type())).add("lateInit", (Object)"");
    }

    private FrameBuilder process(Data.Word attribute) {
        Schema.Attribute a = (Schema.Attribute)attribute.a$(Schema.Attribute.class);
        return new FrameBuilder(new String[]{"word", this.cardinality(attribute.asData()), attribute.type()}).add("name", (Object)a.name$()).add("words", (Object)attribute.values().toArray(new String[0])).add("type", (Object)a.name$()).add("typeFrame", (Object)new FrameBuilder(new String[]{"typeFrame", "word"}).add(attribute.type()).add("value", (Object)attribute.type())).add("lateInit", (Object)"");
    }

    private FrameBuilder process(Data.Map attribute) {
        return new FrameBuilder(new String[]{"map", attribute.value().isList() ? "valueList" : "valueSingle", attribute.key().isList() ? "keyList" : "keySingle"}).add("name", (Object)((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()).add("key", (Object)new FrameBuilder(new String[]{attribute.key().isList() ? "list" : "single"}).add("type", (Object)attribute.key().asType().type())).add("value", (Object)new FrameBuilder(new String[]{attribute.value().isList() ? "list" : "single"}).add("type", (Object)attribute.value().asType().type())).add("lateInit", (Object)"");
    }

    private FrameBuilder processObjectAttribute(Schema schema, String name, boolean multiple) {
        return new FrameBuilder(new String[]{multiple ? "list" : "single", "object", schema.name$()}).add("name", (Object)name).add("type", (Object)schema.name$()).add("lateInit", (Object)"").add("package", (Object)this.packageOf(schema));
    }

    private FrameBuilder processSchema(Schema schema, String name, boolean multiple) {
        return new FrameBuilder(new String[]{multiple ? "list" : "single", "schema", schema.name$()}).add("name", (Object)name).add("type", (Object)schema.name$()).add("lateInit", (Object)"").add("package", (Object)this.packageOf(schema));
    }

    private String packageOf(Schema schema) {
        Service service = (Service)schema.core$().ownerAs(Service.class);
        String subPackage = "schemas" + (String)(service != null ? File.separator + service.name$().toLowerCase() : "");
        return this.packageName + "." + subPackage.replace(File.separator, ".");
    }

    private String cardinality(Data attribute) {
        return attribute.isList() ? "list" : (attribute.isSet() ? "set" : "single");
    }

    private boolean multiple(Data attribute) {
        return attribute.isList() || attribute.isSet();
    }
}

