/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CategoricalAxisTemplate
extends Template {
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"axis"})).output(new Output[]{Outputs.literal((String)"package ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)".analytic.axes;\n\nimport ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)".analytic.Axis;\n\nimport java.util.*;\nimport java.util.stream.Stream;\nimport java.util.function.Predicate;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\n\npublic class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)" implements Axis {\n\n\tpublic static final String TITLE = \"")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\";\n\n\tpublic static final Component NA = new Component(0, \"NA\"")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"defaultValue"}).multiple(", ")})}).output(new Output[]{Outputs.literal((String)");\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"component", (String[])new String[0]).multiple("\n")})}).output(new Output[]{Outputs.literal((String)"\n\n\tprivate static final class Singleton {\n\t\tprivate static final ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)" INSTANCE = new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"();\n\t}\n\n\t// === STATIC METHODS === //\n\n\tpublic static ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)" get() {\n\t\treturn Singleton.INSTANCE;\n\t}\n\n\tpublic static String title() {\n\t\treturn TITLE;\n\t}\n\n\tpublic static int size() {\n\t\treturn get().getSize();\n\t}\n\n\tpublic static List<Component> components() {\n\t\treturn get().getComponents();\n\t}\n\n\tpublic static Stream<Component> stream() {\n\t\treturn get().toStream();\n\t}\n\n\tpublic static List<Component> components(Predicate<Component> filter) {\n\t\treturn get().getComponents(filter);\n\t}\n\n\tpublic static Component component(int index) {\n\t\treturn get().getComponent(index);\n\t}\n\n\tpublic static Component component(String name) {\n\t\treturn get().getComponent(name);\n\t}\n\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"staticGetter"}).multiple("\n\n")})}).output(new Output[]{Outputs.literal((String)"\n\n\t// === === //\n\n\tprivate final Component[] components;\n\tprivate final Map<String, Component> componentsByName;\n\n\tprivate ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"() {\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"components", (String[])new String[]{"load"})})}).output(new Output[]{Outputs.literal((String)"\n\t\tthis.componentsByName = toStream().collect(Collectors.toMap(Component::id, Function.identity()));\n\t}\n\n\t@Override\n\tpublic String getTitle() {\n\t\treturn TITLE;\n\t}\n\n\t@Override\n\tpublic int getSize() {\n\t\treturn components.length;\n\t}\n\n\t/**\n\t* Get all components of this axis as a list, without the NA component (Starts with the component of index 1).\n\t*/\n\t@Override\n\tpublic List<Component> getComponents() {\n\t\treturn new AbstractList<>() {\n\t\t\t@Override\n\t\t\tpublic Component get(int index) {\n\t\t\t\treturn component(index + 1);\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic int size() {\n\t\t\t\treturn ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".size() - 1;\n\t\t\t}\n\t\t};\n\t}\n\n\t/**\n\t* Get all components of this axis as a stream, without the NA component (Starts with the component of index 1).\n\t*/\n\t@Override\n\tpublic Stream<Component> toStream() {\n\t\treturn Arrays.stream(components).skip(1);\n\t}\n\n\tpublic List<Component> getComponents(Predicate<Component> filter) {\n\t\treturn stream().filter(filter).collect(Collectors.toList());\n\t}\n\n\t@Override\n\tpublic Component getComponent(int index) {\n\t\tif(index < 0 || index >= components.length) return NA;\n\t\treturn components[index];\n\t}\n\n\t@Override\n\tpublic Component getComponent(String name) {\n\t\treturn componentsByName.getOrDefault(name, NA);\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn \"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"\";\n\t}\n\n\n\tpublic static class Component implements Axis.Component {\n\n\t\tprivate final int index;\n\t\tprivate final String id;\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"declaration"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\n\t\tComponent(int index, String id")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"parameter"}).multiple(", ")})}).output(new Output[]{Outputs.literal((String)") {\n\t\t\tthis.index = index;\n\t\t\tthis.id = id;\n\t\t\t")}).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"assign"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\t\t}\n\n\t\t@Override\n\t\tpublic int index() {\n\t\t\treturn index;\n\t\t}\n\n\t\t@Override\n\t\tpublic String id() {\n\t\t\treturn id;\n\t\t}\n\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"getter"}).multiple("\n\n")})}).output(new Output[]{Outputs.literal((String)"\n\n\t\t@Override\n\t\tpublic Axis axis() {\n\t\t\treturn ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".get();\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (this == o) return true;\n\t\t\tif (o == null || getClass() != o.getClass()) return false;\n\t\t\tComponent component = (Component) o;\n\t\t\treturn index == component.index;\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(index, id);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn id;\n\t\t}\n\t}\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"component"})).output(new Output[]{Outputs.literal((String)"public static final Component ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)" = new Component(")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)", \"")}).output(new Output[]{Outputs.placeholder((String)"id", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", \"")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"")})}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"constructor"}).multiple(", ")})}).output(new Output[]{Outputs.literal((String)");")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"name", (Object)"label"), (LogicalExpression)Predicates.trigger((String)"declaration"))).output(new Output[]{Outputs.literal((String)"private final String ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)";")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"include"}), (LogicalExpression)Predicates.attribute((String)"name", (Object)"label")), (LogicalExpression)Predicates.trigger((String)"staticgetter"))).output(new Output[]{Outputs.literal((String)"public static ")}).output(new Output[]{Outputs.placeholder((String)"axis", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Component componentByLabel(String label) {\n\treturn stream().filter(c -> c.label().equals(label)).findFirst().orElse(NA);\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"include"}), (LogicalExpression)Predicates.attribute((String)"type", (Object)"continuous")), (LogicalExpression)Predicates.trigger((String)"staticgetter"))).output(new Output[]{Outputs.literal((String)"public static ")}).output(new Output[]{Outputs.placeholder((String)"axis", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Component componentBy")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Range range) {\n\treturn stream().filter(c -> c.")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)"().equals(range)).findFirst().orElse(NA);\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"include"}), (LogicalExpression)Predicates.attribute((String)"type", (Object)"categorical")), (LogicalExpression)Predicates.trigger((String)"staticgetter"))).output(new Output[]{Outputs.literal((String)"public static ")}).output(new Output[]{Outputs.placeholder((String)"axis", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Component componentBy")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Component component) {\n\treturn stream().filter(c -> c.")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)"().equals(component)).findFirst().orElse(NA);\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"include"}), (LogicalExpression)Predicates.attribute((String)"type", (Object)"continuous")), (LogicalExpression)Predicates.trigger((String)"declaration"))).output(new Output[]{Outputs.literal((String)"private final ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Range ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)";")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"include"}), (LogicalExpression)Predicates.attribute((String)"type", (Object)"categorical")), (LogicalExpression)Predicates.trigger((String)"declaration"))).output(new Output[]{Outputs.literal((String)"private final ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Component ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)";")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"name", (Object)"label"), (LogicalExpression)Predicates.trigger((String)"getter"))).output(new Output[]{Outputs.literal((String)"public String ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)"() {\n\treturn ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)";\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.trigger((String)"getter"), (LogicalExpression)Predicates.attribute((String)"type", (Object)"continuous"))).output(new Output[]{Outputs.literal((String)"public ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Range ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)"() {\n\treturn ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)";\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.trigger((String)"getter"), (LogicalExpression)Predicates.attribute((String)"type", (Object)"categorical"))).output(new Output[]{Outputs.literal((String)"public ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Component ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)"() {\n\treturn ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)";\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"tostring")).output(new Output[]{Outputs.literal((String)"sb.append(\", ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)"=\").append(")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)");")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"name", (Object)"label"), (LogicalExpression)Predicates.trigger((String)"defaultvalue"))).output(new Output[]{Outputs.literal((String)"\"")}).output(new Output[]{Outputs.placeholder((String)"id", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.trigger((String)"defaultvalue"), (LogicalExpression)Predicates.attribute((String)"type", (Object)"categorical"))).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".NA")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.trigger((String)"defaultvalue"), (LogicalExpression)Predicates.attribute((String)"type", (Object)"continuous"))).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".component(0)")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"name", (Object)"label"), (LogicalExpression)Predicates.trigger((String)"parameter"))).output(new Output[]{Outputs.literal((String)"String ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"CamelCase"})}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"type", (Object)"categorical"), (LogicalExpression)Predicates.trigger((String)"parameter"))).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Component ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"type", (Object)"continuous"), (LogicalExpression)Predicates.trigger((String)"parameter"))).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".Range ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"name", (Object)"label"), (LogicalExpression)Predicates.trigger((String)"constructorfromtsv"))).output(new Output[]{Outputs.literal((String)"l.length > ")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)" ? l[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"] : \"NA\"")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.trigger((String)"constructorfromtsv"), (LogicalExpression)Predicates.attribute((String)"type", (Object)"continuous"))).output(new Output[]{Outputs.literal((String)"l.length > ")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)" ? ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".rangeOf(Double.parseDouble(l[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"])) : ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".component(0)")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.trigger((String)"constructorfromtsv"), (LogicalExpression)Predicates.attribute((String)"type", (Object)"categorical"))).output(new Output[]{Outputs.literal((String)"l.length > ")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)" ? ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".component(l[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"]) : ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".NA")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"constructor")).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)".component(\"")}).output(new Output[]{Outputs.placeholder((String)"id", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\")")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"assign")).output(new Output[]{Outputs.literal((String)"this.")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)" = ")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)";")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"put")).output(new Output[]{Outputs.literal((String)"components.put(")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)");\ncomponentsByName.put(\"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\", ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)");")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"field")).output(new Output[]{Outputs.literal((String)"public static final Component ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)" = new Component(")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)", \"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", \"")}).output(new Output[]{Outputs.placeholder((String)"label", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"")})}).output(new Output[]{Outputs.literal((String)");")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"components"}), (LogicalExpression)Predicates.attribute((String)"embedded", (Object)"true")), (LogicalExpression)Predicates.trigger((String)"load"))).output(new Output[]{Outputs.literal((String)"this.components = new Component[] {NA")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"component", (String[])new String[0]).multiple(", ")})}).output(new Output[]{Outputs.literal((String)"};")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"components"}), (LogicalExpression)Predicates.attribute((String)"embedded", (Object)"false")), (LogicalExpression)Predicates.trigger((String)"load"))).output(new Output[]{Outputs.literal((String)"Component[] components = new Component[0];\njava.io.InputStream resource = getClass().getResourceAsStream(\"")}).output(new Output[]{Outputs.placeholder((String)"resource", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\");\nif(resource == null) throw new IllegalStateException(\"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)": Resource \" + \"")}).output(new Output[]{Outputs.placeholder((String)"resource", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\" + \" not found\");\ntry (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(resource))) {\n\t\tcomponents = Stream.concat(Stream.of(NA),\n\t\treader.lines().map(l -> l.split(\"\t\")).map(l -> new Component(Integer.parseInt(l[0]),l[1]")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)",")}).output(new Output[]{Outputs.placeholder((String)"include", (String[])new String[]{"constructorFromTsv"}).multiple(", ")})}).output(new Output[]{Outputs.literal((String)"))\n\t\t).toArray(Component[]::new);\n\t} catch (Exception e) {\n\t\tio.intino.alexandria.logger.Logger.error(\"Failed to load components of ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"\", e);\n\t}\n\tthis.components = components;")}));
        return rules;
    }

    public String render(Object object) {
        return new Engine((Template)this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine((Template)this).addAll(formatters).render(object);
    }
}

