/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.accessor.AccessorPomTemplate;
import io.intino.konos.builder.codegeneration.accessor.ArtifactoryConnector;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.utils.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;

public class PomGenerator {
    private final CompilerConfiguration conf;
    private final CompilationContext context;

    public PomGenerator(CompilationContext context) {
        this.context = context;
        this.conf = context.configuration();
    }

    public File generate(String serviceType, File dir) throws KonosException {
        return this.createPom(dir, serviceType, this.context.configuration().groupId().toLowerCase(), dir.getName().split("#")[1], this.context.configuration().version());
    }

    private File createPom(File root, String serviceType, String group, String artifact, String version) throws KonosException {
        try {
            FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)artifact).add("version", (Object)version);
            if (this.conf.releaseDistributionRepository() != null) {
                this.buildRepoFrame(builder, this.conf.releaseDistributionRepository(), true, false);
            }
            if (this.conf.snapshotDistributionRepository() != null) {
                this.buildRepoFrame(builder, this.conf.snapshotDistributionRepository(), true, true);
            }
            builder.add("dependency", (Object)new FrameBuilder(new String[]{serviceType}).add("value", (Object)"").add("version", (Object)this.versionOf(serviceType)).toFrame());
            File pomFile = new File(root, "pom.xml");
            this.write(builder, pomFile);
            return pomFile;
        }
        catch (Throwable e) {
            throw new KonosException(e.getMessage(), e);
        }
    }

    public String coors(File dir) {
        return String.join((CharSequence)":", this.context.configuration().groupId().toLowerCase().toLowerCase(), dir.getName().split("#")[1].toLowerCase(), this.context.configuration().version());
    }

    private String versionOf(String serviceType) {
        String artifact = "";
        if ("rest".equals(serviceType)) {
            artifact = "io.intino.alexandria:rest-accessor";
        } else if ("ui".equals(serviceType)) {
            artifact = "io.intino.alexandria:ui-framework";
        } else if ("messaging".equals(serviceType)) {
            artifact = "io.intino.alexandria:terminal-jms";
        } else if ("analytic".equals(serviceType)) {
            artifact = "io.intino.alexandria:led";
        }
        ArrayList<String> versions = new ArrayList<String>(new ArtifactoryConnector(this.conf.releaseDistributionRepository()).versions(artifact));
        if (versions.isEmpty()) {
            return "";
        }
        Collections.sort(versions, Version.comparator());
        return (String)versions.get(versions.size() - 1);
    }

    private void write(FrameBuilder builder, File pomFile) {
        try {
            Files.writeString(pomFile.toPath(), (CharSequence)new AccessorPomTemplate().render(builder.toFrame()), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage());
        }
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r, boolean isDistribution, boolean snapshot) {
        builder.add("repository", (Object)this.createRepositoryFrame(r, isDistribution, snapshot));
    }

    private Frame createRepositoryFrame(Configuration.Repository repository, boolean isDistribution, boolean snapshot) {
        FrameBuilder builder = new FrameBuilder(new String[]{"repository"}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url());
        if (isDistribution) {
            builder.add("distribution");
        }
        if (snapshot) {
            builder.add("snapshot");
        }
        return builder.toFrame();
    }
}

