/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import io.intino.builder.CompilerConfiguration;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.BoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.KonosGraph;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class BoxRenderer
extends Renderer {
    private final KonosGraph graph;
    private final boolean hasModel;

    BoxRenderer(CompilationContext context, KonosGraph graph, boolean hasModel) {
        super(context);
        this.graph = graph;
        this.hasModel = hasModel;
    }

    @Override
    public void render() {
        if (this.configuration() == null) {
            return;
        }
        String name = this.context.boxName();
        if (Commons.javaFile(this.src(Target.Service), StringHelper.snakeCaseToCamelCase((String)name) + "Box").exists()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"Box"}).add("package", (Object)this.packageName()).add("name", (Object)name);
        if (this.hasModel) {
            builder.add("tara", (Object)this.fillTara());
        }
        if (!this.graph.uiServiceList().isEmpty()) {
            builder.add("hasUi", (Object)new FrameBuilder().add("package", (Object)this.packageName()));
        }
        this.context.compiledFiles().add(new OutputItem(this.src(Target.Service).getAbsolutePath(), Commons.javaFile(this.src(Target.Service), StringHelper.snakeCaseToCamelCase((String)name) + "Box").getAbsolutePath()));
        Commons.writeFrame(this.src(Target.Service), StringHelper.snakeCaseToCamelCase((String)name) + "Box", new BoxTemplate().render(builder.toFrame(), Formatters.all));
    }

    private Frame fillTara() {
        FrameBuilder builder = new FrameBuilder();
        CompilerConfiguration configuration = this.configuration();
        builder.add("name", (Object)this.context.boxName());
        if (configuration.dsl() != null && configuration.dsl().outDsl() != null) {
            builder.add("outDSL", (Object)configuration.dsl().outDsl());
        }
        builder.add("wrapper", (Object)this.dsls());
        return builder.toFrame();
    }

    private String[] dsls() {
        CompilerConfiguration configuration = this.configuration();
        ArrayList<CallSite> dsls = new ArrayList<CallSite>();
        if (configuration.dsl() == null) {
            return new String[0];
        }
        String dsl = configuration.dsl().name();
        if (configuration.dsl().generationPackage() != null) {
            String genPackage = configuration.dsl().generationPackage();
            dsls.add((CallSite)((Object)((String)(genPackage == null ? "" : genPackage.toLowerCase() + ".") + Formatters.firstUpperCase(dsl))));
        }
        if (!configuration.dsl().level().isModel()) {
            dsls.add((CallSite)((Object)(configuration.generationPackage().toLowerCase() + "." + Formatters.firstUpperCase(configuration.dsl().outDsl()))));
        }
        return dsls.toArray(new String[0]);
    }
}

