/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import io.intino.itrules.Engine;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.UiRendererWriter;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDesktopSkeletonTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDisplaySkeletonTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.ComponentTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.DisplayBoxTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.DisplayTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewNotifierTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewPushRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewRequesterTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.dsl.PassiveView;
import io.intino.konos.dsl.Template;
import io.intino.magritte.framework.Layer;
import java.io.File;

public class ServerRendererWriter
extends UiRendererWriter {
    public ServerRendererWriter(CompilationContext context) {
        super(context, Target.Service);
    }

    @Override
    public boolean write(Layer element, String type, FrameBuilder builder) {
        if (this.hasAbstractClass(element)) {
            this.writeSrc(element, type, builder);
        }
        this.writeGen(element, type, builder);
        return true;
    }

    @Override
    public boolean writeNotifier(PassiveView element, FrameBuilder builder) {
        File notifierFile = Commons.javaFile(CodeGenerationHelper.displayNotifiersFolder(this.gen(), this.target), this.nameOfPassiveViewFile(element, builder.toFrame(), "Notifier"));
        if (!this.context.cache().isModified(element) && notifierFile.exists()) {
            return true;
        }
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Notifier");
        if (!this.hasConcreteNotifier(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayNotifiersFolder(this.gen(), this.target), element, name, new PassiveViewNotifierTemplate().render(frame, Formatters.all));
        this.registerClass(builder, CodeGenerationHelper.displayNotifiersFolder(this.gen(), this.target), element, "Notifier");
        return true;
    }

    @Override
    public boolean writeRequester(PassiveView element, FrameBuilder builder) {
        File requesterFile = Commons.javaFile(CodeGenerationHelper.displayRequestersFolder(this.gen(), this.target), this.nameOfPassiveViewFile(element, builder.toFrame(), "Requester"));
        if (!this.context.cache().isModified(element) && requesterFile.exists()) {
            return true;
        }
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Requester");
        if (!this.hasConcreteRequester(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayRequestersFolder(this.gen(), this.target), element, name, new PassiveViewRequesterTemplate().render(frame, Formatters.all));
        this.registerClass(builder, CodeGenerationHelper.displayRequestersFolder(this.gen(), this.target), element, "Requester");
        return true;
    }

    @Override
    public boolean writePushRequester(PassiveView element, FrameBuilder builder) {
        File pushRequesterFile = Commons.javaFile(CodeGenerationHelper.displayRequestersFolder(this.gen(), this.target), this.nameOfPassiveViewFile(element, builder.toFrame(), "PushRequester"));
        if (!this.context.cache().isModified(element) && pushRequesterFile.exists()) {
            return true;
        }
        Frame frame = builder.toFrame();
        PassiveViewPushRequesterTemplate template = new PassiveViewPushRequesterTemplate();
        if (this.isAccessible(frame)) {
            return false;
        }
        String name = this.nameOfPassiveViewFile(element, frame, "PushRequester");
        if (!this.hasConcreteRequester(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayRequestersFolder(this.gen(), this.target), element, name, template.render(frame, Formatters.all));
        this.registerClass(builder, CodeGenerationHelper.displayRequestersFolder(this.gen(), this.target), element, "PushRequester");
        return true;
    }

    private void writeSrc(Layer element, String type, FrameBuilder builder) {
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), builder.is("accessible") ? "Proxy" : "");
        DisplayTemplate template = this.srcTemplate(element, builder);
        if (template == null) {
            return;
        }
        File sourceFile = CodeGenerationHelper.displayFile(this.src(), newDisplay, type, this.target);
        if (sourceFile.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.src(), type, this.target), element, newDisplay, template.render(builder.toFrame(), Formatters.all));
    }

    private void writeGen(Layer element, String type, FrameBuilder builder) {
        Template template = this.genTemplate(element);
        String newDisplay = this.displayName(element, this.isAccessible(builder));
        this.writeFrame(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), element, newDisplay, new Engine(template).addAll(Formatters.all).render((Object)builder.add("gen").toFrame()));
    }

    private DisplayTemplate srcTemplate(Layer layer, FrameBuilder builder) {
        if (builder.is("accessible")) {
            return null;
        }
        if (!ElementHelper.isRoot(layer)) {
            return null;
        }
        return new DisplayTemplate();
    }

    private Template genTemplate(Layer layer) {
        if (layer.i$(Template.Desktop.class)) {
            return Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new DisplayBoxTemplate(), new AbstractDesktopSkeletonTemplate()});
        }
        return Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new DisplayBoxTemplate(), new AbstractDisplaySkeletonTemplate()});
    }

    private void registerClass(FrameBuilder builder, File folder, PassiveView element, String suffix) {
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(element), Commons.javaFile(folder, this.nameOfPassiveViewFile(element, builder.toFrame(), suffix)).getAbsolutePath()));
    }
}

