/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.mounter;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Datamart;
import io.intino.konos.dsl.KonosGraph;
import java.io.File;

public class MounterRenderer {
    private final CompilationContext context;
    private final KonosGraph graph;
    private final File genMounters;

    public MounterRenderer(CompilationContext context, KonosGraph graph) {
        this.context = context;
        this.graph = graph;
        this.genMounters = new File(context.gen(Target.Service), "mounters");
    }

    public void execute() {
        CompilationContext.DataHubManifest manifest = this.context.dataHubManifest();
        for (Datamart datamart : this.graph.datamartList()) {
            for (Datamart.Mounter mounter : datamart.mounterList()) {
                String mounterName = mounter.name$();
                FrameBuilder builder = this.baseFrame(mounter);
                if (!mounter.isEvent() || manifest == null || this.alreadyRendered(this.context.src(Target.Service), mounterName)) continue;
                this.eventMounter(mounter, mounterName, manifest, builder);
            }
        }
    }

    private FrameBuilder baseFrame(Datamart.Mounter mounter) {
        return new FrameBuilder(new String[]{"mounter"}).add("box", (Object)this.context.boxName()).add("package", (Object)this.context.packageName()).add("name", (Object)mounter.name$());
    }

    private void eventMounter(Datamart.Mounter mounter, String mounterName, CompilationContext.DataHubManifest manifest, FrameBuilder builder) {
        String datamart = ((Datamart)mounter.core$().ownerAs(Datamart.class)).name$();
        builder.add("event").add("datamart", (Object)datamart).add("type", (Object)this.types(mounter, manifest));
        this.context.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + datamart + "." + mounterName);
        File datamartFolder = new File(this.context.src(Target.Service), datamart);
        File mounters = new File(datamartFolder, "mounters");
        if (!this.alreadyRendered(mounters, mounterName)) {
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(mounter), Commons.javaFile(mounters, Formatters.firstUpperCase(mounterName)).getAbsolutePath()));
            Commons.writeFrame(mounters, mounterName, new MounterTemplate().render(builder.toFrame(), Formatters.all));
        }
    }

    private Frame[] types(Datamart.Mounter mounter, CompilationContext.DataHubManifest manifest) {
        return (Frame[])mounter.asEvent().requireList().stream().filter(r -> manifest.tankClasses.containsKey(r.tank())).map(r -> MounterRenderer.frameOf(manifest, r)).toArray(Frame[]::new);
    }

    private static Frame frameOf(CompilationContext.DataHubManifest manifest, Datamart.Mounter.Event.Require r) {
        return new FrameBuilder().add("fullType", (Object)manifest.tankClasses.get(r.tank())).add("name", (Object)MounterRenderer.name(r.tank())).toFrame();
    }

    private static String name(String tank) {
        return tank.contains(".") ? tank.substring(tank.lastIndexOf(".") + 1) : tank;
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

