/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import cottons.utils.StringHelper;
import io.intino.builder.PostCompileActionMessage;
import io.intino.builder.PostCompileFieldActionMessage;
import io.intino.builder.PostCompileMethodActionMessage;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Data;
import io.intino.konos.dsl.Exception;
import io.intino.konos.dsl.Parameter;
import io.intino.konos.dsl.Response;
import io.intino.konos.dsl.Service;
import io.intino.magritte.framework.Node;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActionUpdater {
    private final CompilationContext context;
    private final File destination;
    private final String packageName;
    private final Map<String, ? extends Parameter> parameters;
    private final List<Exception> exceptions;
    private final Response response;

    public ActionUpdater(CompilationContext context, File destination, String packageName, Map<String, ? extends Parameter> parameters, List<Exception> exceptions, Response response) {
        this.context = context;
        this.destination = destination;
        this.packageName = packageName;
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.response = response;
    }

    public void update() {
        String box = this.context.packageName() + "." + StringHelper.snakeCaseToCamelCase((String)this.context.boxName()) + "Box";
        this.parameters.forEach((key, value) -> this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileFieldActionMessage(this.context.module(), this.destination, "public", false, this.formatType(value.asType(), value.isList()), this.nameOf((String)key))));
        this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileFieldActionMessage(this.context.module(), this.destination, "public", false, box, "box"));
        this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileMethodActionMessage(this.context.module(), this.destination, "execute", false, Collections.emptyList(), this.response == null ? "void" : this.returnType(), this.exceptions()));
    }

    private String returnType() {
        String type = Commons.fullReturnType(this.response, this.packageName);
        return !type.contains(".") && !type.equals("void") ? "java.lang." + type : type;
    }

    private List<String> exceptions() {
        return this.exceptions.stream().map(e -> e.core$().owner().owner() == null ? this.exceptionReference((Exception)((Object)e)) : e.code().name()).collect(Collectors.toList());
    }

    private String exceptionReference(Exception exception) {
        return this.packageName + ".exceptions." + Commons.firstUpperCase(exception.name$());
    }

    private String nameOf(String parameter) {
        return Formatters.firstLowerCase(StringHelper.snakeCaseToCamelCase((String)parameter));
    }

    private String formatType(Data.Type typeData, boolean list) {
        if (typeData == null || typeData.type() == null) {
            return "void";
        }
        Object type = typeData.i$(Data.Object.class) ? this.packageName + ".schemas." + typeData.type() : (typeData.i$(Data.Word.class) ? this.owner(typeData) + "." + Formatters.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)typeData.name$())) : typeData.type());
        return list ? "List<" + (String)type + ">" : type;
    }

    private String owner(Data.Type typeData) {
        Node node;
        for (node = typeData.core$(); !(node == null || node.is(Service.REST.Resource.Operation.class) || node.is(Service.REST.Notification.class) || node.is(Service.JMX.Operation.class)); node = node.owner()) {
        }
        if (node == null) {
            return typeData.type();
        }
        if (node.is(Service.REST.Resource.Operation.class)) {
            Service.REST.Resource.Operation operation = (Service.REST.Resource.Operation)node.as(Service.REST.Resource.Operation.class);
            return this.packageName + "." + "rest/resources".replace("/", ".") + "." + Formatters.firstUpperCase(ActionUpdater.name(node, operation)) + "Resource";
        }
        return node.name();
    }

    private static String name(Node node, Service.REST.Resource.Operation operation) {
        return StringHelper.snakeCaseToCamelCase((String)(((Object)((Object)operation)).getClass().getSimpleName() + "_" + ((Service.REST.Resource)node.ownerAs(Service.REST.Resource.class)).name$()));
    }
}

