/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.web;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.web.templates.ThemeTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Format;
import io.intino.konos.dsl.Service;
import io.intino.konos.dsl.Theme;
import java.io.File;

public class ThemeRenderer
extends UIRenderer {
    private final Service.UI service;

    protected ThemeRenderer(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext);
        this.service = service;
    }

    @Override
    public void render() {
        FrameBuilder builder = new FrameBuilder(new String[]{"theme"});
        Theme theme = this.service.graph().theme();
        if (theme != null) {
            builder.add("palette", (Object)this.palette(theme));
            builder.add("typography", (Object)this.typography(theme));
            if (theme.readonly() != null) {
                builder.add("format", (Object)this.frameOf("readonly", theme.readonly().format().content(), theme.readonly().format().darkContent()));
            }
        }
        this.service.graph().formatList().forEach(r -> builder.add("format", (Object)this.frameOf((Format)((Object)r))));
        Commons.write(new File(String.valueOf(this.gen(Target.Accessor)) + File.separator + "Theme.js").toPath(), new ThemeTemplate().render(builder.toFrame(), Formatters.all));
    }

    private Frame palette(Theme theme) {
        FrameBuilder result = new FrameBuilder(new String[]{"palette"});
        result.add("type", (Object)theme.type().name());
        if (theme.primary() != null) {
            this.addProperty("primary", theme.primary().color(), theme.primary().darkColor(), result);
        }
        if (theme.secondary() != null) {
            this.addProperty("secondary", theme.secondary().color(), theme.secondary().darkColor(), result);
        }
        if (theme.error() != null) {
            this.addProperty("error", theme.error().color(), theme.error().darkColor(), result);
        }
        result.add("contrastThreshold", (Object)theme.contrastThreshold());
        result.add("tonalOffset", (Object)theme.tonalOffset());
        return result.toFrame();
    }

    private void addProperty(String name, String color, String darkColor, FrameBuilder result) {
        result.add(name, (Object)color);
        result.add("dark" + Formatters.firstUpperCase(name), (Object)(darkColor != null ? darkColor : color));
    }

    private Frame typography(Theme theme) {
        Theme.Typography typography = theme.typography();
        if (typography == null) {
            typography = theme.create().typography();
        }
        FrameBuilder result = new FrameBuilder(new String[]{"typography"});
        result.add("fontFamily", (Object)("\"" + String.join((CharSequence)"\",\"", typography.fontFamily()) + "\""));
        result.add("fontSize", (Object)typography.fontSize());
        return result.toFrame();
    }

    private Frame frameOf(Format format) {
        return this.frameOf(format.name$(), format.content(), format.darkContent());
    }

    private Frame frameOf(String formatName, String content, String darkContent) {
        FrameBuilder result = new FrameBuilder(new String[]{"format"});
        result.add("name", (Object)formatName);
        result.add("content", (Object)this.withProperties(content != null ? content : ""));
        if (darkContent != null) {
            result.add("dark");
            if (content == null || content.isEmpty()) {
                result.add("emptyContent");
            }
            result.add("darkContent", (Object)this.withProperties(darkContent));
        }
        return result.toFrame();
    }

    private String withProperties(String content) {
        return content.replaceAll("'\\$([^']*)'", "property('$1')");
    }
}

