/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.messaging;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.accessor.messaging.MessagingAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Parameter;
import io.intino.konos.dsl.Response;
import io.intino.konos.dsl.Service;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessagingAccessorRenderer
extends Renderer {
    private final Service.Messaging service;
    private final File destination;

    public MessagingAccessorRenderer(CompilationContext compilationContext, Service.Messaging application, File destination) {
        super(compilationContext);
        this.service = application;
        this.destination = destination;
    }

    @Override
    public void render() throws KonosException {
        new SchemaListRenderer(this.context, this.service.graph(), this.destination).execute();
        this.processService();
    }

    private void processService() {
        FrameBuilder builder = new FrameBuilder(new String[]{"accessor"});
        String name = this.configuration().project() + "-" + this.service.name$();
        builder.add("name", (Object)name);
        builder.add("package", (Object)this.packageName());
        if (!this.service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        List requests = this.service.core$().findNode(Service.Messaging.Request.class);
        Set<String> customParameters = this.extractCustomParameters(requests);
        builder.add("request", requests.stream().map(request -> this.processRequest((Service.Messaging.Request)((Object)request), this.service).toFrame()).toArray(Frame[]::new));
        for (String parameter : customParameters) {
            builder.add("custom", (Object)parameter);
        }
        Commons.writeFrame(new File(this.destination, this.packageName().replace(".", File.separator)), StringHelper.snakeCaseToCamelCase((String)name) + "Accessor", new MessagingAccessorTemplate().render(builder.toFrame(), Formatters.all));
    }

    private Set<String> extractCustomParameters(List<Service.Messaging.Request> requests) {
        HashSet<String> set = new HashSet<String>();
        for (Service.Messaging.Request request : requests) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private FrameBuilder processRequest(Service.Messaging.Request request, Service.Messaging service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("service", (Object)service.name$()).add("path", (Object)("service" + this.chainContext(service.context()) + request.path()));
        if (request.parameter() != null) {
            builder.add("parameter", (Object)this.parameterFrame(request.parameter()));
        }
        if (request.response() != null && request.response().isType()) {
            builder.add("reply").add("response", (Object)this.responseFrame(request.response()));
        }
        return builder;
    }

    private String chainContext(String context) {
        return context != null && !context.isEmpty() ? "." + context + "." : "";
    }

    private Frame parameterFrame(Parameter parameter) {
        return new FrameBuilder(new String[]{"value"}).add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private Frame responseFrame(Response response) {
        return new FrameBuilder(new String[]{"value"}).add("name", (Object)response.name$()).add("type", (Object)response.asType().type()).toFrame();
    }
}

