package io.intino.konos.builder.codegeneration.services.ui.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class ComponentTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(all(allTypes("reference"), trigger("declaration"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(allTypes("reference", "item")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").<")).output(placeholder("name", "firstUpperCase")).output(literal(">item(")).output(placeholder("owner")).output(literal(".this.item()).owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(allTypes("reference")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(all(allTypes("component", "child", "collection", "embedded"), trigger("declarations"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection"), trigger("declarations"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("component", "declarations").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "displaystamp", "single"), trigger("declarations"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("component", "declarations").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "ownertemplatestamp", "single"), trigger("declarations"))).output(literal("public ")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("template", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component", "child", "proxystamp", "single"), trigger("declarations"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component", "child", "basestamp", "single"), trigger("declarations"))).output(literal("public ")).output(placeholder("template", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("declarations"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("component", "declarations").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "displaystamp"), trigger("declaration"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component", "child", "ownertemplatestamp", "single"), trigger("declaration"))).output(literal("public ")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("template", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component", "child", "proxystamp", "single"), trigger("declaration"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component", "child", "basestamp", "single"), trigger("declaration"))).output(literal("public ")).output(placeholder("template", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("declaration"))).output(literal("public ")).output(expression().output(placeholder("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("component"), trigger("unregister"))).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".unregister();")));
		rules.add(rule().condition(allTypes("method", "multiple", "collapsable")).output(expression().output(placeholder("editableMethods"))).output(literal("\n")).output(expression().output(placeholder("editableClass"))).output(literal("\n@Override\npublic ")).output(placeholder("componentName")).output(literal(" add(")).output(expression().output(placeholder("objectType")).output(literal(" value, "))).output(literal("String label, String description) {\n\t")).output(placeholder("componentName")).output(literal(" child = new ")).output(placeholder("componentName")).output(literal("(box()")).output(expression().output(literal(".")).output(placeholder("componentOwnerBox", "lowerCase")).output(literal("()"))).output(literal(");\n\tchild.id(java.util.UUID.randomUUID().toString());\n\tchild.properties().put(\"label\", label);\n\tchild.properties().put(\"description\", description);\n\tadd(child, \"")).output(placeholder("name")).output(literal("\");\n\t")).output(expression().output(literal("child.value(")).output(placeholder("objectTypeValue")).output(literal(");"))).output(literal("\n\tnotifyAdd(child")).output(expression().output(literal(", ")).output(placeholder("objectTypeValue"))).output(literal(");\n\treturn child;\n}\n@Override\npublic void remove(")).output(placeholder("componentName")).output(literal(" child) {\n\tremoveChild(child, \"")).output(placeholder("name")).output(literal("\");\n}\npublic void clear() {\n\tsuper.clear(\"")).output(placeholder("name")).output(literal("\");\n}\n@Override\nprotected ")).output(placeholder("componentName")).output(literal(" add(")).output(expression().output(placeholder("objectType")).output(literal(" value"))).output(literal(") {\n\treturn add(value, null, null);\n}")));
		rules.add(rule().condition(allTypes("method", "multiple")).output(expression().output(placeholder("editableMethods"))).output(literal("\n")).output(expression().output(placeholder("editableClass"))).output(literal("\n@Override\npublic ")).output(placeholder("componentName")).output(literal(" add(")).output(expression().output(placeholder("objectType")).output(literal(" value"))).output(literal(") {\n\t")).output(placeholder("componentName")).output(literal(" child = new ")).output(placeholder("componentName")).output(literal("(box()")).output(expression().output(literal(".")).output(placeholder("componentOwnerBox", "lowerCase")).output(literal("()"))).output(literal(");\n\tchild.id(java.util.UUID.randomUUID().toString());\n\tadd(child, \"")).output(placeholder("name")).output(literal("\");\n\t")).output(expression().output(literal("child.value(")).output(placeholder("objectTypeValue")).output(literal(");"))).output(literal("\n\tnotifyAdd(child")).output(expression().output(literal(", ")).output(placeholder("objectTypeValue"))).output(literal(");\n\treturn child;\n}\n@Override\npublic void remove(")).output(placeholder("componentName")).output(literal(" child) {\n\tremoveChild(child, \"")).output(placeholder("name")).output(literal("\");\n}\npublic void clear() {\n\tsuper.clear(\"")).output(placeholder("name")).output(literal("\");\n}")));
		rules.add(rule().condition(allTypes("method", "highlighted")).output(literal("public ")).output(placeholder("name", "firstUpperCase")).output(literal(" textColor(String color) {\n\tthis._textColor(color);\n\tthis._refreshHighlight();\n\treturn this;\n}\n\npublic ")).output(placeholder("name", "firstUpperCase")).output(literal(" backgroundColor(String color) {\n\tthis._backgroundColor(color);\n\tthis._refreshHighlight();\n\treturn this;\n}")));
		rules.add(rule().condition(allTypes("method", "signed")).output(literal("public String signSecret() {\n    return this._signSecret();\n}\npublic ")).output(placeholder("name", "firstUpperCase")).output(literal(" signInfoProvider(io.intino.alexandria.ui.displays.components.actionable.SignInfoProvider provider) {\n\tthis._signInfoProvider(provider);\n\treturn this;\n}\npublic ")).output(placeholder("name", "firstUpperCase")).output(literal(" signChecker(io.intino.alexandria.ui.displays.components.actionable.SignChecker checker) {\n\tthis._signChecker(checker);\n\treturn this;\n}")));
		rules.add(rule().condition(allTypes("method", "addressable")).output(literal("@Override\npublic ")).output(placeholder("name", "firstUpperCase")).output(literal(" address(java.util.function.Function<String, String> addressFromPathResolver) {\n\taddress(addressFromPathResolver.apply(path()));\n\treturn this;\n}")));
		rules.add(rule().condition(allTypes("method", "collectionbox")).output(literal("@Override\npublic ")).output(placeholder("name", "firstUpperCase")).output(literal(" set(java.util.function.Function<String, String> addressFromPathResolver) {\n\taddress(addressFromPathResolver.apply(path()));\n\treturn this;\n}")));
		rules.add(rule().condition(allTypes("method", "collection", "table")).output(expression().output(placeholder("selectionMethod"))).output(literal("\n\npublic ")).output(placeholder("name", "firstUpperCase")).output(literal("Row create(")).output(expression().output(placeholder("itemClass")).output(literal(" item"))).output(literal(") {\n\t")).output(placeholder("name", "firstUpperCase")).output(literal("Row row = new ")).output(placeholder("name", "firstUpperCase")).output(literal("Row(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box());\n\trow.id(java.util.UUID.randomUUID().toString());\n\t")).output(expression().output(literal("row.item(")).output(placeholder("itemVariable")).output(literal(");"))).output(literal("\n\treturn row;\n}")));
		rules.add(rule().condition(allTypes("method", "collection", "dynamictable")).output(expression().output(placeholder("selectionMethod"))).output(literal("\n\npublic ")).output(placeholder("name", "firstUpperCase")).output(literal("Row create(")).output(expression().output(placeholder("itemClass")).output(literal(" item"))).output(literal(") {\n\t")).output(placeholder("name", "firstUpperCase")).output(literal("Row row = new ")).output(placeholder("name", "firstUpperCase")).output(literal("Row(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box());\n\trow.id(java.util.UUID.randomUUID().toString());\n\t")).output(expression().output(literal("row.item(")).output(placeholder("itemVariable")).output(literal(");"))).output(literal("\n\treturn row;\n}")));
		rules.add(rule().condition(allTypes("method", "collection")).output(placeholder("selectionMethod")).output(literal("\n")).output(expression().output(placeholder("item", "addMethod").multiple("\n\n"))).output(literal("\n\n")).output(expression().output(placeholder("item", "removeMethod").multiple("\n\n"))));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("method"))));
		rules.add(rule().condition(all(allTypes("component", "child", "displaystamp"), trigger("class"))).output(literal("public class ")).output(placeholder("name", "firstUpperCase")).output(literal(" extends ")).output(placeholder("extends")).output(literal(" ")).output(placeholder("implements")).output(literal(" {\n\t")).output(expression().output(placeholder("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(placeholder("properties", "common"))).output(literal("\n\t\t")).output(expression().output(placeholder("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(placeholder("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(placeholder("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(placeholder("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(placeholder("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(placeholder("methods")).output(literal("\n\t")).output(expression().output(placeholder("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "method").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("component", "child", "proxystamp"), trigger("class"))).output(literal("public class ")).output(placeholder("name", "firstUpperCase")).output(literal(" extends ")).output(placeholder("extends")).output(literal(" ")).output(placeholder("implements")).output(literal(" {\n\t")).output(expression().output(placeholder("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(placeholder("properties", "common"))).output(literal("\n\t\t")).output(expression().output(placeholder("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(placeholder("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(placeholder("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(placeholder("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(placeholder("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(placeholder("methods")).output(literal("\n\t")).output(expression().output(placeholder("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "method").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("component", "child", "basestamp", "single"), trigger("class"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection", "embedded"), trigger("class"))).output(literal("public class ")).output(placeholder("name", "firstUpperCase")).output(literal(" extends ")).output(placeholder("package")).output(literal(".ui.displays")).output(expression().output(literal(".")).output(placeholder("packageType")).output(literal("s"))).output(literal(".")).output(placeholder("name", "firstUpperCase")).output(literal(" {\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tthis((")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)box);\n\t}\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(placeholder("properties", "common"))).output(literal("\n\t\t")).output(expression().output(placeholder("properties", "specific"))).output(literal("\n\t}\n}")));
		rules.add(rule().condition(all(allTypes("component", "child", "collection"), trigger("class"))).output(literal("public class ")).output(placeholder("name", "firstUpperCase")).output(literal(" extends ")).output(placeholder("extends")).output(literal(" ")).output(placeholder("implements")).output(literal(" {\n\t")).output(expression().output(placeholder("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(placeholder("properties", "common"))).output(literal("\n\t\t")).output(expression().output(placeholder("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(placeholder("methodName")).output(literal("() {\n\t\tsuper.")).output(placeholder("methodName")).output(literal("();\n\t\t")).output(expression().output(placeholder("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(placeholder("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(placeholder("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(placeholder("methods")).output(literal("\n\t")).output(expression().output(placeholder("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "method").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(attribute("notifyready")).output(literal("notifyReady();")));
		rules.add(rule().condition(all(allTypes("component", "child", "block", "conditional"), trigger("class"))).output(literal("public class ")).output(placeholder("name", "firstUpperCase")).output(literal(" extends ")).output(placeholder("extends")).output(literal(" ")).output(placeholder("implements")).output(literal(" {\n\t")).output(expression().output(placeholder("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(placeholder("properties", "common"))).output(literal("\n\t\t")).output(expression().output(placeholder("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(placeholder("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(placeholder("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(placeholder("component", "child").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(placeholder("component", "conditionalReferences").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(placeholder("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(placeholder("methods")).output(literal("\n\t")).output(expression().output(placeholder("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "method").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("class"))).output(literal("public class ")).output(placeholder("name", "firstUpperCase")).output(literal(" extends ")).output(placeholder("extends")).output(literal(" ")).output(placeholder("implements")).output(literal(" {\n\t")).output(expression().output(placeholder("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(placeholder("properties", "common"))).output(literal("\n\t\t")).output(expression().output(placeholder("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(placeholder("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(placeholder("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(placeholder("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(placeholder("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(placeholder("methods")).output(literal("\n\t")).output(expression().output(placeholder("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "method").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(allTypes("extends", "multiple", "image")).output(literal("io.intino.alexandria.ui.displays.components.MultipleImage<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(expression().output(placeholder("componentPrefix", "firstUpperCase")).output(literal("."))).output(placeholder("componentName")).output(literal(", ")).output(placeholder("objectType")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "multiple")).output(literal("io.intino.alexandria.ui.displays.components.Multiple<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(expression().output(placeholder("componentPrefix", "firstUpperCase")).output(literal("."))).output(placeholder("componentName")).output(literal(", ")).output(placeholder("objectType")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "collection", "grid")).output(literal("io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<io.intino.alexandria.ui.displays.notifiers.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("Notifier, ")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "collection", "table")).output(literal("io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<")).output(placeholder("abstractBox", "type")).output(literal(", io.intino.alexandria.ui.displays.components.Row, ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "collection", "dynamictable")).output(literal("io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<")).output(placeholder("abstractBox", "type")).output(literal(", io.intino.alexandria.ui.displays.components.Row, ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "collection")).output(literal("io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(placeholder("componentType")).output(literal(", ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "item")).output(literal("io.intino.alexandria.ui.displays.components.Item<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "displaystamp")).output(literal("io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<io.intino.alexandria.ui.displays.notifiers.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("Notifier, ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "proxystamp")).output(literal("io.intino.alexandria.ui.displays.components.ProxyStamp<io.intino.alexandria.ui.displays.notifiers.ProxyStampNotifier, ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("extends", "basestamp")).output(placeholder("type", "firstUpperCase")));
		rules.add(rule().condition(allTypes("extends")).output(literal("io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<io.intino.alexandria.ui.displays.notifiers.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("Notifier, ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(all(allTypes("component", "child", "multipleblock"), trigger("rootchildreferences"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection", "embedded"), trigger("rootchildreferences"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection"), trigger("rootchildreferences"))).output(expression().output(literal("if (")).output(placeholder("parent")).output(literal(" != null)"))).output(literal(" ")).output(placeholder("name")).output(literal(" = ")).output(expression().output(placeholder("ancestorsNotMe").multiple(".")).output(literal("."))).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("component", "rootChildReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("rootchildreferences"))).output(expression().output(literal("if (")).output(placeholder("parent")).output(literal(" != null)"))).output(literal(" ")).output(placeholder("name")).output(literal(" = ")).output(expression().output(placeholder("ancestorsNotMe").multiple(".")).output(literal("."))).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("component", "rootChildReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection", "embedded"), trigger("childreferences"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection"), trigger("childreferences"))).output(expression().output(literal("if (")).output(placeholder("parent")).output(literal(" != null)"))).output(literal(" ")).output(placeholder("name")).output(literal(" = ")).output(expression().output(placeholder("ancestors").multiple(".")).output(literal("."))).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("component", "childReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("childreferences"))).output(expression().output(literal("if (")).output(placeholder("parent")).output(literal(" != null)"))).output(literal(" ")).output(placeholder("name")).output(literal(" = ")).output(expression().output(placeholder("ancestors").multiple(".")).output(literal("."))).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("component", "childReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection", "embedded"), trigger("rootreferences"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));\n")).output(expression().output(placeholder("component", "rootChildReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "displaystamp"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));\n")).output(expression().output(placeholder("component", "rootChildReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "ownertemplatestamp", "multiple"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("ownerBox")).output(literal("Box)"))).output(literal("box().owner()).<")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(all(allTypes("component", "child", "proxystamp", "multiple"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(all(allTypes("component", "child", "basestamp", "multiple"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(all(allTypes("component", "child", "ownertemplatestamp", "single"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("template", "firstUpperCase")).output(placeholder("generic")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("ownerBox")).output(literal("Box)"))).output(literal("box().owner()).<")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("template", "firstUpperCase")).output(placeholder("generic")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(all(allTypes("component", "child", "proxystamp", "single"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(all(allTypes("component", "child", "basestamp", "single"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("template", "firstUpperCase")).output(placeholder("generic")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).id(\"")).output(placeholder("id")).output(literal("\"));")));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("rootreferences"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));\n")).output(expression().output(placeholder("component", "rootChildReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection", "embedded"), trigger("references"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection"), trigger("references"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));\n")).output(expression().output(placeholder("component", "childReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("references"))).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));\n")).output(expression().output(placeholder("component", "childReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child", "block", "conditional"), trigger("conditionalreferences"))));
		rules.add(rule().condition(all(allTypes("component", "child", "block"), trigger("conditionalreferences"))).output(expression().output(placeholder("component", "conditionalReferences").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("conditionalreferences"))).output(literal("if (")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" = ")).output(expression().output(placeholder("ancestorsNotMe").multiple(".")).output(literal("."))).output(placeholder("name")).output(literal(";\n")).output(expression().output(placeholder("binding").multiple("\n"))).output(literal("\n")).output(expression().output(placeholder("attachedTo"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection", "embedded"), trigger("initializations"))));
		rules.add(rule().condition(all(allTypes("component", "child", "collection"), trigger("initializations"))).output(expression().output(placeholder("binding").multiple("\n"))).output(literal("\n")).output(expression().output(placeholder("attachedTo"))).output(literal("\n")).output(expression().output(placeholder("component", "initializations").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("component", "child"), trigger("initializations"))).output(expression().output(placeholder("binding").multiple("\n"))).output(literal("\n")).output(expression().output(placeholder("attachedTo"))).output(literal("\n")).output(expression().output(placeholder("component", "initializations").multiple("\n"))));
		rules.add(rule().condition(allTypes("component", "child", "displaystamp")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = ")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(allTypes("component", "child", "ownertemplatestamp", "multiple")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = ")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(allTypes("component", "child", "basestamp", "multiple")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = ")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(allTypes("component", "child", "ownertemplatestamp", "single")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = ")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("template", "firstUpperCase")).output(placeholder("generic")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("ownerBox")).output(literal("Box)"))).output(literal("box().owner()).<")).output(placeholder("ownerPackage")).output(literal(".")).output(placeholder("template", "firstUpperCase")).output(placeholder("generic")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(allTypes("component", "child", "proxystamp", "single")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = ")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(allTypes("component", "child", "basestamp", "single")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = ")).output(placeholder("owner")).output(literal(".this.")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("template", "firstUpperCase")).output(placeholder("generic")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).id(\"")).output(placeholder("id")).output(literal("\"));")));
		rules.add(rule().condition(allTypes("component", "child")).output(literal("if (")).output(placeholder("name")).output(literal(" == null) ")).output(placeholder("name")).output(literal(" = register(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box()).<")).output(placeholder("name", "firstUpperCase")).output(literal(">id(\"")).output(placeholder("id")).output(literal("\").owner(")).output(placeholder("owner")).output(literal(".this));")));
		rules.add(rule().condition(allTypes("facet")).output(placeholder("name", "firstUpperCase")));
		rules.add(rule().condition(allTypes("binding", "toolbar")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(expression().output(placeholder("ancestorsNotMe").multiple(".")).output(literal("."))).output(placeholder("collection")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "grouping")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection").multiple(",")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "datenavigator")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("component").multiple(",")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "groupingToolbar")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("grouping").multiple(",")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "sorting")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection").multiple(",")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "searchbox")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection").multiple(",")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "download")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection").multiple(",")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "temporalslider")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection").multiple(",")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "openblock")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("block")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "closeblock")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("block")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "opendialog")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("dialog")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "closedialog")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("dialog")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "opendrawer")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("drawer")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "closedrawer")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("drawer")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "openpopover")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("popover")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "opennextitem")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "openpreviousitem")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "decisiondialog")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("selector")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "collectiondialog")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "collectionbox", "add")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("name")).output(literal(".")).output(placeholder("collection")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding", "collectionbox")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("collection")).output(literal(");")));
		rules.add(rule().condition(allTypes("binding")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".bindTo(")).output(placeholder("selector")).output(literal(", \"")).output(placeholder("option")).output(literal("\");")));
		rules.add(rule().condition(allTypes("attachedTo", "grouping")).output(literal("if (")).output(placeholder("name")).output(literal(" != null) ")).output(placeholder("name")).output(literal(".attachTo(")).output(placeholder("grouping")).output(literal(");")));
		rules.add(rule().condition(allTypes("implements", "selectable")).output(literal("implements io.intino.alexandria.ui.displays.components.collection.Selectable")));
		rules.add(rule().condition(allTypes("implements", "multiple", "collapsable")).output(literal("implements io.intino.alexandria.ui.displays.components.multiple.Collapsable<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(expression().output(placeholder("componentPrefix", "firstUpperCase")).output(literal("."))).output(placeholder("componentName")).output(literal(", ")).output(placeholder("objectType")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements", "multiple")).output(literal("implements io.intino.alexandria.ui.displays.components.multiple.NonCollapsable<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(expression().output(placeholder("componentPrefix", "firstUpperCase")).output(literal("."))).output(placeholder("componentName")).output(literal(", ")).output(placeholder("objectType")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements", "option")).output(literal("implements io.intino.alexandria.ui.displays.components.selector.SelectorOption")));
		rules.add(rule().condition(allTypes("implements", "dynamicloaded")).output(literal("implements io.intino.alexandria.ui.displays.components.DynamicLoaded")));
		rules.add(rule().condition(allTypes("implements", "addressable", "action")).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(placeholder("name", "firstUpperCase")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements", "addressable", "openlayer")).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(placeholder("name", "firstUpperCase")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements", "addressable", "selector")).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(placeholder("name", "firstUpperCase")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements", "addressable", "grouping")).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(placeholder("name", "firstUpperCase")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements", "addressable", "searchbox")).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(placeholder("name", "firstUpperCase")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements", "addressable", "sorting")).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(placeholder("name", "firstUpperCase")).output(literal(">")));
		rules.add(rule().condition(allTypes("implements")).output(literal("implements --undefined--")));
		rules.add(rule().condition(all(allTypes("properties", "actionable"), trigger("common"))).output(expression().output(literal("_title(\"")).output(placeholder("title")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_color(\"")).output(placeholder("color")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf(\"")).output(placeholder("mode", "firstUpperCase")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_signMode(io.intino.alexandria.ui.displays.components.Actionable.SignMode.valueOf(\"")).output(placeholder("signMode", "firstUpperCase")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_signChecker(_")).output(placeholder("signChecker")).output(literal("());"))).output(literal("\n")).output(expression().output(placeholder("actionableMode"))));
		rules.add(rule().condition(all(allTypes("properties", "appDirectory"), trigger("common"))).output(expression().output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "dashboard"), trigger("common"))).output(expression().output(placeholder("parameter").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("properties"), trigger("common"))).output(expression().output(literal("label(\"")).output(placeholder("label")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("name(\"")).output(placeholder("name")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_color(\"")).output(placeholder("color")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "proxyStamp"), trigger("specific"))).output(literal("_proxy(new ")).output(placeholder("proxyPackage")).output(literal(".")).output(placeholder("proxyDisplay", "firstUpperCase")).output(literal("(new io.intino.alexandria.ui.spark.pages.Unit(\"")).output(placeholder("proxyUseName")).output(literal("\", ")).output(placeholder("proxyUseUrl")).output(expression().output(literal(",\"")).output(placeholder("proxyUseSocketPath")).output(literal("\""))).output(literal(")));\n")).output(expression().output(placeholder("parameter").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("properties", "selector"), trigger("specific"))).output(expression().output(literal("_multipleSelection(")).output(placeholder("multipleSelection")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "grouping"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "kpi"), trigger("specific"))).output(expression().output(literal("_value(")).output(placeholder("value")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "chat"), trigger("specific"))).output(expression().output(literal("_emptyMessage(\"")).output(placeholder("emptyMessage")).output(literal("\");"))).output(literal("\n")).output(expression().output(placeholder("loadingImage", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("incomingImage", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("outgoingImage", "resourceMethod"))));
		rules.add(rule().condition(all(allTypes("properties", "sorting"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "searchbox"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "materialicon"), trigger("specific"))).output(expression().output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "icon"), trigger("specific"))).output(expression().output(placeholder("icon", "resourceMethod"))));
		rules.add(rule().condition(all(allTypes("properties", "microsite"), trigger("specific"))).output(expression().output(placeholder("site", "resourceMethod"))));
		rules.add(rule().condition(all(allTypes("properties", "block"), trigger("specific"))).output(expression().output(placeholder("background", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("badge"))).output(literal("\n")).output(expression().output(placeholder("drawer"))).output(literal("\n")).output(expression().output(placeholder("popover"))));
		rules.add(rule().condition(all(allTypes("properties", "image", "avatar"), trigger("specific"))).output(expression().output(literal("_text(\"")).output(placeholder("text")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "image", "multiple", "componentClass"), trigger("specific"))).output(expression().output(placeholder("value", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("defaultValue", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "image", "multiple"), trigger("specific"))).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "image"), trigger("specific"))).output(expression().output(placeholder("value", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("defaultValue", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "file", "multiple", "componentClass"), trigger("specific"))).output(expression().output(placeholder("value", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "file", "multiple"), trigger("specific"))).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "file"), trigger("specific"))).output(expression().output(placeholder("value", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "openpage"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "openlayer"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_transition(io.intino.alexandria.ui.displays.components.OpenLayer.Transition.valueOf(\"")).output(placeholder("transition")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_showHeader(")).output(placeholder("showHeader")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "openpopover"), trigger("specific"))).output(expression().output(literal(" _triggerEvent(io.intino.alexandria.ui.displays.components.OpenPopover.TriggerEvent.")).output(placeholder("triggerEvent")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "opensite"), trigger("specific"))).output(expression().output(literal("_site(\"")).output(placeholder("site")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "switch"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_state(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State.valueOf(\"")).output(placeholder("state")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "toggle"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_state(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State.valueOf(\"")).output(placeholder("state")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "copytoclipboard"), trigger("specific"))).output(expression().output(literal("_text(\"")).output(placeholder("text")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "signText"), trigger("specific"))).output(expression().output(literal("_text(\"")).output(placeholder("text")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_signFormat(io.intino.alexandria.ui.displays.components.SignAction.SignFormat.valueOf(\"")).output(placeholder("signFormat")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "signDocument"), trigger("specific"))).output(expression().output(literal("_document(")).output(placeholder("owner")).output(literal(".class.getResource(\"")).output(placeholder("value")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "action"), trigger("specific"))).output(expression().output(literal("_path(\"")).output(placeholder("path")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "export"), trigger("specific"))).output(expression().output(literal("_from(")).output(placeholder("from")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_to(")).output(placeholder("to")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_min(")).output(placeholder("min")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_max(")).output(placeholder("max")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_range(")).output(placeholder("rangeMin")).output(literal(",")).output(placeholder("rangeMax")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(placeholder("option").multiple("\",\"")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "download"), trigger("specific"))).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(placeholder("option").multiple("\",\"")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "download", "selection"), trigger("specific"))).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(placeholder("option").multiple("\",\"")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "chart"), trigger("specific"))).output(expression().output(literal("_query(\"")).output(placeholder("query")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_serverUrl(\"")).output(placeholder("serverUrl")).output(literal("\");"))).output(literal("\n")).output(expression().output(placeholder("input", "inputMethod"))).output(literal("\n")).output(expression().output(literal("_output(\"")).output(placeholder("output")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "appDirectory", "fromFile"), trigger("specific"))).output(expression().output(placeholder("source", "fileMethod"))));
		rules.add(rule().condition(all(allTypes("properties", "appDirectory", "fromResource"), trigger("specific"))).output(expression().output(placeholder("source", "resourceMethod"))));
		rules.add(rule().condition(all(allTypes("properties", "appDirectory", "inline"), trigger("specific"))).output(placeholder("application").multiple("\n")));
		rules.add(rule().condition(all(allTypes("properties", "datenavigator"), trigger("specific"))).output(expression().output(literal("_selected(java.time.Instant.ofEpochMilli(")).output(placeholder("value")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_range(java.time.Instant.ofEpochMilli(")).output(placeholder("from")).output(literal("L), java.time.Instant.ofEpochMilli(")).output(placeholder("to")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_scales(")).output(placeholder("scale").multiple(",")).output(literal(");"))));
		rules.add(rule().condition(allTypes("scale")).output(literal("io.intino.alexandria.Scale.")).output(placeholder("value", "firstUpperCase")));
		rules.add(rule().condition(all(allTypes("properties", "timeline"), trigger("specific"))).output(expression().output(literal("_mode(io.intino.alexandria.ui.displays.components.Timeline.Mode.valueOf(\"")).output(placeholder("mode", "firstUpperCase")).output(literal("\"));"))));
		rules.add(rule().condition(all(allTypes("properties", "eventline"), trigger("specific"))).output(expression().output(literal("_arrangement(io.intino.alexandria.ui.displays.components.Eventline.Arrangement.valueOf(\"")).output(placeholder("arrangement", "firstUpperCase")).output(literal("\"));"))));
		rules.add(rule().condition(allTypes("appDirectoryApplication")).output(literal("_add(\"")).output(placeholder("name")).output(literal("\", \"")).output(placeholder("url")).output(literal("\")")).output(expression().output(placeholder("translation").multiple(""))).output(literal(";")));
		rules.add(rule().condition(allTypes("appDirectoryApplicationTranslation")).output(literal(".translation(\"")).output(placeholder("language")).output(literal("\", \"")).output(placeholder("name")).output(literal("\")")));
		rules.add(rule().condition(all(allTypes("properties", "dashboard", "shiny"), trigger("specific"))).output(expression().output(placeholder("serverScript", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("uiScript", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("resource", "resourceMethod").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("properties", "documenteditor", "collabora"), trigger("specific"))).output(expression().output(literal("_document(\"")).output(placeholder("document")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_editorUrl(\"")).output(placeholder("editorUrl")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "dashboard", "metabase"), trigger("specific"))).output(expression().output(literal("_url(\"")).output(placeholder("url")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_secretKey(\"")).output(placeholder("secretKey")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_bordered(")).output(placeholder("bordered")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_titled(")).output(placeholder("titled")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_theme(io.intino.alexandria.ui.displays.components.DashboardMetabase.Theme.")).output(placeholder("theme")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "number", "multiple", "componentClass"), trigger("specific"))).output(expression().output(literal("_value(")).output(placeholder("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_min(")).output(placeholder("min")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_max(")).output(placeholder("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "number", "multiple"), trigger("specific"))).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "number"), trigger("specific"))).output(expression().output(literal("_value(")).output(placeholder("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_min(")).output(placeholder("min")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_max(")).output(placeholder("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "date", "multiple", "componentClass"), trigger("specific"))).output(expression().output(literal("_value(java.time.Instant.ofEpochMilli(")).output(placeholder("value")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_min(java.time.Instant.ofEpochMilli(")).output(placeholder("min")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_max(java.time.Instant.ofEpochMilli(")).output(placeholder("max")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "date", "multiple"), trigger("specific"))).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "date"), trigger("specific"))).output(expression().output(literal("_value(java.time.Instant.ofEpochMilli(")).output(placeholder("value")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_min(java.time.Instant.ofEpochMilli(")).output(placeholder("min")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_max(java.time.Instant.ofEpochMilli(")).output(placeholder("max")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "text", "multiple", "componentClass"), trigger("specific"))).output(expression().output(literal("_value(\"")).output(placeholder("defaultValue")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "text", "multiple"), trigger("specific"))).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "text"), trigger("specific"))).output(expression().output(literal("_value(\"")).output(placeholder("defaultValue")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_pattern(\"")).output(placeholder("pattern")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties", "location", "multiple", "componentClass"), trigger("specific"))).output(expression().output(placeholder("icon", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_value(\"")).output(placeholder("value")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "location", "multiple"), trigger("specific"))).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "location"), trigger("specific"))).output(expression().output(placeholder("icon", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_value(\"")).output(placeholder("value")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "collection", "map"), trigger("specific"))).output(expression().output(literal("_type(io.intino.alexandria.ui.displays.components.Map.Type.valueOf(\"")).output(placeholder("type")).output(literal("\"));"))).output(literal("\n")).output(expression().output(placeholder("icon", "resourceMethod"))).output(literal("\n")).output(expression().output(placeholder("layer", "resourceMethod"))));
		rules.add(rule().condition(all(allTypes("properties", "collection"), trigger("specific"))).output(expression().output(literal("_source(new io.intino.alexandria.ui.sources.")).output(placeholder("sourceClass", "firstUpperCase")).output(literal("());"))).output(literal("\n")).output(expression().output(placeholder("column").multiple("\n"))).output(literal("\n")).output(expression().output(literal("_pageSize(")).output(placeholder("pageSize")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "slider"), trigger("specific"))).output(expression().output(literal("_value(")).output(placeholder("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_range(")).output(placeholder("min")).output(literal(",")).output(placeholder("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_animation(")).output(placeholder("interval")).output(literal(",")).output(placeholder("loop")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(placeholder("ordinal", "ordinalMethod").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("properties", "rangeslider"), trigger("specific"))).output(expression().output(literal("_value(")).output(placeholder("from")).output(literal(",")).output(placeholder("to")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_range(")).output(placeholder("min")).output(literal(",")).output(placeholder("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_animation(")).output(placeholder("interval")).output(literal(",")).output(placeholder("loop")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(placeholder("ordinal", "ordinalMethod").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("properties", "temporalslider"), trigger("specific"))).output(expression().output(literal("_value(")).output(placeholder("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_range(java.time.Instant.ofEpochMilli(")).output(placeholder("min")).output(literal("L),java.time.Instant.ofEpochMilli(")).output(placeholder("max")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_animation(")).output(placeholder("interval")).output(literal(",")).output(placeholder("loop")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(placeholder("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(placeholder("ordinal", "ordinalMethod").multiple("\n"))));
		rules.add(rule().condition(all(allTypes("properties", "collectiondialog"), trigger("specific"))).output(expression().output(literal("_allowSearch(")).output(placeholder("allowSearch")).output(literal(");"))));
		rules.add(rule().condition(all(allTypes("properties", "frame"), trigger("specific"))).output(expression().output(literal("_url(\"")).output(placeholder("url")).output(literal("\");"))));
		rules.add(rule().condition(all(allTypes("properties"), trigger("specific"))));
		rules.add(rule().condition(all(allTypes("inputMethod", "csv"), trigger("inputmethod"))).output(literal("_input(new io.intino.alexandria.ui.displays.components.chart.datasources.CSVDataSource(")).output(placeholder("owner")).output(literal(".class.getResource(\"")).output(placeholder("value")).output(literal("\")));")));
		rules.add(rule().condition(all(allTypes("inputMethod", "source"), trigger("inputmethod"))).output(literal("_input(new ")).output(placeholder("value")).output(literal("());")));
		rules.add(rule().condition(allTypes("parameterMethod")).output(literal("_add(\"")).output(placeholder("name")).output(literal("\", \"")).output(placeholder("value")).output(literal("\");")));
		rules.add(rule().condition(trigger("filemethod")).output(literal("_")).output(placeholder("name")).output(literal("(new java.io.File(\"")).output(placeholder("value")).output(literal("\")")).output(expression().output(literal(", \"")).output(placeholder("extraParam")).output(literal("\""))).output(literal(");")));
		rules.add(rule().condition(trigger("resourcemethod")).output(literal("_")).output(placeholder("name")).output(literal("(")).output(placeholder("owner")).output(literal(".class.getResource(\"")).output(placeholder("value")).output(literal("\")")).output(expression().output(literal(", \"")).output(placeholder("extraParam")).output(literal("\""))).output(literal(");")));
		rules.add(rule().condition(trigger("ordinalmethod")).output(literal("_add(new io.intino.alexandria.ui.displays.components.slider.ordinals.")).output(placeholder("name", "firstUpperCase")).output(literal("Ordinal());")));
		rules.add(rule().condition(allTypes("actionableMode", "splitbutton")).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(placeholder("option").multiple("\",\"")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_option(\"")).output(placeholder("default")).output(literal("\");"))));
		rules.add(rule().condition(allTypes("actionableMode", "iconsplitbutton")).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(placeholder("option").multiple("\",\"")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_option(\"")).output(placeholder("default")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_darkIcon(\"")).output(placeholder("darkIcon")).output(literal("\");"))));
		rules.add(rule().condition(allTypes("actionableMode", "materialiconsplitbutton")).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(placeholder("option").multiple("\",\"")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_option(\"")).output(placeholder("default")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_darkIcon(\"")).output(placeholder("darkIcon")).output(literal("\");"))));
		rules.add(rule().condition(allTypes("actionableMode", "iconbutton")).output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");\n")).output(expression().output(literal("_darkIcon(\"")).output(placeholder("darkIcon")).output(literal("\");"))));
		rules.add(rule().condition(allTypes("actionableMode", "icontoggle")).output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");\n")).output(expression().output(literal("_darkIcon(\"")).output(placeholder("darkIcon")).output(literal("\");"))));
		rules.add(rule().condition(allTypes("actionableMode", "materialiconbutton")).output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");\n")).output(expression().output(literal("_darkIcon(\"")).output(placeholder("darkIcon")).output(literal("\");"))));
		rules.add(rule().condition(allTypes("actionableMode", "materialicontoggle")).output(literal("_icon(\"")).output(placeholder("icon")).output(literal("\");\n")).output(expression().output(literal("_darkIcon(\"")).output(placeholder("darkIcon")).output(literal("\");"))));
		rules.add(rule().condition(allTypes("badge")).output(expression().output(literal("_value(")).output(placeholder("value")).output(literal(");"))));
		rules.add(rule().condition(allTypes("drawer")));
		rules.add(rule().condition(allTypes("popover")));
		rules.add(rule().condition(allTypes("selectionMethod")).output(literal("public void onSelect(io.intino.alexandria.ui.displays.events.SelectionListener listener) {\n\tsuper.addSelectionListener(listener);\n}")));
		rules.add(rule().condition(allTypes("editableMethods")).output(literal("public void onAdd(io.intino.alexandria.ui.displays.events.editable.AddItemListener listener) {\n\tsuper.addItemListener(listener);\n}\npublic void onChange(io.intino.alexandria.ui.displays.events.editable.ChangeItemListener listener) {\n\tsuper.changeItemListener(listener);\n}\npublic void onRemove(io.intino.alexandria.ui.displays.events.editable.RemoveItemListener listener) {\n\tsuper.removeItemListener(listener);\n}")));
		rules.add(rule().condition(allTypes("editableClass")).output(literal("public class ")).output(placeholder("componentName")).output(literal(" extends ")).output(placeholder("componentType")).output(literal(" {\n\tpublic ")).output(placeholder("componentName")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(placeholder("componentProperties", "common"))).output(literal("\n\t\t")).output(expression().output(placeholder("componentProperties", "specific"))).output(literal("\n\t}\n}")));
		rules.add(rule().condition(all(allTypes("item"), trigger("adddeclaration"))).output(placeholder("name")).output(literal("(add")).output(placeholder("name", "firstUpperCase")).output(literal("(new ")).output(placeholder("name", "firstUpperCase")).output(literal("(box())")).output(expression().output(literal(", ")).output(placeholder("itemVariable"))).output(literal("))")));
		rules.add(rule().condition(all(allTypes("item"), trigger("type"))).output(placeholder("name", "firstUpperCase")));
		rules.add(rule().condition(all(allTypes("item"), trigger("addrow"))).output(placeholder("name")).output(literal(" = register(add")).output(placeholder("name", "firstUpperCase")).output(literal("(box()));")));
		rules.add(rule().condition(all(allTypes("item"), trigger("property"))).output(literal("public ")).output(placeholder("name", "firstUpperCase")).output(literal(" ")).output(placeholder("name")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("item"), trigger("addmethod"))).output(placeholder("methodAccessibility")).output(literal(" ")).output(placeholder("name", "firstUpperCase")).output(literal(" create")).output(placeholder("methodName", "firstUpperCase")).output(literal("(")).output(expression().output(placeholder("itemClass")).output(literal(" element"))).output(literal(") {\n\t")).output(placeholder("name", "firstUpperCase")).output(literal(" result = new ")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(placeholder("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box());\n\tresult.id(java.util.UUID.randomUUID().toString());\n\t")).output(expression().output(literal("result.item(")).output(placeholder("itemVariable")).output(literal(");"))).output(literal("\n\t")).output(expression().output(literal("result.section(source().section(")).output(placeholder("itemVariable")).output(literal("));"))).output(literal("\n\treturn result;\n}")));
		rules.add(rule().condition(allTypes("itemClass", "map")).output(literal("io.intino.alexandria.ui.model.PlaceMark<")).output(placeholder("value")).output(literal(">")));
		rules.add(rule().condition(allTypes("itemClass")).output(placeholder("value")));
		rules.add(rule().condition(allTypes("itemVariable", "map")).output(literal("element.item()")));
		rules.add(rule().condition(allTypes("itemVariable")).output(literal("element")));
		rules.add(rule().condition(allTypes("useUrl", "custom")).output(literal("box().configuration().get(\"")).output(placeholder("value")).output(literal("\")")));
		rules.add(rule().condition(allTypes("column")).output(literal("_add(new io.intino.alexandria.ui.model.datasource.grid.GridColumn<")).output(placeholder("itemClass")).output(literal(">().name(\"")).output(placeholder("name")).output(literal("\").label(\"")).output(placeholder("label")).output(literal("\").type(io.intino.alexandria.ui.model.datasource.grid.GridColumn.Type.")).output(placeholder("type")).output(literal(")")).output(expression().output(literal(".width(")).output(placeholder("width")).output(literal(")"))).output(expression().output(literal(".sortable(")).output(placeholder("sortable")).output(literal(")"))).output(expression().output(literal(".address(\"")).output(placeholder("address")).output(literal("\")"))).output(expression().output(literal(".fixed(")).output(placeholder("fixed")).output(literal(")"))).output(expression().output(literal(".pattern(\"")).output(placeholder("pattern")).output(literal("\")"))).output(literal(");")));
		rules.add(rule().condition(allTypes("useUrl")).output(literal("\"")).output(placeholder("value")).output(literal("\"")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}