package io.intino.konos.builder.codegeneration.services.ui.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class RouteDispatcherTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("dispatcher", "gen"))).output(literal("package ")).output(mark("package")).output(literal(".ui.displays;\n\nimport io.intino.alexandria.ui.Soul;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.regex.Matcher;\nimport java.util.regex.Pattern;\n\npublic abstract class AbstractRouteDispatcher implements io.intino.alexandria.ui.displays.DisplayRouteDispatcher {\n\tprivate static java.util.Map<String, String> patterns = new HashMap<>();\n\n\tpublic AbstractRouteDispatcher() {\n\t\tregisterPatterns();\n\t}\n\n\t@Override\n\tpublic void dispatch(Soul soul, String address) {\n\t\taddress = address.replaceFirst(soul.session().browser().basePath(), \"\");\n\t\tList<String> params = paramsOf(address);\n\t\t")).output(expression().output(mark("resource", "call").multiple("\n"))).output(literal("\n\t}\n\n\t")).output(expression().output(mark("resource", "declaration").multiple("\n"))).output(literal("\n\n\tprivate void registerPatterns() {\n\t\tif (patterns.size() > 0) return;\n\t\t")).output(expression().output(mark("resource", "patternRegister").multiple("\n"))).output(literal("\n\t}\n\n\tprivate String patternOf(String address) {\n\t\t")).output(expression().output(mark("resource", "pattern").multiple("\n"))).output(literal("\n\t\treturn null;\n\t}\n\n\tprivate List<String> paramsOf(String address) {\n\t\treturn paramsOf(address, patternOf(address));\n\t}\n\n\tprivate List<String> paramsOf(String address, String pattern) {\n\t\tif (pattern == null) return java.util.Collections.emptyList();\n\t\tPattern p = Pattern.compile(pattern);\n\t\tMatcher m = p.matcher(address);\n\t\tif (!m.find()) return Collections.emptyList();\n\t\tList<String> result = new ArrayList<>();\n\t\tfor (int i=1; i<=m.groupCount(); i++) result.add(m.group(i).split(\"\\\\?\")[0]);\n\t\treturn addQueryStringParams(address, result);\n\t}\n\n\tprivate List<String> addQueryStringParams(String address, List<String> result) {\n\t\tif (address.indexOf(\"?\") == -1) return result;\n\t\tString[] parameters = address.split(\"\\\\?\")[1].split(\"&\");\n\t\tfor (int i = 0; i < parameters.length; i++) {\n\t\t\tresult.add(parameters[i].split(\"=\")[1]);\n\t\t}\n\t\treturn result;\n\t}\n\n}")),
				rule().condition((type("dispatcher"))).output(literal("package ")).output(mark("package")).output(literal(".ui.displays;\n\nimport io.intino.alexandria.ui.Soul;\n\npublic class RouteDispatcher extends AbstractRouteDispatcher {\n\t")).output(expression().output(mark("resource", "implementation").multiple("\n"))).output(literal("\n}")),
				rule().condition((allTypes("resource", "main")), (trigger("call"))).output(literal("if (address.length() <= 1) { dispatch")).output(mark("name", "firstUpperCase")).output(literal("(soul")).output(expression().output(literal(", ")).output(mark("param", "call").multiple(", "))).output(literal("); return; }")),
				rule().condition((type("resource")), (trigger("call"))).output(literal("if (address.matches(patterns.get(\"")).output(mark("name")).output(literal("\"))) { dispatch")).output(mark("name", "firstUpperCase")).output(literal("(soul")).output(expression().output(literal(", ")).output(mark("param", "call").multiple(", "))).output(literal("); return; }")),
				rule().condition((allTypes("resource", "main")), (trigger("declaration"))),
				rule().condition((type("resource")), (trigger("declaration"))).output(literal("public abstract void dispatch")).output(mark("name", "firstUpperCase")).output(literal("(Soul soul")).output(expression().output(literal(", ")).output(mark("param").multiple(", "))).output(literal(");")),
				rule().condition((allTypes("resource", "main")), (trigger("implementation"))),
				rule().condition((type("resource")), (trigger("implementation"))).output(literal("@Override\npublic void dispatch")).output(mark("name", "firstUpperCase")).output(literal("(Soul soul")).output(expression().output(literal(", ")).output(mark("param").multiple(", "))).output(literal(") {\n\t// TODO\n}")),
				rule().condition((allTypes("resource", "main")), (trigger("patternregister"))),
				rule().condition((type("resource")), (trigger("patternregister"))).output(literal("patterns.put(\"")).output(mark("name")).output(literal("\", \"")).output(mark("pattern")).output(literal("\");")),
				rule().condition((allTypes("resource", "main")), (trigger("pattern"))).output(literal("if (address.matches(patterns.get(\"")).output(mark("name")).output(literal("\"))) return patterns.get(\"")).output(mark("name")).output(literal("\");")),
				rule().condition((type("resource")), (trigger("pattern"))).output(literal("else if (address.matches(patterns.get(\"")).output(mark("name")).output(literal("\"))) return patterns.get(\"")).output(mark("name")).output(literal("\");")),
				rule().condition((allTypes("param", "optional")), (trigger("call"))).output(literal("params.size() > ")).output(mark("index")).output(literal(" ? params.get(")).output(mark("index")).output(literal(") : null")),
				rule().condition((type("param")), (trigger("call"))).output(literal("params.get(")).output(mark("index")).output(literal(")")),
				rule().condition((type("param"))).output(literal("String ")).output(mark("name"))
		);
	}
}