package io.intino.konos.builder.codegeneration.services.ui.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class PassiveViewRequesterTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("display", "accessible"))).output(literal("package ")).output(mark("package", "validPackage")).output(literal(".ui.displays.requesters;\n\nimport ")).output(mark("package", "validPackage")).output(literal(".ui.displays.")).output(expression().output(mark("packageType")).output(literal("s."))).output(mark("name", "FirstUppercase")).output(literal(";\nimport ")).output(mark("package", "validPackage")).output(literal(".ui.displays.")).output(expression().output(mark("packageType")).output(literal("s."))).output(mark("name", "FirstUpperCase")).output(literal("Proxy;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;\nimport io.intino.alexandria.ui.spark.UISparkManager;\n\npublic class ")).output(mark("name", "FirstUpperCase")).output(literal("ProxyRequester extends io.intino.alexandria.ui.displays.requesters.DisplayProxyRequester {\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("ProxyRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tString operation = operation();\n\t\t")).output(mark("name", "FirstUppercase")).output(literal(" display = personifiedDisplay();\n\t\tif (display == null) return;\n\t\tif (operation.equals(\"refreshPersonifiedDisplay\")) {\n\t\t\t")).output(mark("parameter").multiple("\n")).output(literal("\n\t\t\tdisplay.refresh();\n\t\t\treturn;\n\t\t}\n\t\t")).output(expression().output(literal("else ")).output(mark("request").multiple("\nelse "))).output(literal("\n\t\tsuper.execute();\n\t}\n}")),
				rule().condition((type("display"))).output(literal("package ")).output(mark("package", "validPackage")).output(literal(".ui.displays.requesters;\n\nimport ")).output(mark("package", "validPackage")).output(literal(".ui.displays.")).output(expression().output(mark("packageType")).output(literal("s."))).output(mark("name", "FirstUpperCase")).output(literal(";\nimport io.intino.alexandria.exceptions.*;\nimport ")).output(mark("package", "validPackage")).output(literal(".*;\n")).output(mark("schemaImport")).output(literal("\n\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;\nimport io.intino.alexandria.ui.spark.UISparkManager;\n\npublic class ")).output(mark("name", "firstUpperCase")).output(literal("Requester extends ")).output(mark("parentType")).output(literal(" {\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("Requester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\t")).output(mark("name", "firstUpperCase")).output(literal(" display = display();\n\t\tif (display == null) return;\n\t\tString operation = operation();\n\n\t\t")).output(expression().output(mark("request").multiple("\nelse "))).output(literal("\n\n\t\tsuper.execute();\n\t}\n}")),
				rule().condition((attribute("extensionof")), (trigger("parenttype"))).output(mark("parent", "firstUpperCase")).output(literal("Requester")),
				rule().condition((trigger("parenttype"))).output(literal("io.intino.alexandria.ui.displays.requesters.")).output(expression().output(mark("type", "class", "FirstUpperCase"))).output(literal("Requester")),
				rule().condition((attribute("", "Display")), (trigger("class"))).output(literal("Display")),
				rule().condition((allTypes("request", "asset")), (trigger("request"))).output(literal("if (operation.equals(\"")).output(mark("name")).output(literal("\")) {\n\tio.intino.alexandria.ui.spark.UIFile file = display.")).output(mark("name")).output(literal("(")).output(mark("parameter")).output(literal(");\n\tif (file == null) return;\n\tmanager.write(file.content(), file.label(), file.embedded());\n\treturn;\n}")),
				rule().condition((type("request")), (trigger("request"))).output(literal("if (operation.equals(\"")).output(mark("name")).output(literal("\")) {\n\tdisplay.")).output(mark("name")).output(literal("(")).output(mark("parameter")).output(literal(");\n\treturn;\n}")),
				rule().condition((allTypes("parameter", "accessible")), (trigger("parameter"))).output(literal("display.")).output(mark("value", "firstLowercase")).output(literal("(manager.fromQuery(\"")).output(mark("value")).output(literal("\"));")),
				rule().condition((type("list")), (trigger("parameter"))).output(literal("java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery(\"v\"), ")).output(mark("value")).output(literal("[].class))")),
				rule().condition((allTypes("parameter", "file")), (trigger("parameter"))).output(literal("manager.fromFormAsResource(\"v\")")),
				rule().condition((allTypes("parameter", "String")), (trigger("parameter"))).output(literal("manager.fromQuery(\"v\")")),
				rule().condition((allTypes("parameter", "Double")), (trigger("parameter"))).output(literal("Double.parseDouble(manager.fromQuery(\"v\"))")),
				rule().condition((allTypes("parameter", "Integer")), (trigger("parameter"))).output(literal("Integer.parseInt(manager.fromQuery(\"v\"))")),
				rule().condition((allTypes("parameter", "Long")), (trigger("parameter"))).output(literal("Long.parseLong(manager.fromQuery(\"v\"))")),
				rule().condition((allTypes("parameter", "DateTime")), (trigger("parameter"))).output(literal("manager.fromQuery(\"v\") != null ? java.time.Instant.ofEpochMilli(Long.parseLong(manager.fromQuery(\"v\"))) : null")),
				rule().condition((type("parameter")), (trigger("parameter"))).output(literal("io.intino.alexandria.Json.fromString(manager.fromQuery(\"v\"), ")).output(mark("value")).output(literal(".class)")),
				rule().condition((trigger("parameter"))).output(literal("aaaaa ")).output(mark("value")),
				rule().condition((type("schemaImport"))).output(literal("import ")).output(mark("package")).output(literal(".schemas.*;"))
		);
	}
}