package io.intino.konos.builder.codegeneration.services.ui.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ComponentTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((type("reference")), (trigger("declaration"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("reference", "item"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").<")).output(mark("name", "firstUpperCase")).output(literal(">item(")).output(mark("owner")).output(literal(".this.item()).owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((type("reference"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "collection", "embedded")), (trigger("declarations"))),
				rule().condition((allTypes("component", "child", "collection")), (trigger("declarations"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";\n")).output(expression().output(mark("component", "declarations").multiple("\n"))),
				rule().condition((allTypes("component", "child", "displaystamp", "single")), (trigger("declarations"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";\n")).output(expression().output(mark("component", "declarations").multiple("\n"))),
				rule().condition((allTypes("component", "child", "ownertemplatestamp", "single")), (trigger("declarations"))).output(literal("public ")).output(mark("ownerPackage")).output(literal(".")).output(mark("template", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("component", "child", "proxystamp", "single")), (trigger("declarations"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("component", "child", "basestamp", "single")), (trigger("declarations"))).output(literal("public ")).output(mark("template", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("component", "child")), (trigger("declarations"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";\n")).output(expression().output(mark("component", "declarations").multiple("\n"))),
				rule().condition((allTypes("component", "child", "displaystamp")), (trigger("declaration"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("component", "child", "ownertemplatestamp", "single")), (trigger("declaration"))).output(literal("public ")).output(mark("ownerPackage")).output(literal(".")).output(mark("template", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("component", "child", "proxystamp", "single")), (trigger("declaration"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("component", "child", "basestamp", "single")), (trigger("declaration"))).output(literal("public ")).output(mark("template", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((allTypes("component", "child")), (trigger("declaration"))).output(literal("public ")).output(expression().output(mark("ancestors", "firstUpperCase").multiple(".")).output(literal("."))).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((type("component")), (trigger("unregister"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".unregister();")),
				rule().condition((allTypes("method", "multiple", "collapsable"))).output(expression().output(mark("editableMethods"))).output(literal("\n")).output(expression().output(mark("editableClass"))).output(literal("\n@Override\npublic ")).output(mark("componentName")).output(literal(" add(")).output(expression().output(mark("objectType")).output(literal(" value, "))).output(literal("String label, String description) {\n\t")).output(mark("componentName")).output(literal(" child = new ")).output(mark("componentName")).output(literal("(box()")).output(expression().output(literal(".")).output(mark("componentOwnerBox", "lowerCase")).output(literal("()"))).output(literal(");\n\tchild.id(java.util.UUID.randomUUID().toString());\n\tchild.properties().put(\"label\", label);\n\tchild.properties().put(\"description\", description);\n\tadd(child, \"")).output(mark("name")).output(literal("\");\n\t")).output(expression().output(literal("child.value(")).output(mark("objectTypeValue")).output(literal(");"))).output(literal("\n\tnotifyAdd(child")).output(expression().output(literal(", ")).output(mark("objectTypeValue"))).output(literal(");\n\treturn child;\n}\n@Override\npublic void remove(")).output(mark("componentName")).output(literal(" child) {\n\tremoveChild(child, \"")).output(mark("name")).output(literal("\");\n}\npublic void clear() {\n\tsuper.clear(\"")).output(mark("name")).output(literal("\");\n}\n@Override\nprotected ")).output(mark("componentName")).output(literal(" add(")).output(expression().output(mark("objectType")).output(literal(" value"))).output(literal(") {\n\treturn add(value, null, null);\n}")),
				rule().condition((allTypes("method", "multiple"))).output(expression().output(mark("editableMethods"))).output(literal("\n")).output(expression().output(mark("editableClass"))).output(literal("\n@Override\npublic ")).output(mark("componentName")).output(literal(" add(")).output(expression().output(mark("objectType")).output(literal(" value"))).output(literal(") {\n\t")).output(mark("componentName")).output(literal(" child = new ")).output(mark("componentName")).output(literal("(box()")).output(expression().output(literal(".")).output(mark("componentOwnerBox", "lowerCase")).output(literal("()"))).output(literal(");\n\tchild.id(java.util.UUID.randomUUID().toString());\n\tadd(child, \"")).output(mark("name")).output(literal("\");\n\t")).output(expression().output(literal("child.value(")).output(mark("objectTypeValue")).output(literal(");"))).output(literal("\n\tnotifyAdd(child")).output(expression().output(literal(", ")).output(mark("objectTypeValue"))).output(literal(");\n\treturn child;\n}\n@Override\npublic void remove(")).output(mark("componentName")).output(literal(" child) {\n\tremoveChild(child, \"")).output(mark("name")).output(literal("\");\n}\npublic void clear() {\n\tsuper.clear(\"")).output(mark("name")).output(literal("\");\n}")),
				rule().condition((allTypes("method", "highlighted"))).output(literal("public ")).output(mark("name", "firstUpperCase")).output(literal(" textColor(String color) {\n\tthis._textColor(color);\n\tthis._refreshHighlight();\n\treturn this;\n}\n\npublic ")).output(mark("name", "firstUpperCase")).output(literal(" backgroundColor(String color) {\n\tthis._backgroundColor(color);\n\tthis._refreshHighlight();\n\treturn this;\n}")),
				rule().condition((allTypes("method", "signed"))).output(literal("public String signSecret() {\n    return this._signSecret();\n}\npublic ")).output(mark("name", "firstUpperCase")).output(literal(" signInfoProvider(io.intino.alexandria.ui.displays.components.actionable.SignInfoProvider provider) {\n\tthis._signInfoProvider(provider);\n\treturn this;\n}\npublic ")).output(mark("name", "firstUpperCase")).output(literal(" signChecker(io.intino.alexandria.ui.displays.components.actionable.SignChecker checker) {\n\tthis._signChecker(checker);\n\treturn this;\n}")),
				rule().condition((allTypes("method", "addressable"))).output(literal("@Override\npublic ")).output(mark("name", "firstUpperCase")).output(literal(" address(java.util.function.Function<String, String> addressFromPathResolver) {\n\taddress(addressFromPathResolver.apply(path()));\n\treturn this;\n}")),
				rule().condition((allTypes("method", "collectionbox"))).output(literal("@Override\npublic ")).output(mark("name", "firstUpperCase")).output(literal(" set(java.util.function.Function<String, String> addressFromPathResolver) {\n\taddress(addressFromPathResolver.apply(path()));\n\treturn this;\n}")),
				rule().condition((allTypes("method", "collection", "table"))).output(expression().output(mark("selectionMethod"))).output(literal("\n\npublic ")).output(mark("name", "firstUpperCase")).output(literal("Row create(")).output(expression().output(mark("itemClass")).output(literal(" item"))).output(literal(") {\n\t")).output(mark("name", "firstUpperCase")).output(literal("Row row = new ")).output(mark("name", "firstUpperCase")).output(literal("Row(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box());\n\trow.id(java.util.UUID.randomUUID().toString());\n\t")).output(expression().output(literal("row.item(")).output(mark("itemVariable")).output(literal(");"))).output(literal("\n\treturn row;\n}")),
				rule().condition((allTypes("method", "collection", "dynamictable"))).output(expression().output(mark("selectionMethod"))).output(literal("\n\npublic ")).output(mark("name", "firstUpperCase")).output(literal("Row create(")).output(expression().output(mark("itemClass")).output(literal(" item"))).output(literal(") {\n\t")).output(mark("name", "firstUpperCase")).output(literal("Row row = new ")).output(mark("name", "firstUpperCase")).output(literal("Row(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box());\n\trow.id(java.util.UUID.randomUUID().toString());\n\t")).output(expression().output(literal("row.item(")).output(mark("itemVariable")).output(literal(");"))).output(literal("\n\treturn row;\n}")),
				rule().condition((allTypes("method", "collection"))).output(mark("selectionMethod")).output(literal("\n")).output(expression().output(mark("item", "addMethod").multiple("\n\n"))).output(literal("\n\n")).output(expression().output(mark("item", "removeMethod").multiple("\n\n"))),
				rule().condition((allTypes("component", "child")), (trigger("method"))),
				rule().condition((allTypes("component", "child", "displaystamp")), (trigger("class"))).output(literal("public class ")).output(mark("name", "firstUpperCase")).output(literal(" extends ")).output(mark("extends")).output(literal(" ")).output(mark("implements")).output(literal(" {\n\t")).output(expression().output(mark("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(mark("properties", "common"))).output(literal("\n\t\t")).output(expression().output(mark("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(mark("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(mark("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(mark("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(mark("methods")).output(literal("\n\t")).output(expression().output(mark("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(mark("component", "method").multiple("\n\n"))).output(literal("\n}")),
				rule().condition((allTypes("component", "child", "proxystamp")), (trigger("class"))).output(literal("public class ")).output(mark("name", "firstUpperCase")).output(literal(" extends ")).output(mark("extends")).output(literal(" ")).output(mark("implements")).output(literal(" {\n\t")).output(expression().output(mark("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(mark("properties", "common"))).output(literal("\n\t\t")).output(expression().output(mark("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(mark("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(mark("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(mark("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(mark("methods")).output(literal("\n\t")).output(expression().output(mark("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(mark("component", "method").multiple("\n\n"))).output(literal("\n}")),
				rule().condition((allTypes("component", "child", "basestamp", "single")), (trigger("class"))),
				rule().condition((allTypes("component", "child", "collection", "embedded")), (trigger("class"))).output(literal("public class ")).output(mark("name", "firstUpperCase")).output(literal(" extends ")).output(mark("package")).output(literal(".ui.displays")).output(expression().output(literal(".")).output(mark("packageType")).output(literal("s"))).output(literal(".")).output(mark("name", "firstUpperCase")).output(literal(" {\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tthis((")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)box);\n\t}\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(mark("properties", "common"))).output(literal("\n\t\t")).output(expression().output(mark("properties", "specific"))).output(literal("\n\t}\n}")),
				rule().condition((allTypes("component", "child", "collection")), (trigger("class"))).output(literal("public class ")).output(mark("name", "firstUpperCase")).output(literal(" extends ")).output(mark("extends")).output(literal(" ")).output(mark("implements")).output(literal(" {\n\t")).output(expression().output(mark("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(mark("properties", "common"))).output(literal("\n\t\t")).output(expression().output(mark("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(mark("methodName")).output(literal("() {\n\t\tsuper.")).output(mark("methodName")).output(literal("();\n\t\t")).output(expression().output(mark("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(mark("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(mark("methods")).output(literal("\n\t")).output(expression().output(mark("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(mark("component", "method").multiple("\n\n"))).output(literal("\n}")),
				rule().condition((attribute("notifyready"))).output(literal("notifyReady();")),
				rule().condition((allTypes("component", "child", "block", "conditional")), (trigger("class"))).output(literal("public class ")).output(mark("name", "firstUpperCase")).output(literal(" extends ")).output(mark("extends")).output(literal(" ")).output(mark("implements")).output(literal(" {\n\t")).output(expression().output(mark("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(mark("properties", "common"))).output(literal("\n\t\t")).output(expression().output(mark("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(mark("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(mark("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "child").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "conditionalReferences").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(mark("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(mark("methods")).output(literal("\n\t")).output(expression().output(mark("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(mark("component", "method").multiple("\n\n"))).output(literal("\n}")),
				rule().condition((allTypes("component", "child")), (trigger("class"))).output(literal("public class ")).output(mark("name", "firstUpperCase")).output(literal(" extends ")).output(mark("extends")).output(literal(" ")).output(mark("implements")).output(literal(" {\n\t")).output(expression().output(mark("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("component", "declaration").multiple("\n"))).output(literal("\n\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(mark("properties", "common"))).output(literal("\n\t\t")).output(expression().output(mark("properties", "specific"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void ")).output(mark("methodName")).output(literal("() {\n\t\tsuper.init();\n\t\t")).output(expression().output(mark("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "child").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void unregister() {\n\t\tsuper.unregister();\n\t\t")).output(expression().output(mark("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(mark("methods")).output(literal("\n\t")).output(expression().output(mark("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(mark("component", "method").multiple("\n\n"))).output(literal("\n}")),
				rule().condition((allTypes("extends", "multiple", "image"))).output(literal("io.intino.alexandria.ui.displays.components.MultipleImage<")).output(mark("abstractBox", "type")).output(literal(", ")).output(expression().output(mark("componentPrefix", "firstUpperCase")).output(literal("."))).output(mark("componentName")).output(literal(", ")).output(mark("objectType")).output(literal(">")),
				rule().condition((allTypes("extends", "multiple"))).output(literal("io.intino.alexandria.ui.displays.components.Multiple<")).output(mark("abstractBox", "type")).output(literal(", ")).output(expression().output(mark("componentPrefix", "firstUpperCase")).output(literal("."))).output(mark("componentName")).output(literal(", ")).output(mark("objectType")).output(literal(">")),
				rule().condition((allTypes("extends", "collection", "grid"))).output(literal("io.intino.alexandria.ui.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<io.intino.alexandria.ui.displays.notifiers.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("Notifier, ")).output(mark("abstractBox", "type")).output(literal(", ")).output(mark("itemClass")).output(literal(">")),
				rule().condition((allTypes("extends", "collection", "table"))).output(literal("io.intino.alexandria.ui.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<")).output(mark("abstractBox", "type")).output(literal(", io.intino.alexandria.ui.displays.components.Row, ")).output(mark("itemClass")).output(literal(">")),
				rule().condition((allTypes("extends", "collection", "dynamictable"))).output(literal("io.intino.alexandria.ui.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<")).output(mark("abstractBox", "type")).output(literal(", io.intino.alexandria.ui.displays.components.Row, ")).output(mark("itemClass")).output(literal(">")),
				rule().condition((allTypes("extends", "collection"))).output(literal("io.intino.alexandria.ui.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<")).output(mark("abstractBox", "type")).output(literal(", ")).output(mark("componentType")).output(literal(", ")).output(mark("itemClass")).output(literal(">")),
				rule().condition((allTypes("extends", "item"))).output(literal("io.intino.alexandria.ui.displays.components.Item<")).output(mark("abstractBox", "type")).output(literal(", ")).output(mark("itemClass")).output(literal(">")),
				rule().condition((allTypes("extends", "displaystamp"))).output(literal("io.intino.alexandria.ui.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<io.intino.alexandria.ui.displays.notifiers.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("Notifier, ")).output(mark("abstractBox", "type")).output(literal(">")),
				rule().condition((allTypes("extends", "proxystamp"))).output(literal("io.intino.alexandria.ui.displays.components.ProxyStamp<io.intino.alexandria.ui.displays.notifiers.ProxyStampNotifier, ")).output(mark("abstractBox", "type")).output(literal(">")),
				rule().condition((allTypes("extends", "basestamp"))).output(mark("type", "firstUpperCase")),
				rule().condition((type("extends"))).output(literal("io.intino.alexandria.ui.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<io.intino.alexandria.ui.displays.notifiers.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("Notifier, ")).output(mark("abstractBox", "type")).output(literal(">")),
				rule().condition((allTypes("component", "child", "multipleblock")), (trigger("rootchildreferences"))),
				rule().condition((allTypes("component", "child", "collection", "embedded")), (trigger("rootchildreferences"))),
				rule().condition((allTypes("component", "child", "collection")), (trigger("rootchildreferences"))).output(expression().output(literal("if (")).output(mark("parent")).output(literal(" != null)"))).output(literal(" ")).output(mark("name")).output(literal(" = ")).output(expression().output(mark("ancestorsNotMe").multiple(".")).output(literal("."))).output(mark("name")).output(literal(";\n")).output(expression().output(mark("component", "rootChildReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child")), (trigger("rootchildreferences"))).output(expression().output(literal("if (")).output(mark("parent")).output(literal(" != null)"))).output(literal(" ")).output(mark("name")).output(literal(" = ")).output(expression().output(mark("ancestorsNotMe").multiple(".")).output(literal("."))).output(mark("name")).output(literal(";\n")).output(expression().output(mark("component", "rootChildReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child", "collection", "embedded")), (trigger("childreferences"))),
				rule().condition((allTypes("component", "child", "collection")), (trigger("childreferences"))).output(expression().output(literal("if (")).output(mark("parent")).output(literal(" != null)"))).output(literal(" ")).output(mark("name")).output(literal(" = ")).output(expression().output(mark("ancestors").multiple(".")).output(literal("."))).output(mark("name")).output(literal(";\n")).output(expression().output(mark("component", "childReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child")), (trigger("childreferences"))).output(expression().output(literal("if (")).output(mark("parent")).output(literal(" != null)"))).output(literal(" ")).output(mark("name")).output(literal(" = ")).output(expression().output(mark("ancestors").multiple(".")).output(literal("."))).output(mark("name")).output(literal(";\n")).output(expression().output(mark("component", "childReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child", "collection", "embedded")), (trigger("rootreferences"))),
				rule().condition((allTypes("component", "child", "collection")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));\n")).output(expression().output(mark("component", "rootChildReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child", "displaystamp")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));\n")).output(expression().output(mark("component", "rootChildReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child", "ownertemplatestamp", "multiple")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("ownerPackage")).output(literal(".")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("ownerBox")).output(literal("Box)"))).output(literal("box().owner()).<")).output(mark("ownerPackage")).output(literal(".")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "proxystamp", "multiple")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "basestamp", "multiple")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "ownertemplatestamp", "single")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("ownerPackage")).output(literal(".")).output(mark("template", "firstUpperCase")).output(mark("generic")).output(literal("(")).output(expression().output(literal("(")).output(mark("ownerBox")).output(literal("Box)"))).output(literal("box().owner()).<")).output(mark("ownerPackage")).output(literal(".")).output(mark("template", "firstUpperCase")).output(mark("generic")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "proxystamp", "single")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "basestamp", "single")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("template", "firstUpperCase")).output(mark("generic")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).id(\"")).output(mark("id")).output(literal("\"));")),
				rule().condition((allTypes("component", "child")), (trigger("rootreferences"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));\n")).output(expression().output(mark("component", "rootChildReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child", "collection", "embedded")), (trigger("references"))),
				rule().condition((allTypes("component", "child", "collection")), (trigger("references"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));\n")).output(expression().output(mark("component", "childReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child")), (trigger("references"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));\n")).output(expression().output(mark("component", "childReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child", "block", "conditional")), (trigger("conditionalreferences"))),
				rule().condition((allTypes("component", "child", "block")), (trigger("conditionalreferences"))).output(expression().output(mark("component", "conditionalReferences").multiple("\n"))),
				rule().condition((allTypes("component", "child")), (trigger("conditionalreferences"))).output(literal("if (")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" == null) ")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" = ")).output(expression().output(mark("ancestorsNotMe").multiple(".")).output(literal("."))).output(mark("name")).output(literal(";\n")).output(expression().output(mark("binding").multiple("\n"))).output(literal("\n")).output(expression().output(mark("attachedTo"))),
				rule().condition((allTypes("component", "child", "collection", "embedded")), (trigger("initializations"))),
				rule().condition((allTypes("component", "child", "collection")), (trigger("initializations"))).output(expression().output(mark("binding").multiple("\n"))).output(literal("\n")).output(expression().output(mark("attachedTo"))).output(literal("\n")).output(expression().output(mark("component", "initializations").multiple("\n"))),
				rule().condition((allTypes("component", "child")), (trigger("initializations"))).output(expression().output(mark("binding").multiple("\n"))).output(literal("\n")).output(expression().output(mark("attachedTo"))).output(literal("\n")).output(expression().output(mark("component", "initializations").multiple("\n"))),
				rule().condition((allTypes("component", "child", "displaystamp"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = ")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "ownertemplatestamp", "multiple"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = ")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "basestamp", "multiple"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = ")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "ownertemplatestamp", "single"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = ")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" = register(new ")).output(mark("ownerPackage")).output(literal(".")).output(mark("template", "firstUpperCase")).output(mark("generic")).output(literal("(")).output(expression().output(literal("(")).output(mark("ownerBox")).output(literal("Box)"))).output(literal("box().owner()).<")).output(mark("ownerPackage")).output(literal(".")).output(mark("template", "firstUpperCase")).output(mark("generic")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "proxystamp", "single"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = ")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((allTypes("component", "child", "basestamp", "single"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = ")).output(mark("owner")).output(literal(".this.")).output(mark("name")).output(literal(" = register(new ")).output(mark("template", "firstUpperCase")).output(mark("generic")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box()).id(\"")).output(mark("id")).output(literal("\"));")),
				rule().condition((allTypes("component", "child"))).output(literal("if (")).output(mark("name")).output(literal(" == null) ")).output(mark("name")).output(literal(" = register(new ")).output(mark("name", "firstUpperCase")).output(literal("(box()).<")).output(mark("name", "firstUpperCase")).output(literal(">id(\"")).output(mark("id")).output(literal("\").owner(")).output(mark("owner")).output(literal(".this));")),
				rule().condition((type("facet"))).output(mark("name", "firstUpperCase")),
				rule().condition((allTypes("binding", "toolbar"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(expression().output(mark("ancestorsNotMe").multiple(".")).output(literal("."))).output(mark("collection")).output(literal(");")),
				rule().condition((allTypes("binding", "grouping"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection").multiple(",")).output(literal(");")),
				rule().condition((allTypes("binding", "datenavigator"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("component").multiple(",")).output(literal(");")),
				rule().condition((allTypes("binding", "groupingToolbar"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("grouping").multiple(",")).output(literal(");")),
				rule().condition((allTypes("binding", "sorting"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection").multiple(",")).output(literal(");")),
				rule().condition((allTypes("binding", "searchbox"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection").multiple(",")).output(literal(");")),
				rule().condition((allTypes("binding", "download"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection").multiple(",")).output(literal(");")),
				rule().condition((allTypes("binding", "temporalslider"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection").multiple(",")).output(literal(");")),
				rule().condition((allTypes("binding", "openblock"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("block")).output(literal(");")),
				rule().condition((allTypes("binding", "closeblock"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("block")).output(literal(");")),
				rule().condition((allTypes("binding", "opendialog"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("dialog")).output(literal(");")),
				rule().condition((allTypes("binding", "closedialog"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("dialog")).output(literal(");")),
				rule().condition((allTypes("binding", "opendrawer"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("drawer")).output(literal(");")),
				rule().condition((allTypes("binding", "closedrawer"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("drawer")).output(literal(");")),
				rule().condition((allTypes("binding", "openpopover"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("popover")).output(literal(");")),
				rule().condition((allTypes("binding", "opennextitem"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection")).output(literal(");")),
				rule().condition((allTypes("binding", "openpreviousitem"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection")).output(literal(");")),
				rule().condition((allTypes("binding", "decisiondialog"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("selector")).output(literal(");")),
				rule().condition((allTypes("binding", "collectiondialog"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection")).output(literal(");")),
				rule().condition((allTypes("binding", "collectionbox", "add"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("name")).output(literal(".")).output(mark("collection")).output(literal(");")),
				rule().condition((allTypes("binding", "collectionbox"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("collection")).output(literal(");")),
				rule().condition((type("binding"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".bindTo(")).output(mark("selector")).output(literal(", \"")).output(mark("option")).output(literal("\");")),
				rule().condition((allTypes("attachedTo", "grouping"))).output(literal("if (")).output(mark("name")).output(literal(" != null) ")).output(mark("name")).output(literal(".attachTo(")).output(mark("grouping")).output(literal(");")),
				rule().condition((allTypes("implements", "selectable"))).output(literal("implements io.intino.alexandria.ui.displays.components.collection.Selectable")),
				rule().condition((allTypes("implements", "multiple", "collapsable"))).output(literal("implements io.intino.alexandria.ui.displays.components.multiple.Collapsable<")).output(mark("abstractBox", "type")).output(literal(", ")).output(expression().output(mark("componentPrefix", "firstUpperCase")).output(literal("."))).output(mark("componentName")).output(literal(", ")).output(mark("objectType")).output(literal(">")),
				rule().condition((allTypes("implements", "multiple"))).output(literal("implements io.intino.alexandria.ui.displays.components.multiple.NonCollapsable<")).output(mark("abstractBox", "type")).output(literal(", ")).output(expression().output(mark("componentPrefix", "firstUpperCase")).output(literal("."))).output(mark("componentName")).output(literal(", ")).output(mark("objectType")).output(literal(">")),
				rule().condition((allTypes("implements", "option"))).output(literal("implements io.intino.alexandria.ui.displays.components.selector.SelectorOption")),
				rule().condition((allTypes("implements", "dynamicloaded"))).output(literal("implements io.intino.alexandria.ui.displays.components.DynamicLoaded")),
				rule().condition((allTypes("implements", "addressable", "action"))).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(mark("name", "firstUpperCase")).output(literal(">")),
				rule().condition((allTypes("implements", "addressable", "openlayer"))).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(mark("name", "firstUpperCase")).output(literal(">")),
				rule().condition((allTypes("implements", "addressable", "selector"))).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(mark("name", "firstUpperCase")).output(literal(">")),
				rule().condition((allTypes("implements", "addressable", "grouping"))).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(mark("name", "firstUpperCase")).output(literal(">")),
				rule().condition((allTypes("implements", "addressable", "searchbox"))).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(mark("name", "firstUpperCase")).output(literal(">")),
				rule().condition((allTypes("implements", "addressable", "sorting"))).output(literal("implements io.intino.alexandria.ui.displays.components.addressable.Addressed<")).output(mark("name", "firstUpperCase")).output(literal(">")),
				rule().condition((type("implements"))).output(literal("implements --undefined--")),
				rule().condition((allTypes("properties", "actionable")), (trigger("common"))).output(expression().output(literal("_title(\"")).output(mark("title")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_color(\"")).output(mark("color")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf(\"")).output(mark("mode", "firstUpperCase")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_signMode(io.intino.alexandria.ui.displays.components.Actionable.SignMode.valueOf(\"")).output(mark("signMode", "firstUpperCase")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_signChecker(_")).output(mark("signChecker")).output(literal("());"))).output(literal("\n")).output(expression().output(mark("actionableMode"))),
				rule().condition((allTypes("properties", "appDirectory")), (trigger("common"))).output(expression().output(literal("_icon(\"")).output(mark("icon")).output(literal("\");"))),
				rule().condition((allTypes("properties", "dashboard")), (trigger("common"))).output(expression().output(mark("parameter").multiple("\n"))),
				rule().condition((type("properties")), (trigger("common"))).output(expression().output(literal("label(\"")).output(mark("label")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("name(\"")).output(mark("name")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_color(\"")).output(mark("color")).output(literal("\");"))),
				rule().condition((allTypes("properties", "proxyStamp")), (trigger("specific"))).output(literal("_proxy(new ")).output(mark("proxyPackage")).output(literal(".")).output(mark("proxyDisplay", "firstUpperCase")).output(literal("(new io.intino.alexandria.ui.spark.pages.Unit(\"")).output(mark("proxyUseName")).output(literal("\", ")).output(mark("proxyUseUrl")).output(literal(")));\n")).output(expression().output(mark("parameter").multiple("\n"))),
				rule().condition((allTypes("properties", "selector")), (trigger("specific"))).output(expression().output(literal("_multipleSelection(")).output(mark("multipleSelection")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))),
				rule().condition((allTypes("properties", "grouping")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))),
				rule().condition((allTypes("properties", "kpi")), (trigger("specific"))).output(expression().output(literal("_value(")).output(mark("value")).output(literal(");"))),
				rule().condition((allTypes("properties", "sorting")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))),
				rule().condition((allTypes("properties", "searchbox")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))),
				rule().condition((allTypes("properties", "materialicon")), (trigger("specific"))).output(expression().output(literal("_icon(\"")).output(mark("icon")).output(literal("\");"))),
				rule().condition((allTypes("properties", "icon")), (trigger("specific"))).output(expression().output(mark("icon", "resourceMethod"))),
				rule().condition((allTypes("properties", "microsite")), (trigger("specific"))).output(expression().output(mark("site", "resourceMethod"))),
				rule().condition((allTypes("properties", "block")), (trigger("specific"))).output(expression().output(mark("background", "resourceMethod"))).output(literal("\n")).output(expression().output(mark("badge"))).output(literal("\n")).output(expression().output(mark("drawer"))).output(literal("\n")).output(expression().output(mark("popover"))),
				rule().condition((allTypes("properties", "image", "avatar")), (trigger("specific"))).output(expression().output(literal("_text(\"")).output(mark("text")).output(literal("\");"))),
				rule().condition((allTypes("properties", "image", "multiple", "componentClass")), (trigger("specific"))).output(expression().output(mark("value", "resourceMethod"))).output(literal("\n")).output(expression().output(mark("defaultValue", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "image", "multiple")), (trigger("specific"))).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "image")), (trigger("specific"))).output(expression().output(mark("value", "resourceMethod"))).output(literal("\n")).output(expression().output(mark("defaultValue", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "file", "multiple", "componentClass")), (trigger("specific"))).output(expression().output(mark("value", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "file", "multiple")), (trigger("specific"))).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "file")), (trigger("specific"))).output(expression().output(mark("value", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "openpage")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))),
				rule().condition((allTypes("properties", "openlayer")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_transition(io.intino.alexandria.ui.displays.components.OpenLayer.Transition.valueOf(\"")).output(mark("transition")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "openpopover")), (trigger("specific"))).output(expression().output(literal(" _triggerEvent(io.intino.alexandria.ui.displays.components.OpenPopover.TriggerEvent.")).output(mark("triggerEvent")).output(literal(");"))),
				rule().condition((allTypes("properties", "opensite")), (trigger("specific"))).output(expression().output(literal("_site(\"")).output(mark("site")).output(literal("\");"))),
				rule().condition((allTypes("properties", "switch")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_state(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State.valueOf(\"")).output(mark("state")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "toggle")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_state(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State.valueOf(\"")).output(mark("state")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "copytoclipboard")), (trigger("specific"))).output(expression().output(literal("_text(\"")).output(mark("text")).output(literal("\");"))),
				rule().condition((allTypes("properties", "signText")), (trigger("specific"))).output(expression().output(literal("_text(\"")).output(mark("text")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_signFormat(io.intino.alexandria.ui.displays.components.SignAction.SignFormat.valueOf(\"")).output(mark("signFormat")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "signDocument")), (trigger("specific"))).output(expression().output(literal("_document(")).output(mark("owner")).output(literal(".class.getResource(\"")).output(mark("value")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "action")), (trigger("specific"))).output(expression().output(literal("_path(\"")).output(mark("path")).output(literal("\");"))),
				rule().condition((allTypes("properties", "export")), (trigger("specific"))).output(expression().output(literal("_from(")).output(mark("from")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_to(")).output(mark("to")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_min(")).output(mark("min")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_max(")).output(mark("max")).output(literal("L);"))).output(literal("\n")).output(expression().output(literal("_range(")).output(mark("rangeMin")).output(literal(",")).output(mark("rangeMax")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(mark("option").multiple("\",\"")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "download")), (trigger("specific"))).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(mark("option").multiple("\",\"")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "download", "selection")), (trigger("specific"))).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(mark("option").multiple("\",\"")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "chart")), (trigger("specific"))).output(expression().output(literal("_query(\"")).output(mark("query")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_serverUrl(\"")).output(mark("serverUrl")).output(literal("\");"))).output(literal("\n")).output(expression().output(mark("input", "inputMethod"))).output(literal("\n")).output(expression().output(literal("_output(\"")).output(mark("output")).output(literal("\");"))),
				rule().condition((allTypes("properties", "appDirectory", "fromFile")), (trigger("specific"))).output(expression().output(mark("source", "fileMethod"))),
				rule().condition((allTypes("properties", "appDirectory", "fromResource")), (trigger("specific"))).output(expression().output(mark("source", "resourceMethod"))),
				rule().condition((allTypes("properties", "appDirectory", "inline")), (trigger("specific"))).output(mark("application").multiple("\n")),
				rule().condition((allTypes("properties", "datenavigator")), (trigger("specific"))).output(expression().output(literal("_selected(java.time.Instant.ofEpochMilli(")).output(mark("value")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_range(java.time.Instant.ofEpochMilli(")).output(mark("from")).output(literal("L), java.time.Instant.ofEpochMilli(")).output(mark("to")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_scales(")).output(mark("scale").multiple(",")).output(literal(");"))),
				rule().condition((type("scale"))).output(literal("io.intino.alexandria.Scale.")).output(mark("value", "firstUpperCase")),
				rule().condition((allTypes("properties", "timeline")), (trigger("specific"))).output(expression().output(literal("_mode(io.intino.alexandria.ui.displays.components.Timeline.Mode.valueOf(\"")).output(mark("mode", "firstUpperCase")).output(literal("\"));"))),
				rule().condition((allTypes("properties", "eventline")), (trigger("specific"))).output(expression().output(literal("_arrangement(io.intino.alexandria.ui.displays.components.Eventline.Arrangement.valueOf(\"")).output(mark("arrangement", "firstUpperCase")).output(literal("\"));"))),
				rule().condition((type("appDirectoryApplication"))).output(literal("_add(\"")).output(mark("name")).output(literal("\", \"")).output(mark("url")).output(literal("\")")).output(expression().output(mark("translation").multiple(""))).output(literal(";")),
				rule().condition((type("appDirectoryApplicationTranslation"))).output(literal(".translation(\"")).output(mark("language")).output(literal("\", \"")).output(mark("name")).output(literal("\")")),
				rule().condition((allTypes("properties", "dashboard", "shiny")), (trigger("specific"))).output(expression().output(mark("serverScript", "resourceMethod"))).output(literal("\n")).output(expression().output(mark("uiScript", "resourceMethod"))).output(literal("\n")).output(expression().output(mark("resource", "resourceMethod").multiple("\n"))),
				rule().condition((allTypes("properties", "documenteditor", "collabora")), (trigger("specific"))).output(expression().output(literal("_document(\"")).output(mark("document")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_editorUrl(\"")).output(mark("editorUrl")).output(literal("\");"))),
				rule().condition((allTypes("properties", "dashboard", "metabase")), (trigger("specific"))).output(expression().output(literal("_url(\"")).output(mark("url")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_secretKey(\"")).output(mark("secretKey")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_bordered(")).output(mark("bordered")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_titled(")).output(mark("titled")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_theme(io.intino.alexandria.ui.displays.components.DashboardMetabase.Theme.")).output(mark("theme")).output(literal(");"))),
				rule().condition((allTypes("properties", "number", "multiple", "componentClass")), (trigger("specific"))).output(expression().output(literal("_value(")).output(mark("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_min(")).output(mark("min")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_max(")).output(mark("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "number", "multiple")), (trigger("specific"))).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "number")), (trigger("specific"))).output(expression().output(literal("_value(")).output(mark("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_min(")).output(mark("min")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_max(")).output(mark("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "date", "multiple", "componentClass")), (trigger("specific"))).output(expression().output(literal("_value(java.time.Instant.ofEpochMilli(")).output(mark("value")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_min(java.time.Instant.ofEpochMilli(")).output(mark("min")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_max(java.time.Instant.ofEpochMilli(")).output(mark("max")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "date", "multiple")), (trigger("specific"))).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "date")), (trigger("specific"))).output(expression().output(literal("_value(java.time.Instant.ofEpochMilli(")).output(mark("value")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_min(java.time.Instant.ofEpochMilli(")).output(mark("min")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_max(java.time.Instant.ofEpochMilli(")).output(mark("max")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "text", "multiple", "componentClass")), (trigger("specific"))).output(expression().output(literal("_value(\"")).output(mark("defaultValue")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "text", "multiple")), (trigger("specific"))).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "text")), (trigger("specific"))).output(expression().output(literal("_value(\"")).output(mark("defaultValue")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_pattern(\"")).output(mark("pattern")).output(literal("\");"))),
				rule().condition((allTypes("properties", "location", "multiple", "componentClass")), (trigger("specific"))).output(expression().output(mark("icon", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_value(\"")).output(mark("value")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "location", "multiple")), (trigger("specific"))).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "location")), (trigger("specific"))).output(expression().output(mark("icon", "resourceMethod"))).output(literal("\n")).output(expression().output(literal("_value(\"")).output(mark("value")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))),
				rule().condition((allTypes("properties", "collection", "map")), (trigger("specific"))).output(expression().output(literal("_type(io.intino.alexandria.ui.displays.components.Map.Type.valueOf(\"")).output(mark("type")).output(literal("\"));"))).output(literal("\n")).output(expression().output(mark("icon", "resourceMethod"))).output(literal("\n")).output(expression().output(mark("layer", "resourceMethod"))),
				rule().condition((allTypes("properties", "collection")), (trigger("specific"))).output(expression().output(literal("_source(new io.intino.alexandria.ui.sources.")).output(mark("sourceClass", "firstUpperCase")).output(literal("());"))).output(literal("\n")).output(expression().output(mark("column").multiple("\n"))).output(literal("\n")).output(expression().output(literal("_pageSize(")).output(mark("pageSize")).output(literal(");"))),
				rule().condition((allTypes("properties", "slider")), (trigger("specific"))).output(expression().output(literal("_value(")).output(mark("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_range(")).output(mark("min")).output(literal(",")).output(mark("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_animation(")).output(mark("interval")).output(literal(",")).output(mark("loop")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(mark("ordinal", "ordinalMethod").multiple("\n"))),
				rule().condition((allTypes("properties", "rangeslider")), (trigger("specific"))).output(expression().output(literal("_value(")).output(mark("from")).output(literal(",")).output(mark("to")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_range(")).output(mark("min")).output(literal(",")).output(mark("max")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_animation(")).output(mark("interval")).output(literal(",")).output(mark("loop")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(mark("ordinal", "ordinalMethod").multiple("\n"))),
				rule().condition((allTypes("properties", "temporalslider")), (trigger("specific"))).output(expression().output(literal("_value(")).output(mark("value")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_range(java.time.Instant.ofEpochMilli(")).output(mark("min")).output(literal("L),java.time.Instant.ofEpochMilli(")).output(mark("max")).output(literal("L));"))).output(literal("\n")).output(expression().output(literal("_animation(")).output(mark("interval")).output(literal(",")).output(mark("loop")).output(literal(");"))).output(literal("\n")).output(expression().output(literal("_readonly(")).output(mark("readonly")).output(literal(");"))).output(literal("\n")).output(expression().output(mark("ordinal", "ordinalMethod").multiple("\n"))),
				rule().condition((allTypes("properties", "collectiondialog")), (trigger("specific"))).output(expression().output(literal("_allowSearch(")).output(mark("allowSearch")).output(literal(");"))),
				rule().condition((allTypes("properties", "frame")), (trigger("specific"))).output(expression().output(literal("_url(\"")).output(mark("url")).output(literal("\");"))),
				rule().condition((type("properties")), (trigger("specific"))),
				rule().condition((allTypes("inputMethod", "csv")), (trigger("inputmethod"))).output(literal("_input(new io.intino.alexandria.ui.displays.components.chart.datasources.CSVDataSource(")).output(mark("owner")).output(literal(".class.getResource(\"")).output(mark("value")).output(literal("\")));")),
				rule().condition((allTypes("inputMethod", "source")), (trigger("inputmethod"))).output(literal("_input(new ")).output(mark("value")).output(literal("());")),
				rule().condition((type("parameterMethod"))).output(literal("_add(\"")).output(mark("name")).output(literal("\", \"")).output(mark("value")).output(literal("\");")),
				rule().condition((trigger("filemethod"))).output(literal("_")).output(mark("name")).output(literal("(new java.io.File(\"")).output(mark("value")).output(literal("\")")).output(expression().output(literal(", \"")).output(mark("extraParam")).output(literal("\""))).output(literal(");")),
				rule().condition((trigger("resourcemethod"))).output(literal("_")).output(mark("name")).output(literal("(")).output(mark("owner")).output(literal(".class.getResource(\"")).output(mark("value")).output(literal("\")")).output(expression().output(literal(", \"")).output(mark("extraParam")).output(literal("\""))).output(literal(");")),
				rule().condition((trigger("ordinalmethod"))).output(literal("_add(new io.intino.alexandria.ui.displays.components.slider.ordinals.")).output(mark("name", "firstUpperCase")).output(literal("Ordinal());")),
				rule().condition((allTypes("actionableMode", "splitbutton"))).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(mark("option").multiple("\",\"")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_option(\"")).output(mark("default")).output(literal("\");"))),
				rule().condition((allTypes("actionableMode", "iconsplitbutton"))).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(mark("option").multiple("\",\"")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_option(\"")).output(mark("default")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_icon(\"")).output(mark("icon")).output(literal("\");"))),
				rule().condition((allTypes("actionableMode", "materialiconsplitbutton"))).output(expression().output(literal("_options(java.util.Arrays.asList(\"")).output(mark("option").multiple("\",\"")).output(literal("\"));"))).output(literal("\n")).output(expression().output(literal("_option(\"")).output(mark("default")).output(literal("\");"))).output(literal("\n")).output(expression().output(literal("_icon(\"")).output(mark("icon")).output(literal("\");"))),
				rule().condition((allTypes("actionableMode", "iconbutton"))).output(literal("_icon(\"")).output(mark("icon")).output(literal("\");")),
				rule().condition((allTypes("actionableMode", "icontoggle"))).output(literal("_icon(\"")).output(mark("icon")).output(literal("\");")),
				rule().condition((allTypes("actionableMode", "materialiconbutton"))).output(literal("_icon(\"")).output(mark("icon")).output(literal("\");")),
				rule().condition((allTypes("actionableMode", "materialicontoggle"))).output(literal("_icon(\"")).output(mark("icon")).output(literal("\");")),
				rule().condition((type("badge"))).output(expression().output(literal("_value(")).output(mark("value")).output(literal(");"))),
				rule().condition((type("drawer"))),
				rule().condition((type("popover"))),
				rule().condition((type("selectionMethod"))).output(literal("public void onSelect(io.intino.alexandria.ui.displays.events.SelectionListener listener) {\n\tsuper.addSelectionListener(listener);\n}")),
				rule().condition((type("editableMethods"))).output(literal("public void onAdd(io.intino.alexandria.ui.displays.events.editable.AddItemListener listener) {\n\tsuper.addItemListener(listener);\n}\npublic void onChange(io.intino.alexandria.ui.displays.events.editable.ChangeItemListener listener) {\n\tsuper.changeItemListener(listener);\n}\npublic void onRemove(io.intino.alexandria.ui.displays.events.editable.RemoveItemListener listener) {\n\tsuper.removeItemListener(listener);\n}")),
				rule().condition((type("editableClass"))).output(literal("public class ")).output(mark("componentName")).output(literal(" extends ")).output(mark("componentType")).output(literal(" {\n\tpublic ")).output(mark("componentName")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\t")).output(expression().output(mark("componentProperties", "common"))).output(literal("\n\t\t")).output(expression().output(mark("componentProperties", "specific"))).output(literal("\n\t}\n}")),
				rule().condition((type("item")), (trigger("adddeclaration"))).output(mark("name")).output(literal("(add")).output(mark("name", "firstUpperCase")).output(literal("(new ")).output(mark("name", "firstUpperCase")).output(literal("(box())")).output(expression().output(literal(", ")).output(mark("itemVariable"))).output(literal("))")),
				rule().condition((type("item")), (trigger("type"))).output(mark("name", "firstUpperCase")),
				rule().condition((type("item")), (trigger("addrow"))).output(mark("name")).output(literal(" = register(add")).output(mark("name", "firstUpperCase")).output(literal("(box()));")),
				rule().condition((type("item")), (trigger("property"))).output(literal("public ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("name")).output(literal(";")),
				rule().condition((type("item")), (trigger("addmethod"))).output(mark("methodAccessibility")).output(literal(" ")).output(mark("name", "firstUpperCase")).output(literal(" create")).output(mark("methodName", "firstUpperCase")).output(literal("(")).output(expression().output(mark("itemClass")).output(literal(" element"))).output(literal(") {\n\t")).output(mark("name", "firstUpperCase")).output(literal(" result = new ")).output(mark("name", "firstUpperCase")).output(literal("(")).output(expression().output(literal("(")).output(mark("concreteBox", "firstUpperCase")).output(literal("Box)"))).output(literal("box());\n\tresult.id(java.util.UUID.randomUUID().toString());\n\t")).output(expression().output(literal("result.item(")).output(mark("itemVariable")).output(literal(");"))).output(literal("\n\treturn result;\n}")),
				rule().condition((allTypes("itemClass", "map"))).output(literal("io.intino.alexandria.ui.model.PlaceMark<")).output(mark("value")).output(literal(">")),
				rule().condition((type("itemClass"))).output(mark("value")),
				rule().condition((allTypes("itemVariable", "map"))).output(literal("element.item()")),
				rule().condition((type("itemVariable"))).output(literal("element")),
				rule().condition((allTypes("useUrl", "custom"))).output(literal("box().configuration().get(\"")).output(mark("value")).output(literal("\")")),
				rule().condition((type("column"))).output(literal("_add(new io.intino.alexandria.ui.model.datasource.grid.GridColumn<")).output(mark("itemClass")).output(literal(">().name(\"")).output(mark("name")).output(literal("\").label(\"")).output(mark("label")).output(literal("\").type(io.intino.alexandria.ui.model.datasource.grid.GridColumn.Type.")).output(mark("type")).output(literal(")")).output(expression().output(literal(".width(")).output(mark("width")).output(literal(")"))).output(expression().output(literal(".sortable(")).output(mark("sortable")).output(literal(")"))).output(expression().output(literal(".address(\"")).output(mark("address")).output(literal("\")"))).output(expression().output(literal(".fixed(")).output(mark("fixed")).output(literal(")"))).output(expression().output(literal(".pattern(\"")).output(mark("pattern")).output(literal("\")"))).output(literal(");")),
				rule().condition((type("useUrl"))).output(literal("\"")).output(mark("value")).output(literal("\""))
		);
	}
}