package io.intino.konos.builder.codegeneration.services.ui.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class AbstractDesktopSkeletonTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((type("desktop"))).output(literal("package ")).output(mark("package")).output(literal(".ui.displays.desktops;\n\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.exceptions.*;\nimport io.intino.alexandria.ui.displays.components.*;\nimport ")).output(mark("package")).output(literal(".ui.*;\n")).output(mark("schemaImport")).output(literal("\nimport ")).output(mark("package", "validPackage")).output(literal(".")).output(mark("box", "firstUpperCase")).output(literal("Box;")).output(expression().output(literal("\n")).output(literal("import ")).output(mark("package", "validPackage")).output(literal(".ui.displays.desktops.")).output(mark("abstract")).output(mark("name", "firstUpperCase")).output(literal(";"))).output(literal("\n\n")).output(mark("templatesImport")).output(literal("\n")).output(mark("blocksImport")).output(literal("\n")).output(mark("itemsImport")).output(literal("\n")).output(mark("rowsImport")).output(literal("\nimport ")).output(mark("package", "validPackage")).output(literal(".ui.displays.notifiers.")).output(mark("name", "firstUpperCase")).output(literal("Notifier;\n\npublic class ")).output(expression().output(mark("abstract"))).output(mark("name", "firstUpperCase")).output(mark("parametrized")).output(literal(" extends io.intino.alexandria.ui.displays.")).output(mark("type", "firstUpperCase")).output(literal("<")).output(mark("name", "firstUpperCase")).output(literal("Notifier, ")).output(mark("abstractBox", "type")).output(literal("> {\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("Header header;\n\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("Tabs tabs;\n\n\tpublic ")).output(expression().output(mark("abstract"))).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\tid(\"")).output(mark("id")).output(literal("\");\n\t}\n\n\t@Override\n\tpublic void init() {\n\t\tsuper.init();\n\t\theader = register(new ")).output(mark("name", "firstUpperCase")).output(literal("Header<>(box()).id(\"")).output(mark("headerId")).output(literal("\"));\n\t\ttabs = register(new ")).output(mark("name", "firstUpperCase")).output(literal("Tabs<>(box()).id(\"")).output(mark("tabBarId")).output(literal("\"));\n\t}\n\n\tpublic class ")).output(mark("name", "firstUpperCase")).output(literal("Header")).output(expression().output(literal("<")).output(mark("abstractBox", "extension")).output(literal(">"))).output(literal(" extends io.intino.alexandria.ui.displays.components.Header<")).output(mark("abstractBox", "type")).output(literal("> {\n\t\t")).output(expression().output(mark("attribute").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "declarations").multiple("\n"))).output(literal("\n\n\t\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("Header(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\t\tsuper(box);\n\t\t}\n\n\t\t@Override\n\t\tpublic void init() {\n\t\t\tsuper.init();\n\t\t\t")).output(mark("componentReferences")).output(literal("\n\t\t\t")).output(expression().output(mark("component", "initializations").multiple("\n"))).output(literal("\n\t\t}\n\n\t\t@Override\n\t\tpublic void remove() {\n\t\t\tsuper.remove();\n\t\t\t")).output(expression().output(mark("component", "unregister").multiple("\n"))).output(literal("\n\t\t}\n\t\t")).output(expression().output(mark("component", "class").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("component", "method").multiple("\n"))).output(literal("\n\t}\n\n\tpublic class ")).output(mark("name", "firstUpperCase")).output(literal("Tabs")).output(expression().output(literal("<")).output(mark("abstractBox", "extension")).output(literal(">"))).output(literal(" extends io.intino.alexandria.ui.displays.components.Tabs<")).output(mark("abstractBox", "type")).output(literal("> {\n\t\tpublic ")).output(mark("name", "firstUpperCase")).output(literal("Tabs(")).output(mark("abstractBox", "type")).output(literal(" box) {\n\t\t\tsuper(box);\n\t\t\t")).output(mark("tabs").multiple("\n")).output(literal("\n\t\t}\n\t}\n}")),
				rule().condition((type("templatesImports"))).output(literal("import ")).output(mark("package", "validPackage")).output(literal(".ui.displays.templates.*;")),
				rule().condition((type("blocksImport"))).output(literal("import ")).output(mark("package", "validPackage")).output(literal(".ui.displays.blocks.*;")),
				rule().condition((type("itemsImport"))).output(literal("import ")).output(mark("package", "validPackage")).output(literal(".ui.displays.items.*;")),
				rule().condition((type("rowsImport"))).output(literal("import ")).output(mark("package", "validPackage")).output(literal(".ui.displays.rows.*;")),
				rule().condition((allTypes("componentReferences", "forRoot"))).output(mark("component", "rootReferences").multiple("\n")),
				rule().condition((type("componentReferences"))).output(mark("component", "references").multiple("\n")),
				rule().condition((type("attribute"))).output(literal("public ")).output(mark("clazz")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal(";"))
		);
	}
}