package io.intino.konos.builder.codegeneration.services.rest;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class RestResourceTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((type("notification"))).output(literal("package ")).output(mark("package")).output(literal(".rest.notifications;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport io.intino.alexandria.exceptions.*;\nimport ")).output(mark("package")).output(literal(".*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.rest.Resource;\nimport io.intino.alexandria.http.pushservice.Client;\nimport io.intino.alexandria.http.pushservice.Session;\nimport io.intino.alexandria.http.pushservice.MessageCarrier;\nimport io.intino.alexandria.http.spark.SparkManager;\nimport io.intino.alexandria.http.spark.SparkNotifier;\nimport io.intino.alexandria.http.spark.SparkPushService;\n\n")).output(mark("schemaImport")).output(literal("\n\npublic class ")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Notification implements Resource {\n\n\tprivate ")).output(mark("box", "FirstUpperCase")).output(literal("Box box;\n\tprivate SparkManager<?> manager;\n\n\tpublic ")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Notification(")).output(mark("box", "FirstUpperCase")).output(literal("Box box, SparkManager manager) {\n\t\tthis.box = box;\n\t\tthis.manager = manager;\n\t}\n\n\tpublic void execute() ")).output(expression().output(literal("throws ")).output(mark("throws").multiple(", "))).output(literal(" {\n\t\tSession session = manager.currentSession();\n\t\tString clientId = java.util.UUID.randomUUID().toString();\n\t\t")).output(mark("package", "validPackage")).output(literal(".actions.")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Action action = fill(new ")).output(mark("package", "validPackage")).output(literal(".actions.")).output(mark("name", "firstUpperCase")).output(literal("Action());\n\t\tmanager.pushService().onOpen(client -> {\n\t\t\taction.onOpen((Client)client, notifier(session, (Client)client));\n\t\t\treturn true;\n\t\t});\n\t\tmanager.pushService().onClose(clientId).execute((java.util.function.Consumer<Client>) action::onClose);\n\t\t")).output(expression().output(mark("returnType", "methodCall"))).output(literal("manager.baseUrl().replace(\"http\", \"ws\") + \"/_alexandria/push?id=\" + clientId")).output(expression().output(mark("returnType", "ending"))).output(literal(";\n\t}\n\n\tprivate ")).output(mark("package", "validPackage")).output(literal(".actions.")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Action fill(")).output(mark("package", "validPackage")).output(literal(".actions.")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Action action) {\n\t\taction.box = this.box;\n\t\taction.context = context();\n\t\t")).output(expression().output(mark("parameter", "assign").multiple("\n"))).output(literal("\n\t\treturn action;\n\t}\n\n\t")).output(expression().output(mark("returnType", "method"))).output(literal("\n\n\tprivate SparkNotifier notifier(Session session, Client client) {\n\t\treturn new SparkNotifier(new MessageCarrier(manager.pushService(), session, client));\n\t}\n\n\tprivate io.intino.alexandria.http.spark.SparkContext context() {\n\t\tio.intino.alexandria.http.spark.SparkContext context = new io.intino.alexandria.http.spark.SparkContext(manager);\n\t\t")).output(expression().output(mark("authenticationValidator", "put"))).output(literal("\n\t\tcontext.put(\"ip\", manager.ip());\n\t\treturn context;\n\t}\n}\n\n")),
				rule().condition((type("resource"))).output(literal("package ")).output(mark("package")).output(literal(".rest.resources;\n\nimport java.util.List;\nimport java.util.Set;\nimport java.util.ArrayList;\nimport io.intino.alexandria.exceptions.*;\nimport ")).output(mark("package")).output(literal(".*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.rest.*;\nimport io.intino.alexandria.http.spark.SparkManager;\nimport io.intino.alexandria.http.spark.SparkPushService;\n\n")).output(mark("schemaImport")).output(literal("\n\npublic class ")).output(mark("operation", "firstUpperCase")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Resource implements Resource {\n\t")).output(expression().output(mark("word", "declaration").multiple("\n"))).output(literal("\n\n\tprivate ")).output(mark("box", "FirstUpperCase")).output(literal("Box box;\n\tprivate SparkManager<SparkPushService> manager;\n\n\tpublic ")).output(mark("operation", "firstUpperCase")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Resource(")).output(mark("box", "FirstUpperCase")).output(literal("Box box, SparkManager manager) {\n\t\tthis.box = box;\n\t\tthis.manager = manager;\n\t}\n\n\tpublic void execute() throws AlexandriaException {\n\t\t")).output(expression().output(mark("returnType", "methodCall"))).output(literal("fill(new ")).output(mark("package", "validPackage")).output(literal(".actions.")).output(mark("operation", "firstUpperCase")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Action()).execute()")).output(expression().output(mark("returnType", "ending"))).output(literal(";\n\t}\n\n\tprivate ")).output(mark("package", "validPackage")).output(literal(".actions.")).output(mark("operation", "firstUpperCase")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Action fill(")).output(mark("package", "validPackage")).output(literal(".actions.")).output(mark("operation", "firstUpperCase")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("Action action) throws AlexandriaException {\n\t\taction.box = this.box;\n\t\taction.context = context();\n\t\ttry {\n\t\t\t")).output(expression().output(mark("parameter", "assign").multiple("\n"))).output(literal("\n\t\t} catch (Throwable e) {\n\t\t\taction.onMalformedRequest(e);\n\t\t}\n\t\treturn action;\n\t}\n\n\t")).output(expression().output(mark("returnType", "method"))).output(literal("\n\n\tprivate io.intino.alexandria.http.spark.SparkContext context() {\n\t\tio.intino.alexandria.http.spark.SparkContext context = new io.intino.alexandria.http.spark.SparkContext(manager);\n\t\t")).output(mark("authenticationValidator", "put")).output(literal("\n\t\tcontext.put(\"ip\", manager.ip());\n\t\treturn context;\n\t}\n}")),
				rule().condition((type("word")), (trigger("declaration"))).output(literal("public enum ")).output(mark("name", "SnakeCaseToCamelCase", "FirstUpperCase")).output(literal(" {\n\t")).output(mark("words").multiple(", ")).output(literal(";\n}")),
				rule().condition((attribute("void")), (trigger("methodcall"))),
				rule().condition((type("redirect")), (trigger("methodcall"))).output(literal("redirect(")),
				rule().condition((type("response")), (trigger("methodcall"))).output(literal("write(")),
				rule().condition((attribute("void")), (trigger("ending"))),
				rule().condition((trigger("ending"))).output(literal(")")),
				rule().condition((attribute("void")), (trigger("write"))),
				rule().condition((type("redirect")), (trigger("method"))).output(literal("private void redirect(String url) {\n\tmanager.redirect(url);\n}")),
				rule().condition((allTypes("response", "multipart")), (trigger("method"))).output(literal("private void write(")).output(mark("value", "firstUpperCase", "ReturnTypeFormatter")).output(literal(" object) {\n\tmanager.write(object.content());\n}")),
				rule().condition((allTypes("response", "file")), (trigger("method"))).output(literal("private void write(")).output(mark("value", "firstUpperCase", "ReturnTypeFormatter")).output(literal(" object) {\n\tmanager.write(object);\n}")),
				rule().condition((type("response")), (trigger("method"))).output(literal("private void write(")).output(mark("value", "firstUpperCase", "ReturnTypeFormatter")).output(literal(" object) {\n\tmanager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object)")).output(expression().output(literal(", \"")).output(mark("format")).output(literal("\""))).output(literal(");\n}")),
				rule().condition((type("parameter")), (trigger("type"))).output(mark("parameterType")),
				rule().condition((allTypes("parameter", "defaultvalue")), (attribute("in", "body")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(mark("in", "firstUpperCase")).output(literal("OrDefault(\"")).output(mark("defaultValue")).output(literal("\"), ")).output(mark("parameterType")).output(literal(");")),
				rule().condition((allTypes("parameter", "defaultvalue")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(mark("in", "firstUpperCase")).output(literal("OrDefault(\"")).output(mark("name")).output(literal("\", \"")).output(mark("defaultValue")).output(literal("\"), ")).output(mark("parameterType")).output(literal(");")),
				rule().condition((allTypes("parameter", "file", "list")), (attribute("in", "form")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = manager.fromPartsAsResources();")),
				rule().condition((allTypes("parameter", "file")), (attribute("in", "form")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = manager.from")).output(mark("in", "firstUpperCase")).output(literal("AsResource(\"")).output(mark("name")).output(literal("\");")),
				rule().condition((allTypes("parameter", "required", "file")), (attribute("in", "form")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = manager.from")).output(mark("in", "firstUpperCase")).output(literal("AsResourceOrElseThrow(\"")).output(mark("name")).output(literal("\", () -> new BadRequest(\"Parameter missed: ")).output(mark("name")).output(literal("\"));")),
				rule().condition((type("parameter")), (attribute("in", "form")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(mark("in", "firstUpperCase")).output(literal("AsString(\"")).output(mark("name")).output(literal("\"), ")).output(mark("parameterType")).output(literal(");")),
				rule().condition((allTypes("parameter", "required")), (attribute("in", "form")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(mark("in", "firstUpperCase")).output(literal("AsStringOrElseThrow(\"")).output(mark("name")).output(literal("\", () -> new BadRequest(\"Parameter missed: ")).output(mark("name")).output(literal("\")), ")).output(mark("parameterType")).output(literal(");")),
				rule().condition((allTypes("parameter", "file")), (attribute("in", "body")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = new io.intino.alexandria.Resource(\"")).output(mark("name")).output(literal("\", manager.fromBodyAsBytes());")),
				rule().condition((type("parameter")), (attribute("in", "body")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(mark("in", "firstUpperCase")).output(literal("(), ")).output(mark("parameterType")).output(literal(");")),
				rule().condition((allTypes("parameter", "required")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(mark("in", "firstUpperCase")).output(literal("OrElseThrow(\"")).output(mark("name")).output(literal("\", () -> new BadRequest(\"Parameter missed: ")).output(mark("name")).output(literal("\")), ")).output(mark("parameterType")).output(literal(");")),
				rule().condition((type("parameter")), (trigger("assign"))).output(literal("action.")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(mark("in", "firstUpperCase")).output(literal("(\"")).output(mark("name")).output(literal("\"), ")).output(mark("parameterType")).output(literal(");")),
				rule().condition((type("list")), (trigger("parametertype"))).output(literal("new com.google.gson.reflect.TypeToken<java.util.List<")).output(mark("value")).output(literal(">>(){}.getType()")),
				rule().condition((allTypes("authenticationValidator", "Custom")), (trigger("put"))),
				rule().condition((type("authenticationValidator")), (trigger("put"))).output(literal("context.put(\"Authorization\", manager.fromHeader(\"Authorization\") != null ? manager.fromHeader(\"Authorization\").replace(\"")).output(mark("type")).output(literal(" \", \"\") : null);")),
				rule().condition((trigger("parametertype"))).output(mark("value")).output(literal(".class")),
				rule().condition((type("schemaImport"))).output(literal("import ")).output(mark("package")).output(literal(".schemas.*;"))
		);
	}
}