package io.intino.konos.builder.codegeneration.services.jmx;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class JMXServerTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((type("jmxserver"))).output(literal("package ")).output(mark("package", "ValidPackage")).output(literal(";\n\nimport io.intino.alexandria.jmx.JMXServer;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.core.Box;\nimport java.util.HashMap;\nimport java.util.Map;\n\npublic class JMX")).output(mark("name", "firstUpperCase")).output(literal(" {\n\n\tpublic JMXServer init(Box box) {\n\t\tJMXServer server = new JMXServer(mbClasses(box));\n\t\tserver.init(\"intino")).output(expression().output(literal(".")).output(mark("path"))).output(literal("\");\n\t\treturn server;\n\t}\n\n\tprivate Map<String, Object[]> mbClasses(Box box) {\n\t\tMap<String, Object[]> map = new HashMap<>();\n\t\tmap.put(\"")).output(mark("package")).output(literal(".jmx.")).output(mark("name", "snakecaseToCamelCase", "firstUpperCase")).output(literal("\", new Object[]{box});\n\t\treturn map;\n\t}\n}")),
				rule().condition((type("jmx")), (type("interface"))).output(literal("package ")).output(mark("package", "ValidPackage")).output(literal(".jmx;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.jmx.Description;\nimport io.intino.alexandria.jmx.Parameters;\n\nimport java.util.*;\nimport java.time.*;\n\npublic interface ")).output(mark("name", "snakecaseToCamelCase", "firstUpperCase")).output(literal("MBean {\n\n\t@Description(\"Shows information about the available operations\")\n\t@Parameters({})\n\tjava.util.List<String> help();\n\n\t")).output(mark("operation", "signature").multiple("\n\n")).output(literal("\n}")),
				rule().condition((type("operation")), (trigger("signature"))).output(literal("@Description(\"")).output(mark("description")).output(literal("\")\n@Parameters({")).output(mark("parameter", "displayName").multiple(", ")).output(literal("})\n")).output(mark("returnType")).output(literal(" ")).output(mark("name", "SnakeCaseToCamelCase", "firstLowerCase")).output(literal("(")).output(mark("parameter", "withType").multiple(", ")).output(literal(");")),
				rule().condition((type("parameter")), (trigger("displayname"))).output(literal("\"")).output(mark("name")).output(literal("\"")),
				rule().condition((allTypes("parameter", "list")), (trigger("withtype"))).output(literal("java.util.List<")).output(mark("type")).output(literal("> ")).output(mark("name")),
				rule().condition((type("parameter")), (trigger("withtype"))).output(mark("type")).output(literal(" ")).output(mark("name")),
				rule().condition((type("jmx")), (type("implementation"))).output(literal("package ")).output(mark("package", "ValidPackage")).output(literal(".jmx;\n\nimport io.intino.alexandria.logger.Logger;\nimport ")).output(mark("package")).output(literal(".")).output(mark("box", "validName", "FirstUpperCase")).output(literal("Box;\nimport java.util.*;\nimport java.time.*;\n\npublic class ")).output(mark("name", "SnakeCaseToCamelCase", "validName", "firstUpperCase")).output(literal(" implements ")).output(mark("name", "validName", "firstUpperCase")).output(literal("MBean {\n\n\tprivate final ")).output(mark("box", "validName", "FirstUpperCase")).output(literal("Box box;\n\n\tpublic java.util.List<String> help() {\n\t\tList<String> operations = new ArrayList<>();\n\t\toperations.addAll(java.util.Arrays.asList(new String[]{")).output(mark("operation", "help").multiple(", ")).output(literal("}));\n\t\treturn operations;\n\t}\n\n\tpublic ")).output(mark("name", "validName", "firstUpperCase")).output(literal("(")).output(mark("box", "validName", "FirstUpperCase")).output(literal("Box box) {\n\t\tthis.box = box;\n\t}\n\n\t")).output(mark("operation", "implementation").multiple("\n\n")).output(literal("\n}")),
				rule().condition((type("operation")), (trigger("implementation"))).output(literal("public ")).output(mark("returnType")).output(literal(" ")).output(mark("name", "SnakeCaseToCamelCase", "validName", "firstLowerCase")).output(literal("(")).output(mark("parameter", "withType").multiple(", ")).output(literal(") {\n\ttry {\n\t")).output(mark("package", "ValidPackage")).output(literal(".actions.")).output(mark("action", "snakecaseToCamelCase", "firstUpperCase")).output(literal("Action action = new ")).output(mark("package", "ValidPackage")).output(literal(".actions.")).output(mark("action", "SnakeCaseToCamelCase", "firstUpperCase")).output(literal("Action();\n\taction.box = box;\n\t")).output(expression().output(mark("parameter", "assign").multiple("\n"))).output(literal("\n\t")).output(expression().output(mark("returnType", "return")).output(literal(" "))).output(literal("action.execute();\n\t} catch (Throwable e) {\n\t\tLogger.error(e);\n\t\tthrow e;\n\t}\n}")),
				rule().condition((type("operation")), (trigger("help"))).output(literal("\"")).output(mark("returnType")).output(literal(" ")).output(mark("name", "SnakeCaseToCamelCase", "validName", "firstLowerCase")).output(literal("(")).output(mark("parameter", "withType").multiple(", ")).output(literal(")")).output(expression().output(literal(": ")).output(mark("description"))).output(literal("\"")),
				rule().condition((type("parameter")), (trigger("assign"))).output(literal("action.")).output(mark("name")).output(literal(" = ")).output(mark("name")).output(literal(";")),
				rule().condition((type("returnType")), (attribute("value", "void")), (trigger("return"))),
				rule().condition((type("returnType")), (trigger("return"))).output(literal("return")),
				rule().condition((allTypes("returnType", "list")), (trigger("returntype"))).output(literal("java.util.List<")).output(mark("value")).output(literal(">")),
				rule().condition((type("returnType")), (trigger("returntype"))).output(mark("value")),
				rule().condition((trigger("quoted"))).output(literal("\"")).output(mark("value")).output(literal("\""))
		);
	}
}