package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class VirtualCubeTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("cube", "src"))).output(literal("package ")).output(mark("package")).output(literal(".analytic.cubes;\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.led.buffers.store.ByteStore;\n\nimport ")).output(mark("package")).output(literal(".analytic.Axis;\nimport ")).output(mark("package")).output(literal(".analytic.axes.*;\n\nimport java.io.File;\nimport java.util.*;\nimport java.util.stream.Collectors;\nimport java.util.function.Predicate;\n\npublic class ")).output(mark("name", "FirstUpperCase")).output(literal(" extends Abstract")).output(mark("name", "FirstUpperCase")).output(literal(" {\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("(List<Loader> loaders) {\n\t\tsuper(loaders);\n\t}\n\n\tpublic static long ")).output(mark("name", "firstLowerCase")).output(literal("Id(")).output(mark("name", "FirstUpperCase")).output(literal(".Fact fact) {\n\t\treturn fact.id();//TODO\n\t}\n\n\t")).output(expression().output(mark("customDimension", "staticMethod").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("customFilter", "staticMethod").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("customIndicator", "staticMethod").multiple("\n\n"))).output(literal("\n\n\t@Override\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal(" execute() {\n\t\tsuper.execute();\n\t\treturn this;\n\t}\n\n\tpublic static long idOf(")).output(mark("mainCube", "idOf")).output(literal(") {\n\t\treturn ")).output(mark("mainCube")).output(literal(".id(); //TODO\n\t}\n\n\tpublic static class Loader extends Abstract")).output(mark("name", "FirstUpperCase")).output(literal(".Loader {\n\n\t\tpublic static List<Loader> create(File root, Timetag from, Timetag to, Collection<String> divisions) {\n\t\t\treturn divisions.stream().map(d -> new Loader(new Loader.Datasource(root, from, to), d)).collect(Collectors.toList());\n\t\t}\n\n\n\t\tpublic Loader(Datasource datasource")).output(expression().output(literal(", ")).output(mark("split", "parameter"))).output(literal(") {\n\t\t\tsuper(datasource")).output(expression().output(literal(", ")).output(mark("split", "name"))).output(literal(");\n\t\t}\n\n\t\t// TODO write here a cache if necessary\n\t}\n\n\tpublic static class Aggregation extends Abstract")).output(mark("name", "FirstUpperCase")).output(literal(".AbstractAggregation {\n\n\t\tpublic Aggregation(Timetag timetag, List<Axis.Component> components, Map<Axis, Predicate<Fact>> filters) {\n\t\t\tsuper(timetag, components, filters);\n\t\t}\n\n\t\t")).output(expression().output(mark("customIndicator", "implementation").multiple("\n\n"))).output(literal("\n\t}\n}")),
				rule().condition((trigger("idof"))).output(mark("", "FirstUpperCase")).output(literal(".Fact ")).output(mark("", "firstLowerCase")),
				rule().condition((type("cube"))).output(literal("package ")).output(mark("package")).output(literal(".analytic.cubes;\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.led.LedReader;\nimport io.intino.alexandria.led.LedStream;\nimport io.intino.alexandria.led.Schema;\nimport io.intino.alexandria.led.buffers.store.ByteStore;\nimport io.intino.alexandria.led.util.iterators.MergedIterator;\nimport io.intino.alexandria.led.util.iterators.StatefulIterator;\nimport io.intino.alexandria.led.util.collections.SparseLongList;\n\nimport ")).output(mark("package")).output(literal(".analytic.axes.*;\nimport ")).output(mark("package")).output(literal(".analytic.Axis;\n\nimport java.io.File;\nimport java.util.*;\nimport java.util.stream.Collectors;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.stream.Stream;\nimport java.util.stream.StreamSupport;\n\nimport static java.util.Comparator.comparingLong;\nimport static java.util.Spliterators.spliteratorUnknownSize;\nimport ")).output(mark("package")).output(literal(".analytic.cubes.")).output(mark("name", "FirstUpperCase")).output(literal(".Aggregation;\n\npublic abstract class Abstract")).output(mark("name", "FirstUpperCase")).output(literal(" implements Iterable<")).output(mark("name", "FirstUpperCase")).output(literal(".Aggregation> {\n\n\tpublic static final Fact NULL_FACT = new NullFact();\n\n\tprivate final List<? extends Loader> loaders;\n\tprivate Predicate<Fact> filter = fact -> true;\n\tprivate final List<Axis> axes = new ArrayList<>();\n\tprivate final Map<Axis, Set<Axis.Component>> components = new HashMap<>();\n\tprivate final List<Function<Fact, ? extends Axis.Component>> groupByList = new ArrayList<>();\n\tprivate final Map<Axis, Predicate<Fact>> filters = new LinkedHashMap<>();\n\tprivate Aggregation[] result;\n\n\tpublic Abstract")).output(mark("name", "FirstUpperCase")).output(literal("(List<? extends Loader> loaders) {\n\t\tthis.loaders = loaders;\n\t}\n\n\t")).output(expression().output(mark("dimension", "method").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("customDimension", "method").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("customFilter", "method").multiple("\n\n"))).output(literal("\n\n\tpublic Abstract")).output(mark("name", "FirstUpperCase")).output(literal(" groupBy(Axis axis) {\n\t\tif(axis == null) throw new NullPointerException(\"Axis cannot be null\");\n\t\tswitch(axis.getTitle()) {\n\t\t\t")).output(expression().output(mark("dimension", "switchCaseGroupBy").multiple("\n"))).output(literal("\n\t\t}\n\t\treturn this;\n\t}\n\n\t@SuppressWarnings(\"unchecked\")\n\tpublic Abstract")).output(mark("name", "FirstUpperCase")).output(literal(" filter(Axis axis, Set<? extends Axis.Component> components) {\n\t\tif(axis == null) throw new NullPointerException(\"Axis cannot be null\");\n\t\tswitch(axis.getTitle()) {\n\t\t\t")).output(expression().output(mark("dimension", "switchCaseFilterBy").multiple("\n"))).output(literal("\n\t\t}\n\t\treturn this;\n\t}\n\n\tpublic Abstract")).output(mark("name", "firstUpperCase")).output(literal(" execute() {\n\t\tresult = new Aggregation[resultsSize()];\n\t\tresults().forEach(this::append);\n\t\tfillCategories();\n\t\tcalculateTotals();\n\n\t\treturn this;\n\t}\n\n\tpublic Aggregation[] result() {\n\t\tif(result == null) return new Aggregation[0];\n\t\treturn Arrays.stream(result).filter(java.util.Objects::nonNull).toArray(Aggregation[]::new);\n\t}\n\n\t@Override\n\tpublic Iterator<Aggregation> iterator() {\n\t\treturn result == null\n\t\t\t? Stream.<Aggregation>empty().iterator()\n\t\t\t: Arrays.stream(result).filter(java.util.Objects::nonNull).iterator();\n\t}\n\n\tpublic static List<Axis> dimensions() {\n\t\treturn List.of(")).output(expression().output(mark("dimension", "getInstance").multiple(", "))).output(literal(");\n\t}\n\n\tpublic boolean contains(Axis axis, Axis.Component component) {\n\t\tif(!components.containsKey(axis)) return false;\n\t\treturn components.get(axis).contains(component);\n\t}\n\n\tpublic Iterator<Fact> detail() {\n\t\tMergedIterator<Fact> iterator = new MergedIterator<>(loaders.stream().map(Iterable::iterator), comparingLong(Fact::id));\n\t\treturn StreamSupport.stream(spliteratorUnknownSize(iterator, Spliterator.SORTED), false).filter(this::check).iterator();\n\t}\n\n\tpublic Aggregation aggregation(List<Axis.Component> components) {\n\t\tif(result == null || result.length == 0) return null;\n\t\tfinal int index = indexOf(components);\n\t\treturn result[index];\n\t}\n\n\tpublic Aggregation aggregation(Axis.Component... components) {\n\t\tif(result == null || result.length == 0) return null;\n\t\tfinal int index = indexOf(components);\n\t\treturn result[index];\n\t}\n\n\tprivate void fillCategories() {\n\t\tfor (Aggregation aggregation : result) {\n\t\t\tif (aggregation == null) continue;\n\t\t\tList<Axis.Component> components = aggregation.components();\n\t\t\tfor (int i = 0; i < components.size(); i++)\n\t\t\t\tthis.components.get(axes.get(i)).add(components.get(i));\n\t\t}\n\t}\n\n\tprivate void calculateTotals() {\n\t\tfor (Loader loader : loaders) {\n\t\t\tif(loader.axes().size() != axes.size()) return;\n\t\t\tfor (int i = 0; i < loader.totals().length; i++) {\n\t\t\t\tif (result[i] == null) continue;\n\t\t\t\tresult[i].append(loader.totals()[i]);\n\t\t\t}\n\t\t}\n\t}\n\n\tprivate int resultsSize() {\n\t\tint accumulator = 1;\n\t\tfor (Axis axis : axes) accumulator *= axis.getSize() + 1;\n\t\treturn accumulator;\n\t}\n\n\tprivate Stream<Aggregation[]> results() {\n\t\treturn loaders.parallelStream().map(this::results);\n\t}\n\n\tprivate Aggregation[] results(Iterable<Fact> facts) {\n\t\tAggregation[] result = new Aggregation[resultsSize()];\n\t\tfor (Fact fact : facts) {\n\t\t\tfact.setCube(this);\n\t\t\tif (!check(fact)) continue;\n\t\t\tAxis.Component[] components = componentsOf(fact);\n\t\t\tint index = indexOf(components);\n\t\t\tif (result[index] == null) result[index] = new Aggregation(fact.timetag(), Arrays.asList(components), filters);\n\t\t\tresult[index].append(fact);\n\t\t}\n\t\treturn result;\n\t}\n\n\tprivate synchronized void append(Aggregation[] results) {\n\t\tfor (int i = 0; i < results.length; i++) {\n\t\t\tif (results[i] == null) continue;\n\t\t\tif (result[i] == null) result[i] = results[i];\n\t\t\telse result[i].append(results[i]);\n\t\t}\n\t}\n\n\tprivate int indexOf(Axis.Component[] components) {\n\t\tint index = 0;\n\t\tfor (int i = 0; i < components.length; i++) {\n\t\t\tindex *= axes.get(i).getSize();\n\t\t\tindex += components[i].index();\n\t\t}\n\t\treturn index;\n\t}\n\n\tprivate int indexOf(List<Axis.Component> components) {\n\t\tint index = 0;\n\t\tfor (int i = 0; i < components.size(); i++) {\n\t\t\tindex *= axes.get(i).getSize();\n\t\t\tindex += components.get(i).index();\n\t\t}\n\t\treturn index;\n\t}\n\n\tprivate boolean check(Fact item) {\n\t\treturn filter.test(item);\n\t}\n\n\tprivate Axis.Component[] componentsOf(Fact item) {\n\t\tAxis.Component[] components = new Axis.Component[groupByList.size()];\n\t\tfor (int i = 0; i < components.length; i++) components[i] = groupByList.get(i).apply(item);\n\t\treturn components;\n\t}\n\n\tpublic static class Fact {\n\n\t\t")).output(expression().output(mark("cube", "fieldFact").multiple("\n"))).output(literal("\n\n\t\tprivate Abstract")).output(mark("name", "firstUpperCase")).output(literal(" cube;\n\n\t\tpublic Fact(")).output(mark("cube", "factParameter").multiple(", ")).output(literal(") {\n\t\t\t")).output(mark("cube", "assignFact").multiple("\n")).output(literal("\n\t\t}\n\n\t\tpublic ")).output(mark("mainCube", "firstUpperCase")).output(literal(".Fact ")).output(mark("mainCube", "firstLowerCase")).output(literal("() {\n\t\t\treturn ")).output(mark("mainCube", "firstLowerCase")).output(literal(";\n\t\t}\n\n\t\tpublic ")).output(mark("joinCube", "firstUpperCase")).output(literal(".Fact ")).output(mark("joinCube", "firstLowerCase")).output(literal("() {\n\t\t\treturn ")).output(mark("joinCube", "firstLowerCase")).output(literal(";\n\t\t}\n\n\t\tpublic Abstract")).output(mark("name", "firstUpperCase")).output(literal(" cube() {\n\t\t\treturn cube;\n\t\t}\n\n\t\tpublic Timetag timetag() {\n\t\t\treturn ")).output(mark("joinCube", "firstLowerCase")).output(literal(".timetag();\n\t\t}\n\n\t\tpublic long id() {\n\t\t\treturn ")).output(mark("mainCube", "firstLowerCase")).output(literal(".id();\n\t\t}\n\n\t\t")).output(expression().output(mark("column", "factGetter").multiple("\n\n"))).output(literal("\n\n\t\t")).output(expression().output(mark("virtualColumn", "factGetter").multiple("\n\n"))).output(literal("\n\n\t\tvoid setCube(Abstract")).output(mark("name", "firstUpperCase")).output(literal(" cube) {\n\t\t\tthis.cube = cube;\n\t\t}\n\n\t\tpublic int size() {\n\t\t\treturn ")).output(mark("cube", "size").multiple(" + ")).output(literal(";\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif(o == null || o.getClass() != getClass()) return false;\n\t\t\tfinal Fact other = (Fact) o;\n\t\t\treturn Objects.equals(")).output(mark("mainCube", "firstLowerCase")).output(literal(", other.")).output(mark("mainCube", "firstLowerCase")).output(literal(");\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn ")).output(mark("mainCube", "firstLowerCase")).output(literal(".hashCode();\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn \"")).output(mark("name")).output(literal("Fact{\" +\n\t\t\t\t\t\"")).output(mark("mainCube")).output(literal("=\" + ")).output(mark("mainCube", "firstLowerCase")).output(literal(" +\n\t\t\t\t\t\", ")).output(mark("joinCube")).output(literal("=\" + ")).output(mark("joinCube", "firstLowerCase")).output(literal(" +\n\t\t\t\t\t\"}\";\n\t\t}\n\t}\n\n\tpublic static class NullFact extends Fact {\n\n\t\tprivate NullFact() {\n\t\t\tsuper(")).output(mark("cube", "nullFactParameter").multiple(", ")).output(literal(");\n\t\t}\n\n\t\t")).output(expression().output(mark("column", "nullgetter").multiple("\n\n"))).output(literal("\n\n\t\t@Override\n\t\tpublic long id() {\n\t\t\treturn 0;\n\t\t}\n\t}\n\n\tpublic enum Indicator {\n\n\t\tTotal(\"Total\", \"\", Mode.Sum, false),\n\t\tDistinct(\"Distinct\", \"\", Mode.Sum, false),\n\t\t")).output(expression().output(mark("indicator", "enum").multiple(",\n"))).output(literal("\n\t\t")).output(expression().output(literal(",")).output(mark("customIndicator", "enum").multiple(",\n"))).output(literal(";\n\n\n\t\tpublic static Indicator byName(String name) {\n\t\t\treturn Arrays.stream(values()).filter(i -> i.name().equalsIgnoreCase(name)).findFirst().orElse(null);\n\t\t}\n\n\t\tpublic final String title;\n\t\tpublic final String unit;\n\t\tpublic final Mode mode;\n\t\tprivate final boolean virtual;\n\n\t\tIndicator(String title, String unit, Mode mode, boolean virtual) {\n\t\t\tthis.title = title;\n\t\t\tthis.unit = unit;\n\t\t\tthis.mode = mode;\n\t\t\tthis.virtual = virtual;\n\t\t}\n\n\t\tpublic enum Mode {\n\t\t\tSum, Average\n\t\t}\n\t}\n\n\tpublic static abstract class AbstractAggregation {\n\n\t\tprivate static final long Long_NaN = Long.MIN_VALUE;\n\n\t\tprivate final Timetag timetag;\n\t\tprivate final List<Axis.Component> components;\n\t\tprivate final Map<Axis, Predicate<Fact>> filters;\n\t\tprivate long aggregationTotal = 0L;\n\t\tprivate long aggregationDistinct = 0L;\n\t\tprivate long lastID = Long.MIN_VALUE;\n\t\t")).output(expression().output(mark("index", "field"))).output(literal("\n\t\t")).output(expression().output(mark("indicator", "field").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(mark("customIndicator", "field").multiple("\n"))).output(literal("\n\t\tprivate long total")).output(mark("name", "FirstUpperCase")).output(literal(";\n\n\t\tpublic AbstractAggregation(Timetag timetag, List<Axis.Component> components, Map<Axis, Predicate<Fact>> filters) {\n\t\t\tthis.timetag = timetag;\n\t\t\tthis.components = components;\n\t\t\tthis.filters = filters;\n\t\t}\n\n\t\tpublic void append(Fact fact) {\n\t\t\t")).output(expression().output(mark("indicator", "sum").multiple("\n"))).output(literal("\n\t\t\tif(lastID != fact.id()) {\n\t\t\t\t")).output(expression().output(mark("index", "append"))).output(literal("\n\t\t\t\t++aggregationDistinct;\n\t\t\t\tlastID = fact.id();\n\t\t\t}\n\t\t\t++aggregationTotal;\n\t\t}\n\n\t\tpublic void append(AbstractAggregation aggregation) {\n\t\t\t")).output(expression().output(mark("indicator", "sumAggregation").multiple("\n"))).output(literal("\n\t\t\t")).output(expression().output(mark("customIndicator", "sumAggregation").multiple("\n"))).output(literal("\n\t\t\t")).output(expression().output(mark("index", "append2"))).output(literal("\n\t\t\taggregationDistinct = Math.max(aggregationDistinct, aggregation.aggregationDistinct);\n\t\t\taggregationTotal += aggregation.aggregationTotal();\n\t\t}\n\n\t\tpublic Aggregation append(long ids) {\n\t\t\tthis.total")).output(mark("name", "FirstUpperCase")).output(literal(" += ids;\n\t\t\treturn (Aggregation) this;\n\t\t}\n\n\t\tpublic long aggregationTotal() {\n\t\t\treturn aggregationTotal;\n\t\t}\n\n\t\tpublic long aggregationDistinct() {\n\t\t\treturn aggregationDistinct;\n\t\t}\n\n\t\tpublic long total")).output(mark("name", "FirstUpperCase")).output(literal("() {\n\t\t\treturn total")).output(mark("name", "FirstUpperCase")).output(literal(";\n\t\t}\n\n\t\t")).output(expression().output(mark("index", "getter"))).output(literal("\n\n\t\tpublic Timetag timetag() {\n\t\t\treturn timetag;\n\t\t}\n\n\t\tpublic List<Axis.Component> components() {\n\t\t\treturn components;\n\t\t}\n\n\t\t")).output(expression().output(mark("indicator", "getter").multiple("\n\n"))).output(literal("\n\n\t\t")).output(expression().output(mark("customIndicator", "getter").multiple("\n\n"))).output(literal("\n\n\t\tpublic Number indicator(Indicator indicator) {\n\t\t\tswitch(indicator) {\n\t\t\t\t")).output(expression().output(mark("indicator", "switchCase").multiple("\n"))).output(literal("\n\t\t\t\t")).output(expression().output(mark("customIndicator", "switchCase").multiple("\n"))).output(literal("\n\t\t\t\tcase Total: return aggregationTotal;\n\t\t\t\tcase Distinct: return aggregationDistinct;\n\t\t\t}\n\t\t\treturn 0L;\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn \"")).output(mark("name", "FirstUpperCase")).output(literal(".Aggregation{\"\n\t\t\t\t+ \"total=\" + aggregationTotal\n\t\t\t\t+ \", distincts=\" + aggregationDistinct\n\t\t\t\t")).output(expression().output(mark("index", "toString").multiple("\n"))).output(literal("\n\t\t\t\t")).output(expression().output(mark("indicator", "toString").multiple("\n"))).output(literal("\n\t\t\t\t")).output(expression().output(mark("customIndicator", "toString").multiple("\n"))).output(literal("\n\t\t\t\t+ \"}\";\n\t\t}\n\t}\n\n\tpublic static class Loader implements Iterable<Fact> {\n\n\t\tprivate final StatefulIterator<")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact> ids;\n\t\tprivate final List<Axis> axes = new ArrayList<>();\n\t\tprivate long[] totals;\n\t\tprivate final List<Predicate<")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact>> filters = new ArrayList<>();\n\t\tprivate final List<Function<")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact, Axis.Component>> groupsBy = new ArrayList<>();\n\t\tprotected final Datasource datasource;\n\t\t")).output(expression().output(mark("split", "field"))).output(literal("\n\n\t\tpublic Loader(Datasource datasource")).output(expression().output(literal(", ")).output(mark("split", "parameter"))).output(literal(") {\n\t\t\tthis.datasource = datasource;\n\t\t\t")).output(expression().output(mark("split", "assign"))).output(literal("\n\t\t\tthis.ids = StatefulIterator.of(new ")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Loader(new ")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Loader.Datasource(this.datasource.root, this.datasource.from, this.datasource.to)")).output(expression().output(literal(", ")).output(mark("split", "name"))).output(literal(").iterator());\n\t\t}\n\n\t\t@Override\n\t\tpublic Iterator<Fact> iterator() {\n\t\t\tif(!ids.hasNext()) return Stream.<Fact>empty().iterator();\n\t\t\tStatefulIterator<")).output(mark("mainCube", "FirstUpperCase")).output(literal(".Fact> facts = StatefulIterator.of(new ")).output(mark("mainCube", "FirstUpperCase")).output(literal(".Loader(new ")).output(mark("mainCube", "FirstUpperCase")).output(literal(".Loader.Datasource(this.datasource.root, this.datasource.from, this.datasource.to)")).output(expression().output(literal(", ")).output(mark("split", "name"))).output(literal(").iterator());\n\t\t\tids.next();\n\t\t\tprocess(ids.current());\n\t\t\treturn StreamSupport.stream(Spliterators.spliteratorUnknownSize(facts, Spliterator.SORTED), false)\n\t\t\t\t\t.map(f -> {\n\t\t\t\t\t\tfinal long mainID = ")).output(mark("name", "FirstUpperCase")).output(literal(".idOf(facts.current());\n\t\t\t\t\t\twhile (ids.current() != null && ids.current().id() < mainID) {\n\t\t\t\t\t\t\tids.next();\n\t\t\t\t\t\t\tprocess(ids.current());\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif (!facts.hasNext()) end();\n\t\t\t\t\t\treturn new Fact(f, ids.current() != null && ids.current().id() == mainID ?\n\t\t\t\t\t\t\t\tids.current() : Abstract")).output(mark("joinCube", "FirstUpperCase")).output(literal(".NULL_FACT);\n\t\t\t\t\t})\n\t\t\t\t\t.iterator();\n\t\t}\n\n\t\tprivate void end() {\n\t\t\twhile (ids.hasNext()) {\n\t\t\t\tids.next();\n\t\t\t\tprocess(ids.current());\n\t\t\t}\n\t\t}\n\n\t\tpublic Timetag from() {\n\t\t\treturn datasource.from;\n\t\t}\n\n\t\tprivate int totalsSize() {\n\t\t\tint accumulator = 1;\n\t\t\tfor (Axis axis : axes) accumulator *= axis.getSize();\n\t\t\treturn accumulator;\n\t\t}\n\n\t\tprivate void process(")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact fact) {\n\t\t\tif (fact == null) return;\n\t\t\tif (totals == null) totals = new long[totalsSize()];\n\t\t\tfor (Predicate<")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact> filter : filters) if (!filter.test(fact)) return;\n\t\t\tAxis.Component[] components = componentsOf(fact);\n\t\t\ttotals[indexOf(components)] += 1;\n\t\t}\n\n\t\tprivate int indexOf(Axis.Component[] components) {\n\t\t\tint index = 0;\n\t\t\tfor (int i = 0; i < components.length; i++) {\n\t\t\t\ti *= axes.get(i).getSize();\n\t\t\t\ti += components[i].index();\n\t\t\t}\n\t\t\treturn index;\n\t\t}\n\n\t\tprivate Axis.Component[] componentsOf(")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact item) {\n\t\t\tAxis.Component[] components = new Axis.Component[axes.size()];\n\t\t\tfor (int i = 0; i < components.length; i++) components[i] = groupsBy.get(i).apply(item);\n\t\t\treturn components;\n\t\t}\n\n\t\tprivate long totalOf(List<Axis.Component> categories) {\n\t\t\treturn totals[indexOf(categories.toArray(new Axis.Component[0]))];\n\t\t}\n\n\t\tpublic Loader filter(Predicate<")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact> filter) {\n\t\t\tif (filter == null) return this;\n\t\t\tfilters.add(filter);\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Loader groupBy(Axis axis, Function<")).output(mark("joinCube", "FirstUpperCase")).output(literal(".Fact, Axis.Component> dimension) {\n\t\t\tif (dimension == null) return this;\n\t\t\taxes.add(axis);\n\t\t\tgroupsBy.add(dimension);\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic List<Axis> axes() {\n\t\t\treturn axes;\n\t\t}\n\n\t\tpublic long[] totals() {\n\t\t\tif(totals == null) totals = new long[totalsSize()];\n\t\t\treturn totals;\n\t\t}\n\n\t\tpublic static class Datasource {\n\n\t\t\tprivate final File root;\n\t\t\tprivate final Timetag from;\n\t\t\tprivate final Timetag to;\n\n\t\t\tpublic Datasource(File root, Timetag from, Timetag to) {\n\t\t\t\tthis.root = root;\n\t\t\t\tthis.from = from;\n\t\t\t\tthis.to = to;\n\t\t\t}\n\n\t\t\tpublic Timetag from() {\n\t\t\t\treturn from;\n\t\t\t}\n\n\t\t\tpublic Timetag to() {\n\t\t\t\treturn to;\n\t\t\t}\n\t\t}\n\t}\n}")),
				rule().condition((type("indicator")), (trigger("enum"))).output(mark("fieldName", "CamelCase", "FirstUpperCase")).output(literal("(\"")).output(mark("label")).output(literal("\", \"")).output(mark("unit")).output(literal("\", Mode.")).output(mark("mode")).output(literal(", false)")),
				rule().condition((type("customIndicator")), (trigger("enum"))).output(mark("fieldName", "CamelCase", "FirstUpperCase")).output(literal("(\"")).output(mark("label")).output(literal("\", \"")).output(mark("unit")).output(literal("\", Mode.")).output(mark("mode")).output(literal(", true)")),
				rule().condition((type("indicator")), (trigger("switchcase"))).output(literal("case ")).output(mark("fieldName", "CamelCase", "FirstUpperCase")).output(literal(": return ")).output(mark("name", "snakeCaseToCamelCase", "FirstLowerCase")).output(literal(";")),
				rule().condition((type("customIndicator")), (trigger("switchcase"))).output(literal("case ")).output(mark("fieldName", "CamelCase", "FirstUpperCase")).output(literal(": return ")).output(mark("name", "snakeCaseToCamelCase", "FirstLowerCase")).output(literal(";")),
				rule().condition((type("index")), (trigger("field"))).output(literal("private final SparseLongList ids = new SparseLongList();")),
				rule().condition((type("index")), (trigger("append"))).output(literal("ids.add(fact.id());")),
				rule().condition((type("index")), (trigger("append2"))).output(literal("ids.addAll(aggregation.ids);")),
				rule().condition((type("index")), (trigger("getter"))).output(literal("public List<Long> ids() {\n\treturn ids.asList();\n}")),
				rule().condition((trigger("assignfact"))).output(literal("this.")).output(mark("", "FirstLowerCase")).output(literal(" = ")).output(mark("", "FirstLowerCase")).output(literal(";")),
				rule().condition((trigger("fieldfact"))).output(literal("private final ")).output(mark("", "FirstUpperCase")).output(literal(".Fact ")).output(mark("", "FirstLowerCase")).output(literal(";")),
				rule().condition((trigger("factparameter"))).output(mark("", "FirstUpperCase")).output(literal(".Fact ")).output(mark("", "FirstLowerCase")),
				rule().condition((trigger("nullfactparameter"))).output(literal("Abstract")).output(mark("", "FirstUpperCase")).output(literal(".NULL_FACT")),
				rule().condition((trigger("size"))).output(mark("", "FirstLowerCase")).output(literal(".size()")),
				rule().condition((trigger("nbits"))).output(literal("NBits")),
				rule().condition((type("customFilter")), (trigger("method"))).output(literal("public Abstract")).output(mark("cube", "firstUpperCase")).output(literal(" filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("() {\n\tfilter = filter.and(")).output(mark("cube", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("::")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter);\n\treturn this;\n}")),
				rule().condition((type("customFilter")), (trigger("staticmethod"))).output(literal("public static boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(Fact fact) {\n\treturn true;\n}")),
				rule().condition((type("dimension")), (trigger("switchcasegroupby"))).output(literal("case ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".TITLE: return groupBy")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("();")),
				rule().condition((allTypes("dimension", "categorical")), (trigger("switchcasefilter"))).output(literal("case ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".TITLE: return filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("((Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component>) components);")),
				rule().condition((allTypes("dimension", "continuous")), (trigger("switchcasefilter"))).output(literal("case ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".TITLE: return filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("((Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Range>) components);")),
				rule().condition((allTypes("customDimension", "categorical")), (trigger("staticmethod"))).output(literal("public static ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(Fact fact) {\n\t// TODO\n\treturn ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".NA;\n}")),
				rule().condition((allTypes("customDimension", "continuous")), (trigger("staticmethod"))).output(literal("public static ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Range ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(Fact fact) {\n\t// TODO\n\treturn ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".component(0);\n}")),
				rule().condition((allTypes("dimension", "categorical")), (trigger("method"))).output(literal("public Abstract")).output(mark("cube", "firstUpperCase")).output(literal(" filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("(Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\tif(filters.containsKey(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(v, ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(");\n\tfilters.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")).output(mark("cube", "FirstUpperCase")).output(literal(" groupBy")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("() {\n\taxes.add(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get());\n\tcomponents.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), new HashSet<>());\n\tgroupByList.add(v -> ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(v));\n\treturn this;\n}\n\npublic static boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(Fact fact, Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\treturn ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(".contains(")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(fact));\n}\n\npublic static ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(Fact fact) {\n\treturn fact.")).output(mark("source", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("()")).output(expression().output(literal(".")).output(mark("child", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("()"))).output(literal(";\n}")),
				rule().condition((allTypes("customDimension", "categorical")), (trigger("method"))).output(literal("public Abstract")).output(mark("cube", "firstUpperCase")).output(literal(" filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("(Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\tif(filters.containsKey(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(v, ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(");\n\tfilters.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")).output(mark("cube", "FirstUpperCase")).output(literal(" groupBy")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("() {\n\taxes.add(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get());\n\tcomponents.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), new HashSet<>());\n\tgroupByList.add(v -> ")).output(mark("cube", "firstUpperCase")).output(literal(".")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(v));\n\treturn this;\n}\n\npublic static boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(Fact fact, Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\treturn ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(".contains(")).output(mark("cube", "firstUpperCase")).output(literal(".")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(fact));\n}")),
				rule().condition((allTypes("dimension", "continuous")), (trigger("method"))).output(literal("public Abstract")).output(mark("cube", "firstUpperCase")).output(literal(" filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("(Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Range> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\tif(filters.containsKey(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(v, ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(");\n\tfilters.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")).output(mark("cube", "FirstUpperCase")).output(literal(" groupBy")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("() {\n\taxes.add(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get());\n\tcomponents.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), new HashSet<>());\n\tgroupByList.add(")).output(mark("cube", "FirstUpperCase")).output(literal("::")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function);\n\treturn this;\n}\n\npublic static boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(Fact fact, Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Range> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\treturn ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(".contains(")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(fact));\n}\n\npublic static ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Range ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(Fact fact) {\n\treturn ")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".rangeOf(fact.")).output(mark("source", "firstLowerCase")).output(literal("());\n}")),
				rule().condition((allTypes("customDimension", "continuous")), (trigger("method"))).output(literal("public Abstract")).output(mark("cube", "firstUpperCase")).output(literal(" filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("(Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Range> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\tif(filters.containsKey(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get())) return this;\n\tPredicate<Fact> f = v -> ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(v, ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(");\n\tfilters.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), f);\n\tfilter = filter.and(f);\n\treturn this;\n}\n\npublic Abstract")).output(mark("cube", "FirstUpperCase")).output(literal(" groupBy")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("() {\n\taxes.add(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get());\n\tcomponents.put(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get(), new HashSet<>());\n\tgroupByList.add(")).output(mark("cube", "FirstUpperCase")).output(literal("::")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function);\n\treturn this;\n}\n\npublic static boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Filter(Fact fact, Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Range> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(") {\n\treturn ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal(".contains(")).output(mark("cube", "firstUpperCase")).output(literal(".")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("Function(fact));\n}")),
				rule().condition((type("dimension")), (trigger("ifgroupby"))).output(literal("if(axis.equals(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get())) return groupBy")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("();")),
				rule().condition((type("dimension")), (trigger("iffilterby"))).output(literal("if(axis.equals(")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get())) return filter")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("();")),
				rule().condition((type("customIndicator")), (trigger("tostring"))).output(literal(" + \", ")).output(mark("name", "firstLowerCase")).output(literal("=\" + ")).output(mark("name", "firstLowerCase")).output(literal("()")),
				rule().condition((type("indicator")), (trigger("sum"))).output(mark("name", "firstLowerCase")).output(literal(" += fact.")).output(mark("source", "firstLowerCase")).output(literal("();")),
				rule().condition((type("indicator")), (trigger("sumaggregation"))).output(mark("name", "firstLowerCase")).output(literal(" += aggregation.")).output(mark("name", "firstLowerCase")).output(literal(";")),
				rule().condition((allTypes("customIndicator", "sum")), (trigger("sumaggregation"))).output(literal("if(")).output(mark("name", "firstLowerCase")).output(literal(" != Long_NaN && aggregation.")).output(mark("name", "firstLowerCase")).output(literal(" != Long_NaN)\n\t")).output(mark("name", "firstLowerCase")).output(literal(" += aggregation.")).output(mark("name", "firstLowerCase")).output(literal(";")),
				rule().condition((allTypes("customIndicator", "average")), (trigger("sumaggregation"))).output(literal("if(!Double.isNaN(")).output(mark("name", "firstLowerCase")).output(literal(") && !Double.isNaN(aggregation.")).output(mark("name", "firstLowerCase")).output(literal("))\n\t")).output(mark("name", "firstLowerCase")).output(literal(" += aggregation.")).output(mark("name", "firstLowerCase")).output(literal(";")),
				rule().condition((allTypes("customIndicator", "average")), (trigger("field"))).output(literal("protected double ")).output(mark("name", "firstLowerCase")).output(literal(" = Double.NaN;")),
				rule().condition((allTypes("indicator", "average")), (trigger("field"))).output(literal("protected double ")).output(mark("name", "firstLowerCase")).output(literal(";")),
				rule().condition((allTypes("indicator", "sum")), (trigger("field"))).output(literal("protected long ")).output(mark("name", "firstLowerCase")).output(literal(";")),
				rule().condition((allTypes("customIndicator", "sum")), (trigger("field"))).output(literal("protected long ")).output(mark("name", "firstLowerCase")).output(literal(" = Long_NaN;")),
				rule().condition((allTypes("indicator", "average")), (trigger("getter"))).output(literal("public double ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(" / (double) aggregationDistinct;\n}")),
				rule().condition((allTypes("customIndicator", "average")), (trigger("getter"))).output(literal("public final double ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\tif(Double.isNaN(")).output(mark("name", "firstLowerCase")).output(literal("))\n\t\t")).output(mark("name", "firstLowerCase")).output(literal(" = calculate")).output(mark("name", "firstUpperCase")).output(literal("();\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\nprotected double calculate")).output(mark("name", "firstUpperCase")).output(literal("() {\n\treturn 0.0;\n}")),
				rule().condition((allTypes("indicator", "sum")), (trigger("getter"))).output(literal("public long ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}")),
				rule().condition((allTypes("customIndicator", "sum")), (trigger("getter"))).output(literal("public final long ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\tif(")).output(mark("name", "firstLowerCase")).output(literal(" == Long_NaN)\n\t\t")).output(mark("name", "firstLowerCase")).output(literal(" = calculate")).output(mark("name", "firstUpperCase")).output(literal("();\n\treturn ")).output(mark("name", "firstLowerCase")).output(literal(";\n}\n\nprotected long calculate")).output(mark("name", "firstUpperCase")).output(literal("() {\n\treturn 0L;\n}")),
				rule().condition((type("index")), (trigger("index"))).output(literal("ids.size()")),
				rule().condition((allTypes("indicator", "average")), (trigger("staticmethod"))).output(literal("public static double ")).output(mark("name")).output(literal("(Fact fact) {\n\treturn 0.0;\n}")),
				rule().condition((allTypes("indicator", "sum")), (trigger("staticmethod"))).output(literal("public static long ")).output(mark("name")).output(literal("(Fact fact) {\n\treturn 0;\n}")),
				rule().condition((type("split")), (trigger("parameter"))).output(literal("String ")).output(mark("name", "firstLowerCase")),
				rule().condition((type("split")), (trigger("setparameter"))).output(literal("java.util.Set<String> ")).output(mark("name", "firstLowerCase")),
				rule().condition((type("split")), (trigger("assign"))).output(literal("this.")).output(mark("name", "firstLowerCase")).output(literal(" = ")).output(mark("name", "firstLowerCase")).output(literal(";")),
				rule().condition((type("split")), (trigger("name"))).output(mark("name", "firstLowerCase")),
				rule().condition((type("split")), (trigger("nameupper"))).output(mark("name", "firstUpperCase")),
				rule().condition((type("split")), (trigger("field"))).output(literal("protected final String ")).output(mark("name", "firstLowerCase")).output(literal(";")),
				rule().condition((type("split")), (trigger("method"))).output(literal("private static Set<String> all")).output(mark("name", "FirstUpperCase")).output(literal("() {\n\treturn java.util.Set.of(")).output(mark("value", "quoted").multiple(", ")).output(literal(");\n}")),
				rule().condition((type("dimension")), (trigger("getinstance"))).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".get()")),
				rule().condition((trigger("dimension"))).output(literal("public static Predicate<")).output(mark("cube", "FirstUpperCase")).output(literal(".Fact> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("(Set<")).output(mark("axis", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(".Component> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("List) {\n\treturn r -> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("List.contains(r.")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("());\n}\n\npublic static Function<")).output(mark("cube", "FirstUpperCase")).output(literal(".Fact, String> ")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn r -> r.")).output(mark("axis", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("().id();\n}")),
				rule().condition((allTypes("column", "int", "unsigned")), (trigger("factgetter"))).output(literal("public long ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((allTypes("column", "int")), (trigger("factgetter"))).output(literal("public int ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((allTypes("column", "float")), (trigger("factgetter"))).output(literal("public float ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((allTypes("column", "double")), (trigger("factgetter"))).output(literal("public double ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("column")), (anyTypes("id", "long")), (trigger("factgetter"))).output(literal("public long ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("column")), (allTypes("byte", "unsigned")), (trigger("factgetter"))).output(literal("public short ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("column")), (type("byte")), (trigger("factgetter"))).output(literal("public byte ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("column")), (allTypes("short", "unsigned")), (trigger("factgetter"))).output(literal("public int ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("column")), (type("short")), (trigger("factgetter"))).output(literal("public short ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("column")), (type("boolean")), (trigger("factgetter"))).output(literal("public boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((allTypes("column", "categorical")), (trigger("factgetter"))).output(literal("public ")).output(mark("type", "firstUpperCase")).output(literal(".Component ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("column")), (trigger("factgetter"))).output(literal("public ")).output(mark("type", "firstUpperCase")).output(literal(" ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((allTypes("column", "virtual")), (trigger("factgetter"))).output(literal("public ")).output(mark("type")).output(literal(" ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube", "firstLowerCase")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((allTypes("column", "categorical")), (trigger("nullgetter"))).output(literal("public ")).output(mark("type", "firstUpperCase")).output(literal(".Component ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("type", "firstUpperCase")).output(literal(".NA;\n}")),
				rule().condition((allTypes("column", "int", "unsigned")), (trigger("nullgetter"))).output(literal("public long ")).output(mark("name", "firstLowerCase")).output(literal("() {\n\treturn 0;\n}")),
				rule().condition((allTypes("column", "int")), (trigger("nullgetter"))).output(literal("public int ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0;\n}")),
				rule().condition((type("column")), (anyTypes("id", "long")), (trigger("nullgetter"))).output(literal("public long ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0L;\n}")),
				rule().condition((allTypes("column", "short", "unsigned")), (trigger("nullgetter"))).output(literal("public int ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0;\n}")),
				rule().condition((allTypes("column", "short")), (trigger("nullgetter"))).output(literal("public short ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0;\n}")),
				rule().condition((allTypes("column", "byte", "unsigned")), (trigger("nullgetter"))).output(literal("public short ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0;\n}")),
				rule().condition((allTypes("column", "byte")), (trigger("nullgetter"))).output(literal("public byte ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0;\n}")),
				rule().condition((allTypes("column", "float")), (trigger("nullgetter"))).output(literal("public float ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0.0f;\n}")),
				rule().condition((allTypes("column", "double")), (trigger("nullgetter"))).output(literal("public double ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn 0.0f;\n}")),
				rule().condition((allTypes("column", "boolean")), (trigger("nullgetter"))).output(literal("public boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn false;\n}")),
				rule().condition((allTypes("column", "boolean")), (trigger("nullgetter"))).output(literal("public boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn false;\n}")),
				rule().condition((allTypes("column", "boolean")), (trigger("nullgetter"))).output(literal("public boolean ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn false;\n}")),
				rule().condition((allTypes("virtualColumn", "primitive")), (trigger("factgetter"))).output(literal("public ")).output(mark("type", "firstLowerCase")).output(literal(" ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((type("virtualColumn")), (trigger("factgetter"))).output(literal("public ")).output(mark("type", "firstUpperCase")).output(literal(" ")).output(mark("name", "snakeCaseToCamelCase", "firstLowerCase")).output(literal("() {\n\treturn ")).output(mark("cube")).output(literal(".")).output(mark("name", "firstLowerCase")).output(literal("();\n}")),
				rule().condition((allTypes("customIndicator", "sum")), (trigger("implementation"))).output(literal("@Override\nprotected long calculate")).output(mark("name", "firstUpperCase")).output(literal("() {\n\t// TODO: calculate and return ")).output(mark("name", "firstLowerCase")).output(literal("\n\treturn 0;\n}")),
				rule().condition((allTypes("customIndicator", "average")), (trigger("implementation"))).output(literal("@Override\nprotected double calculate")).output(mark("name", "firstUpperCase")).output(literal("() {\n\t// TODO: calculate and return ")).output(mark("name", "firstLowerCase")).output(literal("\n\treturn 0.0;\n}"))
		);
	}
}