package io.intino.konos.builder.codegeneration.accessor.ui.web.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class PageTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("resource", "js"))).output(literal("import React from \"react\";\nimport { MuiThemeProvider, withStyles } from '@material-ui/core/styles';\nimport { IconButton } from \"@material-ui/core\";\nimport { Close } from '@material-ui/icons';\nimport { SnackbarProvider, useSnackbar } from \"notistack\";\nimport CssBaseline from '@material-ui/core/CssBaseline';\nimport Theme from '../../gen/Theme';\nimport Page from \"alexandria-ui-elements/src/displays/Page\";\nimport ConnectionChecker from \"alexandria-ui-elements/src/displays/ConnectionChecker\";\nimport ")).output(mark("pageDisplay", "firstUpperCase")).output(literal(" from \"")).output(mark("pageDisplayOrigin", "origin")).output(literal("/displays/")).output(mark("pageDisplayType", "firstLowerCase")).output(literal("s/")).output(mark("pageDisplay", "firstUpperCase")).output(literal("\";\n")).output(mark("accessibleImport").multiple("\n")).output(literal("\n\nlet theme = Theme.create();\nconst styles = theme => ({});\n\nconst ")).output(mark("pageDisplay", "firstUpperCase")).output(literal("PageDismissAction = ({ id }) => {\nconst { closeSnackbar } = useSnackbar();\nreturn (<IconButton color=\"inherit\" onClick={() => closeSnackbar(id)}><Close fontSize=\"small\" /></IconButton>);\n}\n\nexport default class ")).output(mark("pageDisplay", "firstUpperCase")).output(literal("Page extends Page {\nrender() {\n\tconst { classes } = this.props;\n\treturn (\n\t\t<MuiThemeProvider theme={theme}>\n\t\t\t<SnackbarProvider maxSnack={3} action={key => <")).output(mark("pageDisplay", "firstUpperCase")).output(literal("PageDismissAction id={key}/>}>\n\t\t\t\t<CssBaseline />\n\t\t\t\t<")).output(mark("pageDisplay", "firstUpperCase")).output(literal(" id=\"")).output(mark("pageDisplayId")).output(literal("\"></")).output(mark("pageDisplay", "firstUpperCase")).output(literal(">\n\t\t\t\t<ConnectionChecker></ConnectionChecker>\n\t\t\t</SnackbarProvider>\n\t\t</MuiThemeProvider>\n\t);\n}\n}")),
				rule().condition((allTypes("resource", "html"))).output(literal("<!DOCTYPE html>\n<html>\n\t<head>\n\t\t<title>$title</title>\n\n\t\t<meta charset=\"utf-8\"/>\n\t\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\"/>\n\t\t<meta name=\"viewport\" content=\"width=device-width, minimum-scale=1.0, initial-scale=1, user-scalable=yes\"/>\n\n\t\t<link rel=\"icon\" href=\"$favicon\">\n\n\t\t<script src=\"$url/res/js/jquery-3.6.1.min.js\"></script>\n\t\t<script src=\"$url/res/js/materialize-1.0.0.min.js\"></script>\n\n\t\t<style nonce=\"main_style\">\n\t\t\thtml, body {\n\t\t\t\tmin-height: 100vh;\n\t\t\t\theight: 100%;\n\t\t\t}\n\t\t\t.page {\n\t\t\t\tdisplay: table;\n\t\t\t\theight: 100%;\n\t\t\t\twidth: 100%;\n\t\t\t}\n\t\t</style>\n\t</head>\n\n\t<body>\n\t\t<div class=\"page\" id=\"")).output(mark("pageDisplay", "firstUpperCase")).output(literal("\"></div>\n\t\t<script nonce=\"main_script\">\n\t\t\tdocument.configuration = {};\n\t\t\tdocument.configuration.googleApiKey = \"$googleApiKey\";\n\t\t\tdocument.configuration.pushConnections = \"$pushConnections\".split(\",\");\n\t\t\tdocument.configuration.clientId = \"$client\";\n\t\t\tdocument.configuration.language = \"$language\";\n\t\t\tdocument.configuration.url = \"$url\";\n\t\t\tdocument.configuration.baseUrl = \"$baseUrl\";\n\t\t\tdocument.configuration.baseUrls = \"$baseUrls\".split(\",\");\n\t\t\tdocument.configuration.basePath = \"$basePath\";\n\t\t</script>\n\t</body>\n</html>")),
				rule().condition((attribute("hasabstract")), (trigger("origin"))).output(literal("../../src")),
				rule().condition((attribute("decorated")), (trigger("origin"))).output(literal("../../gen")),
				rule().condition((trigger("origin"))).output(literal("..")),
				rule().condition((type("accessibleImport"))).output(literal("import ")).output(mark("service", "firstUpperCase")).output(literal("AccessibleDisplays from '")).output(mark("elements")).output(literal("/gen/AccessibleDisplays';"))
		);
	}
}