package io.intino.konos.builder.codegeneration.accessor.ui.android.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class PageTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("resource", "template"))).output(literal("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<androidx.constraintlayout.widget.ConstraintLayout\nxmlns:android=\"http://schemas.android.com/apk/res/android\"\nxmlns:alexandria=\"http://schemas.android.com/apk/res-auto\"\nxmlns:tools=\"http://schemas.android.com/tools\"\nandroid:layout_width=\"match_parent\"\nandroid:layout_height=\"match_parent\"\ntools:context=\".pages.")).output(mark("name", "snakecaseToCamelCase", "firstUpperCase")).output(literal("Activity\">\n\n<")).output(mark("package", "validPackage")).output(literal(".mobile.android.displays.templates.")).output(mark("pageDisplay", "firstUpperCase")).output(literal("\n\tandroid:id=\"@+id/")).output(mark("pageDisplayId", "firstLowerCase")).output(literal("\"\n\tandroid:layout_width=\"match_parent\"\n\tandroid:layout_height=\"match_parent\">\n</")).output(mark("package", "validPackage")).output(literal(".mobile.android.displays.templates.")).output(mark("pageDisplay", "firstUpperCase")).output(literal(">\n</androidx.constraintlayout.widget.ConstraintLayout>")),
				rule().condition((allTypes("resource", "main"))).output(literal("package ")).output(mark("package", "validPackage")).output(literal(".mobile.android.pages\n\nimport android.os.Bundle\nimport io.intino.alexandria.mobile.Application\nimport io.intino.alexandria.mobile.android.AlexandriaActivity\nimport ")).output(mark("package", "validPackage")).output(literal(".mobile.android.R\n\nclass ")).output(mark("name", "snakecaseToCamelCase", "firstUpperCase")).output(literal("Activity : AlexandriaActivity(\"")).output(mark("name")).output(literal("\") {\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        Application.onVerifyPermissions { type, callback -> verifyPermissions(type, callback) }\n        Application.onPickFile { callback -> pickFile(callback) }\n        Application.start(\"")).output(mark("name")).output(literal("\", \"")).output(mark("url")).output(literal("\", pushService(withParams(\"")).output(mark("url")).output(mark("path")).output(literal("\")) { showNoConnectionDialog(); })\n        setContentView(R.layout.")).output(mark("name", "camelCaseToUnderscoreCase", "lowerCase")).output(literal("_activity)\n    }\n\n\n}")),
				rule().condition((type("resource"))).output(literal("package ")).output(mark("package", "validPackage")).output(literal(".mobile.android.pages\n\nimport android.os.Bundle\nimport io.intino.alexandria.mobile.Application\nimport io.intino.alexandria.mobile.android.AlexandriaActivity\nimport ")).output(mark("package", "validPackage")).output(literal(".mobile.android.R\n\nclass ")).output(mark("name", "snakecaseToCamelCase", "firstUpperCase")).output(literal("Activity : AlexandriaActivity(\"")).output(mark("name")).output(literal("\") {\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        Application.onVerifyPermissions { type, callback -> verifyPermissions(type, callback) }\n        Application.onPickFile { callback -> pickFile(callback) }\n        Application.close(\"")).output(mark("name")).output(literal("\")\n        Application.open(\"")).output(mark("name")).output(literal("\", \"")).output(mark("url")).output(literal("\", pushService(withParams(\"")).output(mark("url")).output(mark("path")).output(literal("\")) { showNoConnectionDialog(); })\n        setContentView(R.layout.")).output(mark("name", "camelCaseToUnderscoreCase", "lowerCase")).output(literal("_activity)\n    }\n\n}")),
				rule().condition((attribute("hasabstract")), (trigger("origin"))).output(literal("../../src")),
				rule().condition((attribute("decorated")), (trigger("origin"))).output(literal("../../gen")),
				rule().condition((trigger("origin"))).output(literal("..")),
				rule().condition((type("accessibleImport"))).output(literal("import ")).output(mark("service", "firstUpperCase")).output(literal("AccessibleDisplays from '")).output(mark("elements")).output(literal("/gen/AccessibleDisplays';"))
		);
	}
}