package io.intino.konos.builder.codegeneration.accessor.ui.android.templates;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class DisplaySkeletonTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("display", "accessible"))),
				rule().condition((allTypes("display", "template"))).output(literal("package ")).output(mark("package")).output(literal(".mobile.android.displays")).output(expression().output(literal(".")).output(mark("packageType")).output(literal("s"))).output(literal("\n\nimport android.content.Context\nimport android.util.AttributeSet\nimport io.intino.alexandria.mobile.android.R\nimport io.intino.alexandria.mobile.displays.notifiers.TemplateNotifier\nimport io.intino.alexandria.mobile.displays.requesters.TemplateRequester\n\nopen class ")).output(mark("name", "firstUpperCase")).output(literal(" @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0, defStyleRes: Int = 0, layout: Int? = null) : io.intino.alexandria.mobile.android.displays.components.Template<TemplateRequester, TemplateNotifier>(context, attrs, defStyleAttr, defStyleRes, R.layout.")).output(mark("name", "camelCaseToUnderscoreCase", "lowerCase")).output(literal(") {\n    init {\n        this.notifier = TemplateNotifier(this)\n        this.requester = TemplateRequester(this)\n        ")).output(expression().output(mark("component", "transfer").multiple("\n"))).output(literal("\n    }\n}")),
				rule().condition((allTypes("display", "collection"))).output(literal("import React from \"react\";\nimport { withStyles } from '@material-ui/core/styles';\nimport Abstract")).output(mark("name", "firstUpperCase")).output(literal(" from \"../../")).output(mark("packageTypeRelativeDirectory")).output(literal("gen/displays")).output(expression().output(literal("/")).output(mark("packageType")).output(literal("s"))).output(literal("/Abstract")).output(mark("name", "firstUpperCase")).output(literal("\";\nimport ")).output(mark("name", "firstUpperCase")).output(literal("Notifier from \"../../")).output(mark("packageTypeRelativeDirectory")).output(literal("gen/displays/notifiers/")).output(mark("name", "firstUpperCase")).output(literal("Notifier\";\nimport ")).output(mark("name", "firstUpperCase")).output(literal("Requester from \"../../")).output(mark("packageTypeRelativeDirectory")).output(literal("gen/displays/requesters/")).output(mark("name", "firstUpperCase")).output(literal("Requester\";\nimport DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';\nimport { withSnackbar } from 'notistack';\nimport { ")).output(mark("type", "firstUpperCase")).output(literal("Styles } from \"alexandria-ui-elements/src/displays/components/")).output(mark("type", "firstUpperCase")).output(literal("\";\n\nconst styles = theme => ({\n\t...")).output(mark("type", "firstUpperCase")).output(literal("Styles(theme),\n});\n\nclass ")).output(mark("name", "firstUpperCase")).output(literal(" extends Abstract")).output(mark("name", "firstUpperCase")).output(literal(" {\n\n\tconstructor(props) {\n\t\tsuper(props);\n\t\tthis.notifier = new ")).output(mark("name", "firstUpperCase")).output(literal("Notifier(this);\n\t\tthis.requester = new ")).output(mark("name", "firstUpperCase")).output(literal("Requester(this);\n\t};\n\n\t")).output(mark("notification").multiple("\n\n")).output(literal("\n}\n\nexport default withStyles(styles, { withTheme: true })(withSnackbar(")).output(mark("name", "firstUpperCase")).output(literal("));\nDisplayFactory.register(\"")).output(mark("name", "firstUpperCase")).output(literal("\", withStyles(styles, { withTheme: true })(withSnackbar(")).output(mark("name", "firstUpperCase")).output(literal(")));")),
				rule().condition((allTypes("display", "interface"))).output(literal("package ")).output(mark("package")).output(literal(".mobile.displays")).output(expression().output(literal(".")).output(mark("packageType")).output(literal("s"))).output(literal("\n\n")).output(mark("schemaImport")).output(literal("\n\ninterface ")).output(mark("name", "firstUpperCase")).output(literal(" ")).output(mark("displayExtends", "interface")).output(literal(" {\n    ")).output(mark("notification", "interface").multiple("\n\n")).output(literal("\n}")),
				rule().condition((type("display"))).output(literal("package ")).output(mark("package")).output(literal(".mobile.android.displays")).output(expression().output(literal(".")).output(mark("packageType")).output(literal("s"))).output(literal("\n\nimport android.content.Context\nimport android.util.AttributeSet\nimport androidx.core.content.ContextCompat.*\n\nimport ")).output(mark("package")).output(literal(".mobile.displays.notifiers.")).output(mark("name", "firstUpperCase")).output(literal("Notifier\nimport ")).output(mark("package")).output(literal(".mobile.displays.requesters.")).output(mark("name", "firstUpperCase")).output(literal("Requester\nimport ")).output(mark("package")).output(literal(".mobile.android.R\n")).output(mark("schemaImport")).output(literal("\n\nopen class ")).output(mark("name", "firstUpperCase")).output(literal("<DR: ")).output(mark("name", "firstUpperCase")).output(literal("Requester, DN: ")).output(mark("name", "firstUpperCase")).output(literal("Notifier> @JvmOverloads constructor(context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0, defStyleRes: Int = 0, layout: Int? = null) ")).output(mark("displayExtends")).output(literal(", ")).output(mark("package")).output(literal(".mobile.displays")).output(expression().output(literal(".")).output(mark("packageType")).output(literal("s"))).output(literal(".")).output(mark("name", "firstUpperCase")).output(literal(" {\n\n    init {\n\t\tthis.requester = ")).output(mark("name", "firstUpperCase")).output(literal("Requester(this) as DR\n\t\tthis.notifier = ")).output(mark("name", "firstUpperCase")).output(literal("Notifier(this) as DN\n        inflate(viewContext(), layout ?: R.layout.")).output(mark("name", "camelCaseToUnderscoreCase", "lowerCase")).output(literal(", this)\n    }\n\n\t")).output(mark("notification").multiple("\n\n")).output(literal("\n\n}")),
				rule().condition((type("notification")), (trigger("interface"))).output(literal("fun ")).output(mark("name")).output(literal("(")).output(expression().output(literal("value : ")).output(mark("parameter"))).output(literal(")")),
				rule().condition((type("notification"))).output(literal("override fun ")).output(mark("name")).output(literal("(")).output(expression().output(literal("value: ")).output(mark("parameter"))).output(literal(") {\n}")),
				rule().condition((trigger("parametervalue"))).output(literal("value")),
				rule().condition((type("date")), (trigger("parameter"))).output(literal("kotlinx.datetime.Instant")),
				rule().condition((type("datetime")), (trigger("parameter"))).output(literal("kotlinx.datetime.Instant")),
				rule().condition((type("integer")), (trigger("parameter"))).output(literal("Int")),
				rule().condition((type("list")), (trigger("parameter"))).output(literal("kotlin.collections.List<")).output(mark("value")).output(literal(">")),
				rule().condition((trigger("parameter"))).output(mark("value")),
				rule().condition((allTypes("displayExtends", "generic")), (trigger("interface"))).output(literal(": ")).output(mark("parentMobileShared")),
				rule().condition((allTypes("displayExtends", "generic", "isExtensionOf"))).output(literal(": ")).output(mark("parent")).output(literal("<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((allTypes("displayExtends", "generic"))).output(literal(": ")).output(mark("parent")).output(literal("<DR, DN>(context, attrs, defStyleAttr, defStyleRes, IntArray(0))")),
				rule().condition((allTypes("displayExtends", "template")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.components.Template")),
				rule().condition((allTypes("displayExtends", "template"))).output(literal(": io.intino.alexandria.mobile.android.displays.components.Template<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((allTypes("displayExtends", "table")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")),
				rule().condition((allTypes("displayExtends", "table"))).output(literal(": io.intino.alexandria.mobile.android.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((allTypes("displayExtends", "dynamictable")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")),
				rule().condition((allTypes("displayExtends", "dynamictable"))).output(literal(": io.intino.alexandria.mobile.android.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((allTypes("displayExtends", "collection")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")),
				rule().condition((allTypes("displayExtends", "collection"))).output(literal(": io.intino.alexandria.mobile.android.displays.components.")).output(mark("type", "firstUpperCase")).output(mark("facet").multiple("")).output(literal("<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((allTypes("displayExtends", "item")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.components.Item")),
				rule().condition((allTypes("displayExtends", "item"))).output(literal(": io.intino.alexandria.mobile.android.displays.components.Item<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((allTypes("displayExtends", "row")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.components.Row")),
				rule().condition((allTypes("displayExtends", "row"))).output(literal(": io.intino.alexandria.mobile.android.displays.components.Row<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((allTypes("displayExtends", "dialog")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.components.Dialog")),
				rule().condition((allTypes("displayExtends", "dialog"))).output(literal(": io.intino.alexandria.mobile.android.displays.components.Dialog<DR, DN>(context, attrs, defStyleAttr, defStyleRes)")),
				rule().condition((type("displayExtends")), (trigger("interface"))).output(literal(": io.intino.alexandria.mobile.displays.")).output(mark("type", "firstUpperCase")),
				rule().condition((type("displayExtends"))).output(literal(": io.intino.alexandria.mobile.android.displays.")).output(mark("type", "firstUpperCase")).output(literal("<DR, DN>(context, attrs, defStyleAttr, defStyleRes, IntArray(0))")),
				rule().condition((type("schemaImport"))).output(literal("import ")).output(mark("package")).output(literal(".mobile.schemas.*;"))
		);
	}
}