package io.intino.konos.builder;

import io.intino.Configuration;
import io.intino.Configuration.Artifact.Dsl.Level;
import io.intino.builder.BuildConstants.Mode;
import tara.dsl.Konos;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class CompilerConfiguration implements Cloneable {
	private static final Logger LOG = Logger.getGlobal();

	static {
		Logger.getGlobal().setLevel(java.util.logging.Level.INFO);
		LOG.setUseParentHandlers(false);
		for (Handler handler : LOG.getHandlers()) LOG.removeHandler(handler);
		final StreamHandler errorHandler = new StreamHandler(System.err, new SimpleFormatter());
		errorHandler.setLevel(java.util.logging.Level.WARNING);
		LOG.addHandler(errorHandler);
		final StreamHandler infoHandler = new StreamHandler(System.out, new SimpleFormatter());
		infoHandler.setLevel(java.util.logging.Level.INFO);
		LOG.addHandler(infoHandler);
	}

	private int warningLevel;
	private String sourceEncoding;
	private String project;
	private String module;
	private String parentInterface;
	private boolean debug;
	private final List<File> sources = new ArrayList<>();
	private File srcDirectory;
	private File genDirectory;
	private File resDirectory;
	private File outDirectory;
	private String groupID;
	private String artifactID;
	private String version;
	private final DslConfiguration model;
	private boolean verbose;
	private File tempDirectory;
	private File datahubLibrary;
	private List<String> currentDependencies;
	private File intinoProjectDirectory;
	private String generationPackage;
	private PrintStream out = System.out;
	private File projectDirectory;
	private File webModuleDirectory;
	private File archetypeLibrary;
	private File serviceDirectory;
	private File configurationDirectory;
	private List<String> parameters = new ArrayList<>();
	private Mode mode = Mode.Build;
	private Configuration.Repository releaseDistributionRepository;
	private Configuration.Repository snapshotDistributionRepository;

	public CompilerConfiguration() {
		setWarningLevel(1);
		setDebug(false);
		String encoding;
		encoding = System.getProperty("file.encoding", "UTF8");
		encoding = System.getProperty("tara.source.encoding", encoding);
		sourceEncoding(encoding);
		this.model = new DslConfiguration();
		try {
			tempDirectory = Files.createTempDirectory("_konos_").toFile();
		} catch (IOException e) {
			LOG.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
		}
	}

	public int getWarningLevel() {
		return this.warningLevel;
	}

	public void setWarningLevel(int level) {
		if ((level < 0) || (level > 3)) {
			this.warningLevel = 1;
		} else this.warningLevel = level;
	}

	public String sourceEncoding() {
		return this.sourceEncoding;
	}

	public void sourceEncoding(String encoding) {
		if (encoding == null) sourceEncoding = "UTF8";
		this.sourceEncoding = encoding;
	}

	public boolean getDebug() {
		return this.debug;
	}

	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	public File getTempDirectory() {
		return tempDirectory;
	}

	public String project() {
		return project;
	}

	public void setProject(String project) {
		this.project = project;
	}

	public String groupId() {
		return groupID;
	}

	public void groupId(String groupID) {
		this.groupID = groupID;
	}

	public String artifactId() {
		return artifactID;
	}

	public void artifactId(String artifactID) {
		this.artifactID = artifactID;
	}

	public String version() {
		return version;
	}

	public void version(String version) {
		this.version = version;
	}

	public void generationPackage(String generationPackage) {
		this.generationPackage = generationPackage;
	}

	public String generationPackage() {
		return generationPackage;
	}

	public String module() {
		return module;
	}

	public void module(String module) {
		this.module = module;
	}

	public DslConfiguration dsl() {
		return model;
	}

	public boolean isVerbose() {
		return verbose;
	}

	public void setVerbose(boolean verbose) {
		this.verbose = verbose;
	}

	public void intinoProjectDirectory(File intinoPath) {
		this.intinoProjectDirectory = intinoPath;
		this.configurationDirectory = new File(intinoProjectDirectory, "box" + File.separator + module);
		configurationDirectory.mkdirs();
	}

	public File intinoProjectDirectory() {
		return intinoProjectDirectory;
	}

	public List<File> sources() {
		return sources;
	}

	public File srcDirectory() {
		return srcDirectory;
	}

	public void srcDirectory(File srcDirectory) {
		this.srcDirectory = srcDirectory;
	}

	public void genDirectory(File directory) {
		if (directory != null) {
			this.genDirectory = directory;
			this.genDirectory.mkdirs();
		}
	}

	public File genDirectory() {
		return genDirectory;
	}

	public File serviceDirectory() {
		return webModuleDirectory;
	}

	public File moduleDirectory() {
		return serviceDirectory;
	}

	public File projectDirectory() {
		return projectDirectory;
	}

	public void serviceDirectory(File serviceDirectory) {
		this.webModuleDirectory = serviceDirectory;
	}

	public void moduleDirectory(File moduleDirectory) {
		this.serviceDirectory = moduleDirectory;
	}

	public void projectDirectory(File projectDirectory) {
		this.projectDirectory = projectDirectory;
	}

	public File configurationDirectory() {
		return configurationDirectory;
	}

	public File resDirectory() {
		return resDirectory;
	}

	public void resDirectory(File resDirectory) {
		this.resDirectory = resDirectory;
	}

	public File outDirectory() {
		return this.outDirectory;
	}

	public PrintStream out() {
		return out;
	}

	public void out(PrintStream out) {
		this.out = out;
	}

	public String parentInterface() {
		return parentInterface;
	}

	public void parentInterface(String parentInterface) {
		this.parentInterface = parentInterface;
	}

	public File datahubLibrary() {
		return datahubLibrary;
	}

	public void datahubLibrary(File datahubLibrary) {
		this.datahubLibrary = datahubLibrary;
	}

	public File archetypeLibrary() {
		return archetypeLibrary;
	}

	public void archetypeLibrary(File archetypeLibrary) {
		this.archetypeLibrary = archetypeLibrary;
	}

	public void parameters(String[] parameters) {
		this.parameters = List.of(parameters);
	}

	public List<String> parameters() {
		return parameters;
	}

	public void outDirectory(File file) {
		this.outDirectory = file;
	}

	public void mode(String mode) {
		this.mode = Mode.valueOf(mode);
	}

	public Mode mode() {
		return mode;
	}

	public List<String> currentDependencies() {
		return this.currentDependencies == null ? Collections.emptyList() : currentDependencies;
	}

	public CompilerConfiguration currentDependencies(List<String> currentDependencies) {
		this.currentDependencies = currentDependencies;
		return this;
	}

	public Configuration.Repository releaseDistributionRepository() {
		return this.releaseDistributionRepository;
	}

	public CompilerConfiguration releaseDistributionRepository(Configuration.Repository repository) {
		this.releaseDistributionRepository = repository;
		return this;
	}

	public Configuration.Repository snapshotDistributionRepository() {
		return this.snapshotDistributionRepository;
	}


	public CompilerConfiguration snapshotDistributionRepository(Configuration.Repository repository) {
		this.snapshotDistributionRepository = repository;
		return this;
	}

	public static class DslConfiguration {

		private String name;
		private Level level;
		private String outDsl;
		private String generationPackage;

		public String name() {
			return name;
		}

		public void outDsl(String outDsl) {
			this.outDsl = outDsl;
		}

		public String outDsl() {
			return outDsl;
		}

		public void name(String dsl) {
			this.name = dsl;
		}

		public void level(Level level) {
			this.level = level;
		}

		public Level level() {
			return level;
		}

		public String generationPackage() {
			return generationPackage;
		}

		public void generationPackage(String generationPackage) {
			this.generationPackage = generationPackage;
		}
	}

	public static class Language {
		Konos language;
		String name;
		String version;

		public Language(String name, String version) {
			this.name = name;
			this.version = version;
		}

		public Language(tara.dsl.Konos language) {
			this.language = language;
			this.name = this.language.languageName();
		}

		public Konos get() {
			return language == null ? (language = new Konos()) : language;
		}

		public String name() {
			return language == null ? name : language.languageName();
		}

		public String version() {
			return version;
		}

		public void version(String version) {
			this.version = version;
		}
	}
}
