/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.parser;

import io.intino.itrules.Logger;
import io.intino.itrules.dsl.ItrLexer;
import io.intino.itrules.dsl.ItrParser;
import io.intino.itrules.parser.ITRulesSyntaxError;
import io.intino.itrules.parser.Interpreter;
import io.intino.itrules.parser.TemplateErrorStrategy;
import io.intino.itrules.template.Template;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.io.IOUtils;

public final class TemplateParser {
    private final Logger logger = new Logger();

    public Template parse(InputStream stream, Charset charset) throws ITRulesSyntaxError {
        try {
            return this.parse(CharStreams.fromString((String)IOUtils.toString((InputStream)stream, (Charset)charset).trim()));
        }
        catch (IOException e) {
            this.logger.log(e.getMessage(), new Object[0]);
            return Template.EMPTY;
        }
    }

    private Template parse(CodePointCharStream stream) throws ITRulesSyntaxError {
        ItrLexer lexer = new ItrLexer((CharStream)stream);
        lexer.reset();
        lexer.setState(1);
        ItrParser parser = new ItrParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new TemplateErrorStrategy());
        ItrParser.RootContext root = this.parse(parser);
        parser.setErrorHandler((ANTLRErrorStrategy)new TemplateErrorStrategy());
        ParseTreeWalker walker = new ParseTreeWalker();
        Interpreter interpreter = new Interpreter(this.logger);
        walker.walk((ParseTreeListener)interpreter, (ParseTree)root);
        return interpreter.template();
    }

    private ItrParser.RootContext parse(ItrParser parser) throws ITRulesSyntaxError {
        try {
            return parser.root();
        }
        catch (RecognitionException e) {
            Token token = ((Parser)e.getRecognizer()).getCurrentToken();
            Token currentToken = ((Parser)e.getRecognizer()).getCurrentToken();
            this.logger.log("Rules not well formed. Error in: " + token.getLine() + ": " + token.getCharPositionInLine(), new Object[0]);
            throw new ITRulesSyntaxError("Template not well formed. Line:" + currentToken.getLine() + "; Column: " + currentToken.getCharPositionInLine() + ": " + e.getMessage());
        }
    }
}

