/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.services;

import io.intino.icod.Configuration;
import io.intino.icod.DocumentManager;
import io.intino.icod.InputMessage;
import io.intino.icod.OutputMessage;
import io.intino.icod.core.DefaultConfiguration;
import io.intino.icod.core.ErrorManager;
import io.intino.icod.core.ServerDocumentManager;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class Service {
    private Configuration configuration;
    private DocumentManager documentManager;
    protected static final Logger logger = Logger.getLogger("cotton.signatory");
    protected static final String ConfigurationFile = "cotton-signatory-server.config";

    protected Configuration loadConfiguration(InputMessage input, OutputMessage output) throws IOException {
        if (this.configuration != null) {
            return this.configuration;
        }
        this.configuration = new DefaultConfiguration();
        return this.configuration;
    }

    protected String checkId(InputMessage input, OutputMessage output) throws IOException {
        String id = input.getId();
        if (id != null) {
            return id;
        }
        this.throwFailure("ERR-05", output);
        return null;
    }

    protected String checkOperation(InputMessage input, String expectedOperation, OutputMessage output) throws IOException {
        String operation = input.getOperation();
        if (operation != null && expectedOperation.equalsIgnoreCase(operation)) {
            return operation;
        }
        this.throwFailure(operation == null ? "ERR-00" : "ERR-01", output);
        return null;
    }

    protected String checkSyntaxVersion(InputMessage input, OutputMessage output) throws IOException {
        String syntaxVersion = input.getSyntaxVersion();
        if (syntaxVersion != null) {
            return syntaxVersion;
        }
        this.throwFailure("ERR-20", output);
        return null;
    }

    protected void throwFailure(String failureMessage, OutputMessage output) {
        String errorMessage = ErrorManager.genError(failureMessage, null);
        logger.severe(errorMessage);
        output.write(errorMessage);
        throw new RuntimeException(errorMessage);
    }

    protected DocumentManager repository(Configuration configuration) {
        if (this.documentManager == null) {
            this.documentManager = new ServerDocumentManager(configuration);
        }
        return this.documentManager;
    }

    protected static class Operation {
        public static final String Store = "put";
        public static final String Retrieve = "get";

        protected Operation() {
        }
    }
}

