/*
 * Decompiled with CFR 0.152.
 */
package io.intino.icod.core;

import io.intino.icod.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class DefaultConfiguration
implements Configuration {
    private static String SIGNATURES_DIR;
    private static String REPOSITORY_DIR;
    private static final String CLIENT_APPLICATION_FILENAME = "AutoFirma1.4.1";
    private static final long DEFAULT_EXPIRATION_TIME = 300000L;

    @Override
    public String getSignaturesDirectory() {
        return SIGNATURES_DIR;
    }

    @Override
    public long getSignaturesExpirationTime() {
        return 300000L;
    }

    @Override
    public String getClientApplicationFilename(String operatingSystem) {
        return "AutoFirma1.4.1." + this.extensionOf(operatingSystem);
    }

    private String extensionOf(String os) {
        if (os.contains("macos")) {
            return "app";
        }
        if (os.contains("linux_rpm")) {
            return "rpm";
        }
        if (os.contains("linux_deb")) {
            return "deb";
        }
        if (os.contains("win")) {
            return "exe";
        }
        return null;
    }

    @Override
    public String getRepositoryDirectory() {
        return REPOSITORY_DIR;
    }

    static {
        try {
            SIGNATURES_DIR = System.getProperty("java.io.tmpdir") + "/cotton-signatory-signatures";
            REPOSITORY_DIR = System.getProperty("java.io.tmpdir") + "/cotton-signatory-repositories";
        }
        catch (Exception e) {
            try {
                SIGNATURES_DIR = File.createTempFile("tmp/cotton-signatory-signatures", null).getParentFile().getAbsolutePath();
                REPOSITORY_DIR = File.createTempFile("tmp/cotton-signatory-repository", null).getParentFile().getAbsolutePath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                SIGNATURES_DIR = null;
                REPOSITORY_DIR = null;
                Logger.getLogger("cotton.signatory").warning("No se ha podido cargar un directorio temporal por defecto, se debera configurar expresamente en el fichero de propiedades");
            }
        }
    }
}

