package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.ui.displays.components.*;
import io.intino.goros.unit.box.ui.*;

import io.intino.goros.unit.box.UnitBox;

import io.intino.goros.unit.box.ui.displays.templates.*;






import io.intino.goros.unit.box.ui.displays.items.*;
import io.intino.goros.unit.box.ui.displays.rows.*;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;

public abstract class AbstractTaskHistoryEntryLinkTemplate<B extends Box> extends io.intino.alexandria.ui.displays.components.Template<TemplateNotifier, java.lang.Void, B> {
	public Link link;
	public DocumentLink documentLink;
	public DocumentDialog documentDialog;
	public NodeDocumentTemplate documentStamp;

	public AbstractTaskHistoryEntryLinkTemplate(B box) {
		super(box);
		id("taskHistoryEntryLinkTemplate");
	}

	@Override
	public void init() {
		super.init();
		if (link == null) link = register(new Link(box()).<Link>id("a1355316771").owner(AbstractTaskHistoryEntryLinkTemplate.this));
		if (documentLink == null) documentLink = register(new DocumentLink(box()).<DocumentLink>id("a1678410974").owner(AbstractTaskHistoryEntryLinkTemplate.this));
		if (documentDialog == null) documentDialog = register(new DocumentDialog(box()).<DocumentDialog>id("a2110794028").owner(AbstractTaskHistoryEntryLinkTemplate.this));
		if (documentDialog != null) documentStamp = documentDialog.documentStamp;
		if (documentLink != null) documentLink.bindTo(documentDialog);
	}

	@Override
	public void remove() {
		super.remove();
		if (link != null) link.unregister();
		if (documentLink != null) documentLink.unregister();
		if (documentDialog != null) documentDialog.unregister();
	}

	public class Link extends io.intino.alexandria.ui.displays.components.OpenLayer<io.intino.alexandria.ui.displays.notifiers.OpenLayerNotifier, B> implements io.intino.alexandria.ui.displays.components.addressable.Addressed<Link> {

		public Link(B box) {
			super(box);
			_title("");
			_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Link"));
			_path("");
			_transition(io.intino.alexandria.ui.displays.components.OpenLayer.Transition.valueOf("Slide"));
		}

		@Override
		public void init() {
			super.init();
		}

		@Override
		public void unregister() {
			super.unregister();
		}
		@Override
		public Link address(java.util.function.Function<String, String> addressFromPathResolver) {
			address(addressFromPathResolver.apply(path()));
			return this;
		}
	}

	public class DocumentLink extends io.intino.alexandria.ui.displays.components.OpenDialog<io.intino.alexandria.ui.displays.notifiers.OpenDialogNotifier, B>  {

		public DocumentLink(B box) {
			super(box);
			_title("");
			_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Link"));
		}

		@Override
		public void init() {
			super.init();
		}

		@Override
		public void unregister() {
			super.unregister();
		}
	}

	public class DocumentDialog extends io.intino.alexandria.ui.displays.components.Dialog<io.intino.alexandria.ui.displays.notifiers.DialogNotifier, B>  {
		public NodeDocumentTemplate documentStamp;

		public DocumentDialog(B box) {
			super(box);
		}

		@Override
		public void init() {
			super.init();
			if (documentStamp == null) documentStamp = AbstractTaskHistoryEntryLinkTemplate.this.documentStamp = register(new NodeDocumentTemplate((UnitBox)box()).id("a_693044843"));
		}

		@Override
		public void unregister() {
			super.unregister();
			if (documentStamp != null) documentStamp.unregister();
		}
	}
}