package io.intino.goros.unit.box.rest.resources;

import java.util.List;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.goros.unit.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkPushService;

import io.intino.goros.unit.box.schemas.*;

public class PostUploadTaskPackedResource implements Resource {

	private UnitBox box;
	private SparkManager<SparkPushService> manager;

	public PostUploadTaskPackedResource(UnitBox box, SparkManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.goros.unit.box.actions.PostUploadTaskPackedAction()).execute());
	}

	private io.intino.goros.unit.box.actions.PostUploadTaskPackedAction fill(io.intino.goros.unit.box.actions.PostUploadTaskPackedAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.request = new io.intino.alexandria.Resource("request", manager.fromBodyAsBytes());
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(io.intino.alexandria.Resource object) {
		manager.write(object);
	}

	private io.intino.alexandria.http.spark.SparkContext context() {
		io.intino.alexandria.http.spark.SparkContext context = new io.intino.alexandria.http.spark.SparkContext(manager);

		context.put("ip", manager.ip());
		return context;
	}
}