package io.intino.goros.unit.box;

import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.goros.unit.box.rest.resources.*;
import io.intino.alexandria.core.Box;

public class FmsServiceService {

	public static AlexandriaSpark setup(AlexandriaSpark server, UnitBox box) {
		server.route("/servlet/fms").get(manager -> new GetFmsServiceDispatcherResource(box, manager).execute());
		server.route("/servlet/fms/image").get(manager -> new GetDownloadImageResource(box, manager).execute());
		server.route("/servlet/fms/document").get(manager -> new GetDownloadDocumentResource(box, manager).execute());

		return server;
	}
}